/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v3_1.osgi;

import io.fabric8.kubernetes.api.model.v3_1.ComponentStatus;
import io.fabric8.kubernetes.api.model.v3_1.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v3_1.ConfigMap;
import io.fabric8.kubernetes.api.model.v3_1.ConfigMapList;
import io.fabric8.kubernetes.api.model.v3_1.Doneable;
import io.fabric8.kubernetes.api.model.v3_1.DoneableComponentStatus;
import io.fabric8.kubernetes.api.model.v3_1.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.v3_1.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.v3_1.DoneableEvent;
import io.fabric8.kubernetes.api.model.v3_1.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.v3_1.DoneableNamespace;
import io.fabric8.kubernetes.api.model.v3_1.DoneableNode;
import io.fabric8.kubernetes.api.model.v3_1.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.v3_1.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v3_1.DoneablePod;
import io.fabric8.kubernetes.api.model.v3_1.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.v3_1.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.v3_1.DoneableSecret;
import io.fabric8.kubernetes.api.model.v3_1.DoneableService;
import io.fabric8.kubernetes.api.model.v3_1.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.v3_1.DoneableStorageClass;
import io.fabric8.kubernetes.api.model.v3_1.Endpoints;
import io.fabric8.kubernetes.api.model.v3_1.EndpointsList;
import io.fabric8.kubernetes.api.model.v3_1.Event;
import io.fabric8.kubernetes.api.model.v3_1.EventList;
import io.fabric8.kubernetes.api.model.v3_1.HasMetadata;
import io.fabric8.kubernetes.api.model.v3_1.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v3_1.LimitRange;
import io.fabric8.kubernetes.api.model.v3_1.LimitRangeList;
import io.fabric8.kubernetes.api.model.v3_1.Namespace;
import io.fabric8.kubernetes.api.model.v3_1.NamespaceList;
import io.fabric8.kubernetes.api.model.v3_1.Node;
import io.fabric8.kubernetes.api.model.v3_1.NodeList;
import io.fabric8.kubernetes.api.model.v3_1.PersistentVolume;
import io.fabric8.kubernetes.api.model.v3_1.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v3_1.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v3_1.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v3_1.Pod;
import io.fabric8.kubernetes.api.model.v3_1.PodList;
import io.fabric8.kubernetes.api.model.v3_1.ReplicationController;
import io.fabric8.kubernetes.api.model.v3_1.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v3_1.ResourceQuota;
import io.fabric8.kubernetes.api.model.v3_1.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v3_1.RootPaths;
import io.fabric8.kubernetes.api.model.v3_1.Secret;
import io.fabric8.kubernetes.api.model.v3_1.SecretList;
import io.fabric8.kubernetes.api.model.v3_1.ServiceAccount;
import io.fabric8.kubernetes.api.model.v3_1.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v3_1.ServiceList;
import io.fabric8.kubernetes.api.model.v3_1.StorageClass;
import io.fabric8.kubernetes.api.model.v3_1.StorageClassList;
import io.fabric8.kubernetes.api.model.v3_1.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.v3_1.apiextensions.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.v3_1.apiextensions.DoneableCustomResourceDefinition;
import io.fabric8.kubernetes.api.model.v3_1.extensions.DoneablePodSecurityPolicy;
import io.fabric8.kubernetes.api.model.v3_1.extensions.PodSecurityPolicy;
import io.fabric8.kubernetes.api.model.v3_1.extensions.PodSecurityPolicyList;
import io.fabric8.kubernetes.clnt.v3_1.Adapters;
import io.fabric8.kubernetes.clnt.v3_1.BaseClient;
import io.fabric8.kubernetes.clnt.v3_1.Config;
import io.fabric8.kubernetes.clnt.v3_1.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v3_1.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v3_1.ExtensionAdapter;
import io.fabric8.kubernetes.clnt.v3_1.Handlers;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClient;
import io.fabric8.kubernetes.clnt.v3_1.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v3_1.RequestConfig;
import io.fabric8.kubernetes.clnt.v3_1.ResourceHandler;
import io.fabric8.kubernetes.clnt.v3_1.VersionInfo;
import io.fabric8.kubernetes.clnt.v3_1.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v3_1.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v3_1.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v3_1.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v3_1.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v3_1.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v3_1.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v3_1.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v3_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v3_1.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v3_1.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v3_1.dsl.Resource;
import io.fabric8.kubernetes.clnt.v3_1.dsl.RollableScalableResource;
import io.fabric8.openshift.api.model.v3_1.DoneableSecurityContextConstraints;
import io.fabric8.openshift.api.model.v3_1.SecurityContextConstraints;
import io.fabric8.openshift.api.model.v3_1.SecurityContextConstraintsList;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true, configurationPid="io.fabric8.kubernetes.clnt.v3_1", policy=ConfigurationPolicy.OPTIONAL)
@Service(value={KubernetesClient.class, NamespacedKubernetesClient.class})
@References(value={@Reference(referenceInterface=ResourceHandler.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindResourceHandler", unbind="unbindResourceHandler"), @Reference(referenceInterface=ExtensionAdapter.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindExtensionAdapter", unbind="unbindExtensionAdapter")})
public class ManagedKubernetesClient
extends BaseClient
implements NamespacedKubernetesClient {
    private NamespacedKubernetesClient delegate;

    @Activate
    public void activate(Map<String, Object> properties) {
        ConfigBuilder builder = new ConfigBuilder();
        if (properties.containsKey("kubernetes.master")) {
            builder.withMasterUrl((String)properties.get("kubernetes.master"));
        }
        if (properties.containsKey("kubernetes.api.version")) {
            builder.withApiVersion((String)properties.get("kubernetes.api.version"));
        }
        if (properties.containsKey("kubernetes.namespace")) {
            builder.withNamespace((String)properties.get("kubernetes.namespace"));
        }
        if (properties.containsKey("kubernetes.certs.ca.file")) {
            builder.withCaCertFile((String)properties.get("kubernetes.certs.ca.file"));
        }
        if (properties.containsKey("kubernetes.certs.ca.data")) {
            builder.withCaCertData((String)properties.get("kubernetes.certs.ca.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.file")) {
            builder.withClientCertFile((String)properties.get("kubernetes.certs.client.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.data")) {
            builder.withClientCertData((String)properties.get("kubernetes.certs.client.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.file")) {
            builder.withClientKeyFile((String)properties.get("kubernetes.certs.client.key.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.data")) {
            builder.withClientKeyData((String)properties.get("kubernetes.certs.client.key.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.algo")) {
            builder.withClientKeyAlgo((String)properties.get("kubernetes.certs.client.key.algo"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.passphrase")) {
            builder.withClientKeyPassphrase((String)properties.get("kubernetes.certs.client.key.passphrase"));
        }
        if (properties.containsKey("kubernetes.auth.basic.username")) {
            builder.withUsername((String)properties.get("kubernetes.auth.basic.username"));
        }
        if (properties.containsKey("kubernetes.auth.basic.password")) {
            builder.withPassword((String)properties.get("kubernetes.auth.basic.password"));
        }
        if (properties.containsKey("kubernetes.auth.token")) {
            builder.withOauthToken((String)properties.get("kubernetes.auth.token"));
        }
        if (properties.containsKey("kubernetes.watch.reconnectInterval")) {
            builder.withWatchReconnectInterval(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectInterval")));
        }
        if (properties.containsKey("kubernetes.watch.reconnectLimit")) {
            builder.withWatchReconnectLimit(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectLimit")));
        }
        if (properties.containsKey("kubernetes.request.timeout")) {
            builder.withRequestTimeout(Integer.parseInt((String)properties.get("kubernetes.request.timeout")));
        }
        if (properties.containsKey("http.proxy")) {
            builder.withHttpProxy((String)properties.get("http.proxy"));
        }
        if (properties.containsKey("https.proxy")) {
            builder.withHttpsProxy((String)properties.get("https.proxy"));
        }
        if (properties.containsKey("no.proxy")) {
            String noProxyProperty = (String)properties.get("no.proxy");
            builder.withNoProxy(noProxyProperty.split(","));
        }
        if (properties.containsKey("kubernetes.websocket.timeout")) {
            builder.withWebsocketTimeout(Long.parseLong((String)properties.get("kubernetes.websocket.timeout")));
        }
        if (properties.containsKey("kubernetes.websocket.ping.interval")) {
            builder.withWebsocketPingInterval(Long.parseLong((String)properties.get("kubernetes.websocket.ping.interval")));
        }
        if (properties.containsKey("kubernetes.truststore.file")) {
            builder.withTrustStoreFile((String)properties.get("kubernetes.truststore.file"));
        }
        if (properties.containsKey("kubernetes.truststore.passphrase")) {
            builder.withTrustStorePassphrase((String)properties.get("kubernetes.truststore.passphrase"));
        }
        if (properties.containsKey("kubernetes.keystore.file")) {
            builder.withKeyStoreFile((String)properties.get("kubernetes.keystore.file"));
        }
        if (properties.containsKey("kubernetes.keystore.passphrase")) {
            builder.withKeyStorePassphrase((String)properties.get("kubernetes.keystore.passphrase"));
        }
        this.delegate = new DefaultKubernetesClient(builder.build());
    }

    @Deactivate
    public void deactivate() {
        this.delegate.close();
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata ... items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata is) {
        return this.delegate.resource(is);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<io.fabric8.kubernetes.api.model.v3_1.Service, ServiceList, DoneableService, Resource<io.fabric8.kubernetes.api.model.v3_1.Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, Resource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return this.delegate.securityContextConstraints();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<StorageClass, StorageClassList, DoneableStorageClass, Resource<StorageClass, DoneableStorageClass>> storageClasses() {
        return this.delegate.storageClasses();
    }

    @Override
    public MixedOperation<PodSecurityPolicy, PodSecurityPolicyList, DoneablePodSecurityPolicy, Resource<PodSecurityPolicy, DoneablePodSecurityPolicy>> podSecurityPolicies() {
        return this.delegate.podSecurityPolicies();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public VersionInfo getVersion() {
        return this.delegate.getVersion();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.delegate.apps();
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.delegate.autoscaling();
    }

    @Override
    public NonNamespaceOperation<CustomResourceDefinition, CustomResourceDefinitionList, DoneableCustomResourceDefinition, Resource<CustomResourceDefinition, DoneableCustomResourceDefinition>> customResourceDefinitions() {
        return this.delegate.customResourceDefinitions();
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResources(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.delegate.customResources(crd, resourceType, listClass, doneClass);
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>> MixedOperation<T, L, D, Resource<T, D>> customResource(CustomResourceDefinition crd, Class<T> resourceType, Class<L> listClass, Class<D> doneClass) {
        return this.customResources(crd, resourceType, listClass, doneClass);
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public void bindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.register(resourceHandler);
    }

    public void unbindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.unregister(resourceHandler);
    }

    public void bindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.register(adapter);
    }

    public void unbindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.unregister(adapter);
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return (NamespacedKubernetesClient)this.delegate.inAnyNamespace();
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String name) {
        return (NamespacedKubernetesClient)this.delegate.inNamespace(name);
    }

    @Override
    public FunctionCallable<NamespacedKubernetesClient> withRequestConfig(RequestConfig requestConfig) {
        return this.delegate.withRequestConfig(requestConfig);
    }
}

