/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v3_1.server.mock;

import io.fabric8.kubernetes.api.model.v3_1.HasMetadata;
import io.fabric8.kubernetes.api.model.v3_1.KubernetesList;
import io.fabric8.kubernetes.api.model.v3_1.KubernetesListBuilder;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v3_1.utils.Serialization;
import io.fabric8.mockwebserver.crud.ResponseComposer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;

public class KubernetesResponseComposer
implements ResponseComposer {
    public String compose(Collection<String> collection) {
        ArrayList<HasMetadata> items = new ArrayList<HasMetadata>();
        for (String item : collection) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(item.getBytes(StandardCharsets.UTF_8.name()));
                Throwable throwable = null;
                try {
                    HasMetadata h = (HasMetadata)Serialization.unmarshal(stream);
                    items.add(h);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)stream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)stream).close();
                }
            }
            catch (Exception e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
        KubernetesList list = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(items)).build();
        return Serialization.asJson(list);
    }
}

