/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v3_0;

import io.fabric8.kubernetes.clnt.v3_0.Client;
import io.fabric8.kubernetes.clnt.v3_0.ExtensionAdapter;
import io.fabric8.openshift.clnt.v3_0.DefaultOpenShiftClient;
import io.fabric8.openshift.clnt.v3_0.OpenShiftClient;
import io.fabric8.openshift.clnt.v3_0.OpenShiftConfig;
import io.fabric8.openshift.clnt.v3_0.OpenShiftNotAvailableException;
import io.fabric8.openshift.clnt.v3_0.OpenshiftAdapterSupport;
import okhttp3.OkHttpClient;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
public class OpenShiftExtensionAdapter
extends OpenshiftAdapterSupport
implements ExtensionAdapter<OpenShiftClient> {
    @Override
    public Class<OpenShiftClient> getExtensionType() {
        return OpenShiftClient.class;
    }

    @Override
    public OpenShiftClient adapt(Client client) {
        if (!this.isAdaptable(client).booleanValue()) {
            throw new OpenShiftNotAvailableException("OpenShift is not available. Root paths at: " + client.getMasterUrl() + " do not include oapi.");
        }
        return new DefaultOpenShiftClient(client.adapt(OkHttpClient.class), OpenShiftConfig.wrap(client.getConfiguration()));
    }
}

