/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v3_0;

import io.fabric8.kubernetes.api.builder.v3_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_0.VisitableBuilder;
import io.fabric8.openshift.api.model.v3_0.StageInfo;
import io.fabric8.openshift.api.model.v3_0.StageInfoFluent;
import io.fabric8.openshift.api.model.v3_0.StageInfoFluentImpl;

public class StageInfoBuilder
extends StageInfoFluentImpl<StageInfoBuilder>
implements VisitableBuilder<StageInfo, StageInfoBuilder> {
    StageInfoFluent<?> fluent;
    Boolean validationEnabled;

    public StageInfoBuilder() {
        this(true);
    }

    public StageInfoBuilder(Boolean validationEnabled) {
        this(new StageInfo(), validationEnabled);
    }

    public StageInfoBuilder(StageInfoFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public StageInfoBuilder(StageInfoFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StageInfo(), validationEnabled);
    }

    public StageInfoBuilder(StageInfoFluent<?> fluent, StageInfo instance) {
        this(fluent, instance, true);
    }

    public StageInfoBuilder(StageInfoFluent<?> fluent, StageInfo instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDurationMilliseconds(instance.getDurationMilliseconds());
        fluent.withName(instance.getName());
        fluent.withStartTime(instance.getStartTime());
        fluent.withSteps(instance.getSteps());
        this.validationEnabled = validationEnabled;
    }

    public StageInfoBuilder(StageInfo instance) {
        this(instance, (Boolean)true);
    }

    public StageInfoBuilder(StageInfo instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDurationMilliseconds(instance.getDurationMilliseconds());
        this.withName(instance.getName());
        this.withStartTime(instance.getStartTime());
        this.withSteps(instance.getSteps());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StageInfo build() {
        StageInfo buildable = new StageInfo(this.fluent.getDurationMilliseconds(), this.fluent.getName(), this.fluent.getStartTime(), this.fluent.getSteps());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StageInfoBuilder that = (StageInfoBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

