/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v3_0;

import io.fabric8.kubernetes.api.builder.v3_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_0.VisitableBuilder;
import io.fabric8.openshift.api.model.v3_0.ClusterPolicy;
import io.fabric8.openshift.api.model.v3_0.ClusterPolicyFluent;
import io.fabric8.openshift.api.model.v3_0.ClusterPolicyFluentImpl;

public class ClusterPolicyBuilder
extends ClusterPolicyFluentImpl<ClusterPolicyBuilder>
implements VisitableBuilder<ClusterPolicy, ClusterPolicyBuilder> {
    ClusterPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterPolicyBuilder() {
        this(true);
    }

    public ClusterPolicyBuilder(Boolean validationEnabled) {
        this(new ClusterPolicy(), validationEnabled);
    }

    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterPolicy(), validationEnabled);
    }

    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent, ClusterPolicy instance) {
        this(fluent, instance, true);
    }

    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent, ClusterPolicy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withLastModified(instance.getLastModified());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRoles(instance.getRoles());
        this.validationEnabled = validationEnabled;
    }

    public ClusterPolicyBuilder(ClusterPolicy instance) {
        this(instance, (Boolean)true);
    }

    public ClusterPolicyBuilder(ClusterPolicy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLastModified(instance.getLastModified());
        this.withMetadata(instance.getMetadata());
        this.withRoles(instance.getRoles());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ClusterPolicy build() {
        ClusterPolicy buildable = new ClusterPolicy(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getLastModified(), this.fluent.getMetadata(), this.fluent.getRoles());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterPolicyBuilder that = (ClusterPolicyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

