/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v3_0;

import io.fabric8.kubernetes.api.builder.v3_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_0.Nested;
import io.fabric8.kubernetes.api.builder.v3_0.Predicate;
import io.fabric8.kubernetes.api.model.v3_0.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v3_0.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v3_0.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v3_0.BinaryBuildSource;
import io.fabric8.openshift.api.model.v3_0.BinaryBuildSourceBuilder;
import io.fabric8.openshift.api.model.v3_0.BinaryBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.v3_0.BuildSource;
import io.fabric8.openshift.api.model.v3_0.BuildSourceFluent;
import io.fabric8.openshift.api.model.v3_0.GitBuildSource;
import io.fabric8.openshift.api.model.v3_0.GitBuildSourceBuilder;
import io.fabric8.openshift.api.model.v3_0.GitBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.v3_0.ImageSource;
import io.fabric8.openshift.api.model.v3_0.ImageSourceBuilder;
import io.fabric8.openshift.api.model.v3_0.ImageSourceFluentImpl;
import io.fabric8.openshift.api.model.v3_0.SecretBuildSource;
import io.fabric8.openshift.api.model.v3_0.SecretBuildSourceBuilder;
import io.fabric8.openshift.api.model.v3_0.SecretBuildSourceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BuildSourceFluentImpl<A extends BuildSourceFluent<A>>
extends BaseFluent<A>
implements BuildSourceFluent<A> {
    private BinaryBuildSourceBuilder binary;
    private String contextDir;
    private String dockerfile;
    private GitBuildSourceBuilder git;
    private List<ImageSourceBuilder> images = new ArrayList<ImageSourceBuilder>();
    private List<SecretBuildSourceBuilder> secrets = new ArrayList<SecretBuildSourceBuilder>();
    private LocalObjectReferenceBuilder sourceSecret;
    private String type;

    public BuildSourceFluentImpl() {
    }

    public BuildSourceFluentImpl(BuildSource instance) {
        this.withBinary(instance.getBinary());
        this.withContextDir(instance.getContextDir());
        this.withDockerfile(instance.getDockerfile());
        this.withGit(instance.getGit());
        this.withImages(instance.getImages());
        this.withSecrets(instance.getSecrets());
        this.withSourceSecret(instance.getSourceSecret());
        this.withType(instance.getType());
    }

    @Override
    @Deprecated
    public BinaryBuildSource getBinary() {
        return this.binary != null ? this.binary.build() : null;
    }

    @Override
    public BinaryBuildSource buildBinary() {
        return this.binary != null ? this.binary.build() : null;
    }

    @Override
    public A withBinary(BinaryBuildSource binary) {
        this._visitables.remove(this.binary);
        if (binary != null) {
            this.binary = new BinaryBuildSourceBuilder(binary);
            this._visitables.add(this.binary);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBinary() {
        return this.binary != null;
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> withNewBinary() {
        return new BinaryNestedImpl();
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item) {
        return new BinaryNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> editBinary() {
        return this.withNewBinaryLike(this.getBinary());
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> editOrNewBinary() {
        return this.withNewBinaryLike(this.getBinary() != null ? this.getBinary() : new BinaryBuildSourceBuilder().build());
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item) {
        return this.withNewBinaryLike(this.getBinary() != null ? this.getBinary() : item);
    }

    @Override
    public A withNewBinary(String asFile) {
        return this.withBinary(new BinaryBuildSource(asFile));
    }

    @Override
    public String getContextDir() {
        return this.contextDir;
    }

    @Override
    public A withContextDir(String contextDir) {
        this.contextDir = contextDir;
        return (A)this;
    }

    @Override
    public Boolean hasContextDir() {
        return this.contextDir != null;
    }

    @Override
    public String getDockerfile() {
        return this.dockerfile;
    }

    @Override
    public A withDockerfile(String dockerfile) {
        this.dockerfile = dockerfile;
        return (A)this;
    }

    @Override
    public Boolean hasDockerfile() {
        return this.dockerfile != null;
    }

    @Override
    @Deprecated
    public GitBuildSource getGit() {
        return this.git != null ? this.git.build() : null;
    }

    @Override
    public GitBuildSource buildGit() {
        return this.git != null ? this.git.build() : null;
    }

    @Override
    public A withGit(GitBuildSource git) {
        this._visitables.remove(this.git);
        if (git != null) {
            this.git = new GitBuildSourceBuilder(git);
            this._visitables.add(this.git);
        }
        return (A)this;
    }

    @Override
    public Boolean hasGit() {
        return this.git != null;
    }

    @Override
    public BuildSourceFluent.GitNested<A> withNewGit() {
        return new GitNestedImpl();
    }

    @Override
    public BuildSourceFluent.GitNested<A> withNewGitLike(GitBuildSource item) {
        return new GitNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.GitNested<A> editGit() {
        return this.withNewGitLike(this.getGit());
    }

    @Override
    public BuildSourceFluent.GitNested<A> editOrNewGit() {
        return this.withNewGitLike(this.getGit() != null ? this.getGit() : new GitBuildSourceBuilder().build());
    }

    @Override
    public BuildSourceFluent.GitNested<A> editOrNewGitLike(GitBuildSource item) {
        return this.withNewGitLike(this.getGit() != null ? this.getGit() : item);
    }

    @Override
    public A withNewGit(String httpProxy, String httpsProxy, String noProxy, String ref, String uri) {
        return this.withGit(new GitBuildSource(httpProxy, httpsProxy, noProxy, ref, uri));
    }

    @Override
    public A addToImages(int index, ImageSource item) {
        ImageSourceBuilder builder = new ImageSourceBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.images.add(index >= 0 ? index : this.images.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImages(int index, ImageSource item) {
        ImageSourceBuilder builder = new ImageSourceBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.images.size()) {
            this.images.add(builder);
        } else {
            this.images.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImages(ImageSource ... items) {
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImages(Collection<ImageSource> items) {
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImages(ImageSource ... items) {
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.remove(builder);
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImages(Collection<ImageSource> items) {
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.remove(builder);
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageSource> getImages() {
        return BuildSourceFluentImpl.build(this.images);
    }

    @Override
    public List<ImageSource> buildImages() {
        return BuildSourceFluentImpl.build(this.images);
    }

    @Override
    public ImageSource buildImage(int index) {
        return this.images.get(index).build();
    }

    @Override
    public ImageSource buildFirstImage() {
        return this.images.get(0).build();
    }

    @Override
    public ImageSource buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    @Override
    public ImageSource buildMatchingImage(Predicate<ImageSourceBuilder> predicate) {
        for (ImageSourceBuilder item : this.images) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withImages(List<ImageSource> images) {
        this._visitables.removeAll(this.images);
        this.images.clear();
        if (images != null) {
            for (ImageSource item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withImages(ImageSource ... images) {
        this.images.clear();
        if (images != null) {
            for (ImageSource item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> addNewImageLike(ImageSource item) {
        return new ImagesNestedImpl(-1, item);
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> setNewImageLike(int index, ImageSource item) {
        return new ImagesNestedImpl(index, item);
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> editMatchingImage(Predicate<ImageSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.apply(this.images.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public A addToSecrets(int index, SecretBuildSource item) {
        SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.secrets.add(index >= 0 ? index : this.secrets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSecrets(int index, SecretBuildSource item) {
        SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.secrets.size()) {
            this.secrets.add(builder);
        } else {
            this.secrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSecrets(SecretBuildSource ... items) {
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecrets(Collection<SecretBuildSource> items) {
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecrets(SecretBuildSource ... items) {
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecrets(Collection<SecretBuildSource> items) {
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.remove(builder);
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SecretBuildSource> getSecrets() {
        return BuildSourceFluentImpl.build(this.secrets);
    }

    @Override
    public List<SecretBuildSource> buildSecrets() {
        return BuildSourceFluentImpl.build(this.secrets);
    }

    @Override
    public SecretBuildSource buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    @Override
    public SecretBuildSource buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    @Override
    public SecretBuildSource buildLastSecret() {
        return this.secrets.get(this.secrets.size() - 1).build();
    }

    @Override
    public SecretBuildSource buildMatchingSecret(Predicate<SecretBuildSourceBuilder> predicate) {
        for (SecretBuildSourceBuilder item : this.secrets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withSecrets(List<SecretBuildSource> secrets) {
        this._visitables.removeAll(this.secrets);
        this.secrets.clear();
        if (secrets != null) {
            for (SecretBuildSource item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSecrets(SecretBuildSource ... secrets) {
        this.secrets.clear();
        if (secrets != null) {
            for (SecretBuildSource item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> addNewSecret() {
        return new SecretsNestedImpl();
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> addNewSecretLike(SecretBuildSource item) {
        return new SecretsNestedImpl(-1, item);
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> setNewSecretLike(int index, SecretBuildSource item) {
        return new SecretsNestedImpl(index, item);
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> editSecret(int index) {
        if (this.secrets.size() <= index) {
            throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> editFirstSecret() {
        if (this.secrets.size() == 0) {
            throw new RuntimeException("Can't edit first secrets. The list is empty.");
        }
        return this.setNewSecretLike(0, this.buildSecret(0));
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> editLastSecret() {
        int index = this.secrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secrets. The list is empty.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> editMatchingSecret(Predicate<SecretBuildSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!predicate.apply(this.secrets.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secrets. No match found.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    @Deprecated
    public LocalObjectReference getSourceSecret() {
        return this.sourceSecret != null ? this.sourceSecret.build() : null;
    }

    @Override
    public LocalObjectReference buildSourceSecret() {
        return this.sourceSecret != null ? this.sourceSecret.build() : null;
    }

    @Override
    public A withSourceSecret(LocalObjectReference sourceSecret) {
        this._visitables.remove(this.sourceSecret);
        if (sourceSecret != null) {
            this.sourceSecret = new LocalObjectReferenceBuilder(sourceSecret);
            this._visitables.add(this.sourceSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSourceSecret() {
        return this.sourceSecret != null;
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecret() {
        return new SourceSecretNestedImpl();
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecretLike(LocalObjectReference item) {
        return new SourceSecretNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> editSourceSecret() {
        return this.withNewSourceSecretLike(this.getSourceSecret());
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> editOrNewSourceSecret() {
        return this.withNewSourceSecretLike(this.getSourceSecret() != null ? this.getSourceSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> editOrNewSourceSecretLike(LocalObjectReference item) {
        return this.withNewSourceSecretLike(this.getSourceSecret() != null ? this.getSourceSecret() : item);
    }

    @Override
    public A withNewSourceSecret(String name) {
        return this.withSourceSecret(new LocalObjectReference(name));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildSourceFluentImpl that = (BuildSourceFluentImpl)o;
        if (this.binary != null ? !this.binary.equals(that.binary) : that.binary != null) {
            return false;
        }
        if (this.contextDir != null ? !this.contextDir.equals(that.contextDir) : that.contextDir != null) {
            return false;
        }
        if (this.dockerfile != null ? !this.dockerfile.equals(that.dockerfile) : that.dockerfile != null) {
            return false;
        }
        if (this.git != null ? !this.git.equals(that.git) : that.git != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) {
            return false;
        }
        if (this.sourceSecret != null ? !this.sourceSecret.equals(that.sourceSecret) : that.sourceSecret != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public class SourceSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<BuildSourceFluent.SourceSecretNested<N>>
    implements BuildSourceFluent.SourceSecretNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        SourceSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SourceSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withSourceSecret(this.builder.build());
        }

        @Override
        public N endSourceSecret() {
            return this.and();
        }
    }

    public class SecretsNestedImpl<N>
    extends SecretBuildSourceFluentImpl<BuildSourceFluent.SecretsNested<N>>
    implements BuildSourceFluent.SecretsNested<N>,
    Nested<N> {
        private final SecretBuildSourceBuilder builder;
        private final int index;

        SecretsNestedImpl(int index, SecretBuildSource item) {
            this.index = index;
            this.builder = new SecretBuildSourceBuilder(this, item);
        }

        SecretsNestedImpl() {
            this.index = -1;
            this.builder = new SecretBuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.setToSecrets(this.index, this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }

    public class ImagesNestedImpl<N>
    extends ImageSourceFluentImpl<BuildSourceFluent.ImagesNested<N>>
    implements BuildSourceFluent.ImagesNested<N>,
    Nested<N> {
        private final ImageSourceBuilder builder;
        private final int index;

        ImagesNestedImpl(int index, ImageSource item) {
            this.index = index;
            this.builder = new ImageSourceBuilder(this, item);
        }

        ImagesNestedImpl() {
            this.index = -1;
            this.builder = new ImageSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.setToImages(this.index, this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }

    public class GitNestedImpl<N>
    extends GitBuildSourceFluentImpl<BuildSourceFluent.GitNested<N>>
    implements BuildSourceFluent.GitNested<N>,
    Nested<N> {
        private final GitBuildSourceBuilder builder;

        GitNestedImpl(GitBuildSource item) {
            this.builder = new GitBuildSourceBuilder(this, item);
        }

        GitNestedImpl() {
            this.builder = new GitBuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withGit(this.builder.build());
        }

        @Override
        public N endGit() {
            return this.and();
        }
    }

    public class BinaryNestedImpl<N>
    extends BinaryBuildSourceFluentImpl<BuildSourceFluent.BinaryNested<N>>
    implements BuildSourceFluent.BinaryNested<N>,
    Nested<N> {
        private final BinaryBuildSourceBuilder builder;

        BinaryNestedImpl(BinaryBuildSource item) {
            this.builder = new BinaryBuildSourceBuilder(this, item);
        }

        BinaryNestedImpl() {
            this.builder = new BinaryBuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withBinary(this.builder.build());
        }

        @Override
        public N endBinary() {
            return this.and();
        }
    }
}

