/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v3_0.dsl.internal;

import io.fabric8.kubernetes.api.model.v3_0.DoneablePod;
import io.fabric8.kubernetes.api.model.v3_0.Pod;
import io.fabric8.kubernetes.api.model.v3_0.PodList;
import io.fabric8.kubernetes.clnt.v3_0.Config;
import io.fabric8.kubernetes.clnt.v3_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v3_0.LocalPortForward;
import io.fabric8.kubernetes.clnt.v3_0.PortForward;
import io.fabric8.kubernetes.clnt.v3_0.Watch;
import io.fabric8.kubernetes.clnt.v3_0.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v3_0.dsl.ContainerResource;
import io.fabric8.kubernetes.clnt.v3_0.dsl.ExecListenable;
import io.fabric8.kubernetes.clnt.v3_0.dsl.ExecListener;
import io.fabric8.kubernetes.clnt.v3_0.dsl.ExecWatch;
import io.fabric8.kubernetes.clnt.v3_0.dsl.Execable;
import io.fabric8.kubernetes.clnt.v3_0.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v3_0.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v3_0.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v3_0.dsl.PrettyLoggable;
import io.fabric8.kubernetes.clnt.v3_0.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v3_0.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.clnt.v3_0.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.clnt.v3_0.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.clnt.v3_0.dsl.TtyExecable;
import io.fabric8.kubernetes.clnt.v3_0.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v3_0.dsl.internal.ExecWebSocketListener;
import io.fabric8.kubernetes.clnt.v3_0.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.clnt.v3_0.dsl.internal.PortForwarderWebsocket;
import io.fabric8.kubernetes.clnt.v3_0.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v3_0.internal.readiness.ReadinessWatcher;
import io.fabric8.kubernetes.clnt.v3_0.utils.URLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.WebSocketListener;

public class PodOperationsImpl
extends HasMetadataOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>>
implements PodResource<Pod, DoneablePod> {
    private static final String[] EMPTY_COMMAND = new String[]{"/bin/sh", "-i"};
    private final String containerId;
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;
    private final PipedOutputStream inPipe;
    private final PipedInputStream outPipe;
    private final PipedInputStream errPipe;
    private final boolean withTTY;
    private final boolean withTerminatedStatus;
    private final boolean withTimestamps;
    private final String sinceTimestamp;
    private final Integer sinceSeconds;
    private final Integer withTailingLines;
    private final boolean withPrettyOutput;
    private final ExecListener execListener;
    private final Integer limitBytes;

    public PodOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, null, namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public PodOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, Pod item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        this(client, config, apiVersion, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, null, null, null, null, null, null, null, false, false, false, null, null, null, false, null, null);
    }

    public PodOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, Pod item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, String containerId, InputStream in, PipedOutputStream inPipe, OutputStream out, PipedInputStream outPipe, OutputStream err, PipedInputStream errPipe, boolean withTTY, boolean withTerminatedStatus, boolean withTimestamps, String sinceTimestamp, Integer sinceSeconds, Integer withTailingLines, boolean withPrettyOutput, ExecListener execListener, Integer limitBytes) {
        super(client, config, null, apiVersion, "pods", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.containerId = containerId;
        this.in = in;
        this.inPipe = inPipe;
        this.out = out;
        this.outPipe = outPipe;
        this.err = err;
        this.errPipe = errPipe;
        this.withTTY = withTTY;
        this.withTerminatedStatus = withTerminatedStatus;
        this.withTimestamps = withTimestamps;
        this.sinceTimestamp = sinceTimestamp;
        this.sinceSeconds = sinceSeconds;
        this.withTailingLines = withTailingLines;
        this.withPrettyOutput = withPrettyOutput;
        this.execListener = execListener;
        this.limitBytes = limitBytes;
    }

    protected String getLogParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append("log?pretty=").append(this.withPrettyOutput);
        if (this.containerId != null && !this.containerId.isEmpty()) {
            sb.append("&container=").append(this.containerId);
        }
        if (this.withTerminatedStatus) {
            sb.append("&previous=true");
        }
        if (this.sinceSeconds != null) {
            sb.append("&sinceSeconds=").append(this.sinceSeconds);
        } else if (this.sinceTimestamp != null) {
            sb.append("&sinceTime=").append(this.sinceTimestamp);
        }
        if (this.withTailingLines != null) {
            sb.append("&tailLines=").append(this.withTailingLines);
        }
        if (this.limitBytes != null) {
            sb.append("&limitBytes=").append(this.limitBytes);
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getLog() {
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), this.getLogParameters()));
            Request.Builder requestBuilder = new Request.Builder().get().url(url);
            Request request = requestBuilder.build();
            Response response = this.client.newCall(request).execute();
            try (ResponseBody body = response.body();){
                this.assertResponseCode(request, response);
                String string = body.string();
                return string;
            }
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("getLog"), t);
        }
    }

    @Override
    public String getLog(Boolean isPretty) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, isPretty, this.execListener, this.limitBytes).getLog();
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), this.getLogParameters() + "&follow=true"));
            Request request = new Request.Builder().url(url).get().build();
            LogWatchCallback callback = new LogWatchCallback(out);
            OkHttpClient clone = this.client.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            clone.newCall(request).enqueue((Callback)callback);
            callback.waitUntilReady();
            return callback;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("watchLog"), t);
        }
    }

    @Override
    public PortForward portForward(int port, ReadableByteChannel in, WritableByteChannel out) {
        try {
            return new PortForwarderWebsocket(this.client).forward(this.getResourceUrl(), port, in, out);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public LocalPortForward portForward(int port) {
        try {
            return new PortForwarderWebsocket(this.client).forward(this.getResourceUrl(), port);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public LocalPortForward portForward(int port, int localPort) {
        try {
            return new PortForwarderWebsocket(this.client).forward(this.getResourceUrl(), port, localPort);
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ContainerResource<String, LogWatch, InputStream, PipedOutputStream, OutputStream, PipedInputStream, String, ExecWatch> inContainer(String containerId) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.execListener, this.limitBytes);
    }

    public ExecWatch exec(String ... command) {
        StringBuilder sb = new StringBuilder();
        String[] actualCommands = command.length >= 1 ? command : EMPTY_COMMAND;
        sb.append("exec?command=");
        boolean first = true;
        for (String cmd : actualCommands) {
            if (first) {
                first = false;
            } else {
                sb.append("&command=");
            }
            sb.append(cmd);
        }
        if (this.containerId != null && !this.containerId.isEmpty()) {
            sb.append("&container=").append(this.containerId);
        }
        if (this.withTTY) {
            sb.append("&tty=true");
        }
        if (this.in != null || this.inPipe != null) {
            sb.append("&stdin=true");
        }
        if (this.out != null || this.outPipe != null) {
            sb.append("&stdout=true");
        }
        if (this.err != null || this.errPipe != null) {
            sb.append("&stderr=true");
        }
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), sb.toString()));
            Request.Builder r = new Request.Builder().url(url).get();
            OkHttpClient clone = this.client.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            ExecWebSocketListener execWebSocketListener = new ExecWebSocketListener(this.in, this.out, this.err, this.inPipe, this.outPipe, this.errPipe, this.execListener);
            clone.newWebSocket(r.build(), (WebSocketListener)execWebSocketListener);
            execWebSocketListener.waitUntilReady();
            return execWebSocketListener;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("exec"), t);
        }
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> readingInput(InputStream in) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.execListener, this.limitBytes);
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> writingInput(PipedOutputStream inPipe) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.execListener, this.limitBytes);
    }

    @Override
    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, ExecWatch> redirectingInput() {
        return this.writingInput(new PipedOutputStream());
    }

    @Override
    public TtyExecErrorable<String, OutputStream, PipedInputStream, ExecWatch> writingOutput(OutputStream out) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, out, this.outPipe, this.err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.execListener, this.limitBytes);
    }

    @Override
    public TtyExecErrorable<String, OutputStream, PipedInputStream, ExecWatch> readingOutput(PipedInputStream outPipe) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, this.out, outPipe, this.err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.execListener, this.limitBytes);
    }

    @Override
    public TtyExecErrorable<String, OutputStream, PipedInputStream, ExecWatch> redirectingOutput() {
        return this.readingOutput(new PipedInputStream());
    }

    @Override
    public TtyExecable<String, ExecWatch> writingError(OutputStream err) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.execListener, this.limitBytes);
    }

    @Override
    public TtyExecable<String, ExecWatch> readingError(PipedInputStream errPipe) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.execListener, this.limitBytes);
    }

    @Override
    public TtyExecable<String, ExecWatch> redirectingError() {
        return this.readingError(new PipedInputStream());
    }

    @Override
    public ExecListenable<String, ExecWatch> withTTY() {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, true, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.execListener, this.limitBytes);
    }

    @Override
    public Loggable<String, LogWatch> withPrettyOutput() {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, true, this.execListener, this.limitBytes);
    }

    @Override
    public PrettyLoggable<String, LogWatch> tailingLines(int withTailingLines) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, withTailingLines, this.withPrettyOutput, this.execListener, this.limitBytes);
    }

    @Override
    public TailPrettyLoggable<String, LogWatch> sinceTime(String sinceTimestamp) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.execListener, this.limitBytes);
    }

    @Override
    public TailPrettyLoggable<String, LogWatch> sinceSeconds(int sinceSeconds) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.execListener, this.limitBytes);
    }

    @Override
    public TimeTailPrettyLoggable<String, LogWatch> terminated() {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY, true, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.execListener, this.limitBytes);
    }

    @Override
    public Execable<String, ExecWatch> usingListener(ExecListener execListener) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, execListener, this.limitBytes);
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable<String, LogWatch> limitBytes(int limitBytes) {
        return new PodOperationsImpl(this.client, this.getConfig(), this.apiVersion, this.namespace, this.name, this.isCascading(), (Pod)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.containerId, this.in, this.inPipe, this.out, this.outPipe, this.err, this.errPipe, this.withTTY, this.withTerminatedStatus, this.withTimestamps, this.sinceTimestamp, this.sinceSeconds, this.withTailingLines, this.withPrettyOutput, this.execListener, limitBytes);
    }

    @Override
    public Pod waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        Pod pod = (Pod)this.get();
        if (pod == null) {
            throw new IllegalArgumentException("Pod with name:[" + this.name + "] in namespace:[" + this.namespace + "] not found!");
        }
        if (Readiness.isReady(pod)) {
            return pod;
        }
        ReadinessWatcher<Pod> watcher = new ReadinessWatcher<Pod>(pod);
        try (Watch watch = this.watch(watcher);){
            Pod pod2 = watcher.await(amount, timeUnit);
            return pod2;
        }
    }
}

