/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v3_0.dsl.internal;

import io.fabric8.kubernetes.api.model.v3_0.DoneableJob;
import io.fabric8.kubernetes.api.model.v3_0.Job;
import io.fabric8.kubernetes.api.model.v3_0.JobFluent;
import io.fabric8.kubernetes.api.model.v3_0.JobList;
import io.fabric8.kubernetes.clnt.v3_0.Config;
import io.fabric8.kubernetes.clnt.v3_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v3_0.dsl.Reaper;
import io.fabric8.kubernetes.clnt.v3_0.dsl.ScalableResource;
import io.fabric8.kubernetes.clnt.v3_0.dsl.base.HasMetadataOperation;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobOperationsImpl
extends HasMetadataOperation<Job, JobList, DoneableJob, ScalableResource<Job, DoneableJob>>
implements ScalableResource<Job, DoneableJob> {
    static final transient Logger LOG = LoggerFactory.getLogger(JobOperationsImpl.class);

    public JobOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, "v1", namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public JobOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, Job item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, "batch", apiVersion, "jobs", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.reaper = new JobReaper(this);
    }

    @Override
    public ScalableResource<Job, DoneableJob> load(InputStream is) {
        try {
            Job item = JobOperationsImpl.unmarshal(is, Job.class);
            return new JobOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), item, this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields());
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    @Override
    public ScalableResource<Job, DoneableJob> fromServer() {
        return new JobOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (Job)this.getItem(), this.getResourceVersion(), true, this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields());
    }

    @Override
    public Job scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Job scale(int count, boolean wait) {
        Job res = ((DoneableJob)((JobFluent.SpecNested)((DoneableJob)this.cascading(false).edit()).editSpec().withParallelism(count)).endSpec()).done();
        if (wait) {
            this.waitUntilJobIsScaled();
            res = (Job)this.getMandatory();
        }
        return res;
    }

    private void waitUntilJobIsScaled() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference atomicJob = new AtomicReference();
        Runnable jobPoller = new Runnable(){

            @Override
            public void run() {
                try {
                    Job job = (Job)JobOperationsImpl.this.getMandatory();
                    atomicJob.set(job);
                    Integer activeJobs = job.getStatus().getActive();
                    if (activeJobs == null) {
                        activeJobs = 0;
                    }
                    if (Objects.equals(job.getSpec().getParallelism(), activeJobs)) {
                        countDownLatch.countDown();
                    } else {
                        LOG.debug("Only {}/{} pods scheduled for Job: {} in namespace: {} seconds so waiting...", new Object[]{job.getStatus().getActive(), job.getSpec().getParallelism(), job.getMetadata().getName(), JobOperationsImpl.this.namespace});
                    }
                }
                catch (Throwable t) {
                    LOG.error("Error while waiting for Job to be scaled.", t);
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(jobPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            countDownLatch.await(this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS);
            executor.shutdown();
        }
        catch (InterruptedException e) {
            poller.cancel(true);
            executor.shutdown();
            LOG.error("Only {}/{} pod(s) ready for Job: {} in namespace: {} - giving up", new Object[]{((Job)atomicJob.get()).getStatus().getActive(), ((Job)atomicJob.get()).getSpec().getParallelism(), ((Job)atomicJob.get()).getMetadata().getName(), this.namespace});
        }
    }

    private static class JobReaper
    implements Reaper {
        private JobOperationsImpl oper;

        public JobReaper(JobOperationsImpl oper) {
            this.oper = oper;
        }

        @Override
        public boolean reap() {
            this.oper.scale(0, true);
            return false;
        }
    }
}

