/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_0;

import io.fabric8.kubernetes.api.builder.v3_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_0.Nested;
import io.fabric8.kubernetes.api.builder.v3_0.Predicate;
import io.fabric8.kubernetes.api.model.v3_0.StatusCause;
import io.fabric8.kubernetes.api.model.v3_0.StatusCauseBuilder;
import io.fabric8.kubernetes.api.model.v3_0.StatusCauseFluentImpl;
import io.fabric8.kubernetes.api.model.v3_0.StatusDetails;
import io.fabric8.kubernetes.api.model.v3_0.StatusDetailsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StatusDetailsFluentImpl<A extends StatusDetailsFluent<A>>
extends BaseFluent<A>
implements StatusDetailsFluent<A> {
    private List<StatusCauseBuilder> causes = new ArrayList<StatusCauseBuilder>();
    private String group;
    private String kind;
    private String name;
    private Integer retryAfterSeconds;
    private String uid;

    public StatusDetailsFluentImpl() {
    }

    public StatusDetailsFluentImpl(StatusDetails instance) {
        this.withCauses(instance.getCauses());
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withRetryAfterSeconds(instance.getRetryAfterSeconds());
        this.withUid(instance.getUid());
    }

    @Override
    public A addToCauses(int index, StatusCause item) {
        StatusCauseBuilder builder = new StatusCauseBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.causes.add(index >= 0 ? index : this.causes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCauses(int index, StatusCause item) {
        StatusCauseBuilder builder = new StatusCauseBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.causes.size()) {
            this.causes.add(builder);
        } else {
            this.causes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCauses(StatusCause ... items) {
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.add(builder);
            this.causes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCauses(Collection<StatusCause> items) {
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.add(builder);
            this.causes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCauses(StatusCause ... items) {
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.remove(builder);
            this.causes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCauses(Collection<StatusCause> items) {
        for (StatusCause item : items) {
            StatusCauseBuilder builder = new StatusCauseBuilder(item);
            this._visitables.remove(builder);
            this.causes.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<StatusCause> getCauses() {
        return StatusDetailsFluentImpl.build(this.causes);
    }

    @Override
    public List<StatusCause> buildCauses() {
        return StatusDetailsFluentImpl.build(this.causes);
    }

    @Override
    public StatusCause buildCause(int index) {
        return this.causes.get(index).build();
    }

    @Override
    public StatusCause buildFirstCause() {
        return this.causes.get(0).build();
    }

    @Override
    public StatusCause buildLastCause() {
        return this.causes.get(this.causes.size() - 1).build();
    }

    @Override
    public StatusCause buildMatchingCause(Predicate<StatusCauseBuilder> predicate) {
        for (StatusCauseBuilder item : this.causes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withCauses(List<StatusCause> causes) {
        this._visitables.removeAll(this.causes);
        this.causes.clear();
        if (causes != null) {
            for (StatusCause item : causes) {
                this.addToCauses(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withCauses(StatusCause ... causes) {
        this.causes.clear();
        if (causes != null) {
            for (StatusCause item : causes) {
                this.addToCauses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCauses() {
        return this.causes != null && !this.causes.isEmpty();
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> addNewCause() {
        return new CausesNestedImpl();
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> addNewCauseLike(StatusCause item) {
        return new CausesNestedImpl(-1, item);
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> setNewCauseLike(int index, StatusCause item) {
        return new CausesNestedImpl(index, item);
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> editCause(int index) {
        if (this.causes.size() <= index) {
            throw new RuntimeException("Can't edit causes. Index exceeds size.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> editFirstCause() {
        if (this.causes.size() == 0) {
            throw new RuntimeException("Can't edit first causes. The list is empty.");
        }
        return this.setNewCauseLike(0, this.buildCause(0));
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> editLastCause() {
        int index = this.causes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last causes. The list is empty.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public StatusDetailsFluent.CausesNested<A> editMatchingCause(Predicate<StatusCauseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.causes.size(); ++i) {
            if (!predicate.apply(this.causes.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching causes. No match found.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public A addNewCause(String field, String message, String reason) {
        return this.addToCauses(new StatusCause(field, message, reason));
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public Integer getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    @Override
    public A withRetryAfterSeconds(Integer retryAfterSeconds) {
        this.retryAfterSeconds = retryAfterSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasRetryAfterSeconds() {
        return this.retryAfterSeconds != null;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusDetailsFluentImpl that = (StatusDetailsFluentImpl)o;
        if (this.causes != null ? !this.causes.equals(that.causes) : that.causes != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.retryAfterSeconds != null ? !this.retryAfterSeconds.equals(that.retryAfterSeconds) : that.retryAfterSeconds != null) {
            return false;
        }
        return !(this.uid != null ? !this.uid.equals(that.uid) : that.uid != null);
    }

    public class CausesNestedImpl<N>
    extends StatusCauseFluentImpl<StatusDetailsFluent.CausesNested<N>>
    implements StatusDetailsFluent.CausesNested<N>,
    Nested<N> {
        private final StatusCauseBuilder builder;
        private final int index;

        CausesNestedImpl(int index, StatusCause item) {
            this.index = index;
            this.builder = new StatusCauseBuilder(this, item);
        }

        CausesNestedImpl() {
            this.index = -1;
            this.builder = new StatusCauseBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatusDetailsFluentImpl.this.setToCauses(this.index, this.builder.build());
        }

        @Override
        public N endCause() {
            return this.and();
        }
    }
}

