/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_0;

import io.fabric8.kubernetes.api.builder.v3_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_0.Nested;
import io.fabric8.kubernetes.api.builder.v3_0.Predicate;
import io.fabric8.kubernetes.api.model.v3_0.NodeSpec;
import io.fabric8.kubernetes.api.model.v3_0.NodeSpecFluent;
import io.fabric8.kubernetes.api.model.v3_0.Taint;
import io.fabric8.kubernetes.api.model.v3_0.TaintBuilder;
import io.fabric8.kubernetes.api.model.v3_0.TaintFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodeSpecFluentImpl<A extends NodeSpecFluent<A>>
extends BaseFluent<A>
implements NodeSpecFluent<A> {
    private String externalID;
    private String podCIDR;
    private String providerID;
    private List<TaintBuilder> taints = new ArrayList<TaintBuilder>();
    private Boolean unschedulable;

    public NodeSpecFluentImpl() {
    }

    public NodeSpecFluentImpl(NodeSpec instance) {
        this.withExternalID(instance.getExternalID());
        this.withPodCIDR(instance.getPodCIDR());
        this.withProviderID(instance.getProviderID());
        this.withTaints(instance.getTaints());
        this.withUnschedulable(instance.getUnschedulable());
    }

    @Override
    public String getExternalID() {
        return this.externalID;
    }

    @Override
    public A withExternalID(String externalID) {
        this.externalID = externalID;
        return (A)this;
    }

    @Override
    public Boolean hasExternalID() {
        return this.externalID != null;
    }

    @Override
    public String getPodCIDR() {
        return this.podCIDR;
    }

    @Override
    public A withPodCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
        return (A)this;
    }

    @Override
    public Boolean hasPodCIDR() {
        return this.podCIDR != null;
    }

    @Override
    public String getProviderID() {
        return this.providerID;
    }

    @Override
    public A withProviderID(String providerID) {
        this.providerID = providerID;
        return (A)this;
    }

    @Override
    public Boolean hasProviderID() {
        return this.providerID != null;
    }

    @Override
    public A addToTaints(int index, Taint item) {
        TaintBuilder builder = new TaintBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.taints.add(index >= 0 ? index : this.taints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTaints(int index, Taint item) {
        TaintBuilder builder = new TaintBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.taints.size()) {
            this.taints.add(builder);
        } else {
            this.taints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTaints(Taint ... items) {
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTaints(Collection<Taint> items) {
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTaints(Taint ... items) {
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.remove(builder);
            this.taints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTaints(Collection<Taint> items) {
        for (Taint item : items) {
            TaintBuilder builder = new TaintBuilder(item);
            this._visitables.remove(builder);
            this.taints.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Taint> getTaints() {
        return NodeSpecFluentImpl.build(this.taints);
    }

    @Override
    public List<Taint> buildTaints() {
        return NodeSpecFluentImpl.build(this.taints);
    }

    @Override
    public Taint buildTaint(int index) {
        return this.taints.get(index).build();
    }

    @Override
    public Taint buildFirstTaint() {
        return this.taints.get(0).build();
    }

    @Override
    public Taint buildLastTaint() {
        return this.taints.get(this.taints.size() - 1).build();
    }

    @Override
    public Taint buildMatchingTaint(Predicate<TaintBuilder> predicate) {
        for (TaintBuilder item : this.taints) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withTaints(List<Taint> taints) {
        this._visitables.removeAll(this.taints);
        this.taints.clear();
        if (taints != null) {
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTaints(Taint ... taints) {
        this.taints.clear();
        if (taints != null) {
            for (Taint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> addNewTaint() {
        return new TaintsNestedImpl();
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> addNewTaintLike(Taint item) {
        return new TaintsNestedImpl(-1, item);
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> setNewTaintLike(int index, Taint item) {
        return new TaintsNestedImpl(index, item);
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> editTaint(int index) {
        if (this.taints.size() <= index) {
            throw new RuntimeException("Can't edit taints. Index exceeds size.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> editFirstTaint() {
        if (this.taints.size() == 0) {
            throw new RuntimeException("Can't edit first taints. The list is empty.");
        }
        return this.setNewTaintLike(0, this.buildTaint(0));
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> editLastTaint() {
        int index = this.taints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last taints. The list is empty.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public NodeSpecFluent.TaintsNested<A> editMatchingTaint(Predicate<TaintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.taints.size(); ++i) {
            if (!predicate.apply(this.taints.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching taints. No match found.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public A addNewTaint(String effect, String key, String timeAdded, String value) {
        return this.addToTaints(new Taint(effect, key, timeAdded, value));
    }

    @Override
    public Boolean isUnschedulable() {
        return this.unschedulable;
    }

    @Override
    public A withUnschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
        return (A)this;
    }

    @Override
    public Boolean hasUnschedulable() {
        return this.unschedulable != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSpecFluentImpl that = (NodeSpecFluentImpl)o;
        if (this.externalID != null ? !this.externalID.equals(that.externalID) : that.externalID != null) {
            return false;
        }
        if (this.podCIDR != null ? !this.podCIDR.equals(that.podCIDR) : that.podCIDR != null) {
            return false;
        }
        if (this.providerID != null ? !this.providerID.equals(that.providerID) : that.providerID != null) {
            return false;
        }
        if (this.taints != null ? !this.taints.equals(that.taints) : that.taints != null) {
            return false;
        }
        return !(this.unschedulable != null ? !this.unschedulable.equals(that.unschedulable) : that.unschedulable != null);
    }

    public class TaintsNestedImpl<N>
    extends TaintFluentImpl<NodeSpecFluent.TaintsNested<N>>
    implements NodeSpecFluent.TaintsNested<N>,
    Nested<N> {
        private final TaintBuilder builder;
        private final int index;

        TaintsNestedImpl(int index, Taint item) {
            this.index = index;
            this.builder = new TaintBuilder(this, item);
        }

        TaintsNestedImpl() {
            this.index = -1;
            this.builder = new TaintBuilder(this);
        }

        @Override
        public N and() {
            return (N)NodeSpecFluentImpl.this.setToTaints(this.index, this.builder.build());
        }

        @Override
        public N endTaint() {
            return this.and();
        }
    }
}

