/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_0;

import io.fabric8.kubernetes.api.builder.v3_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_0.Nested;
import io.fabric8.kubernetes.api.builder.v3_0.Predicate;
import io.fabric8.kubernetes.api.model.v3_0.JobCondition;
import io.fabric8.kubernetes.api.model.v3_0.JobConditionBuilder;
import io.fabric8.kubernetes.api.model.v3_0.JobConditionFluentImpl;
import io.fabric8.kubernetes.api.model.v3_0.JobStatus;
import io.fabric8.kubernetes.api.model.v3_0.JobStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JobStatusFluentImpl<A extends JobStatusFluent<A>>
extends BaseFluent<A>
implements JobStatusFluent<A> {
    private Integer active;
    private String completionTime;
    private List<JobConditionBuilder> conditions = new ArrayList<JobConditionBuilder>();
    private Integer failed;
    private String startTime;
    private Integer succeeded;

    public JobStatusFluentImpl() {
    }

    public JobStatusFluentImpl(JobStatus instance) {
        this.withActive(instance.getActive());
        this.withCompletionTime(instance.getCompletionTime());
        this.withConditions(instance.getConditions());
        this.withFailed(instance.getFailed());
        this.withStartTime(instance.getStartTime());
        this.withSucceeded(instance.getSucceeded());
    }

    @Override
    public Integer getActive() {
        return this.active;
    }

    @Override
    public A withActive(Integer active) {
        this.active = active;
        return (A)this;
    }

    @Override
    public Boolean hasActive() {
        return this.active != null;
    }

    @Override
    public String getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public A withCompletionTime(String completionTime) {
        this.completionTime = completionTime;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    @Override
    public A addToConditions(int index, JobCondition item) {
        JobConditionBuilder builder = new JobConditionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, JobCondition item) {
        JobConditionBuilder builder = new JobConditionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(JobCondition ... items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<JobCondition> items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(JobCondition ... items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<JobCondition> items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<JobCondition> getConditions() {
        return JobStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<JobCondition> buildConditions() {
        return JobStatusFluentImpl.build(this.conditions);
    }

    @Override
    public JobCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public JobCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public JobCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public JobCondition buildMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        for (JobConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withConditions(List<JobCondition> conditions) {
        this._visitables.removeAll(this.conditions);
        this.conditions.clear();
        if (conditions != null) {
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(JobCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> addNewConditionLike(JobCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> setNewConditionLike(int index, JobCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getFailed() {
        return this.failed;
    }

    @Override
    public A withFailed(Integer failed) {
        this.failed = failed;
        return (A)this;
    }

    @Override
    public Boolean hasFailed() {
        return this.failed != null;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public Integer getSucceeded() {
        return this.succeeded;
    }

    @Override
    public A withSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
        return (A)this;
    }

    @Override
    public Boolean hasSucceeded() {
        return this.succeeded != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobStatusFluentImpl that = (JobStatusFluentImpl)o;
        if (this.active != null ? !this.active.equals(that.active) : that.active != null) {
            return false;
        }
        if (this.completionTime != null ? !this.completionTime.equals(that.completionTime) : that.completionTime != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.failed != null ? !this.failed.equals(that.failed) : that.failed != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        return !(this.succeeded != null ? !this.succeeded.equals(that.succeeded) : that.succeeded != null);
    }

    public class ConditionsNestedImpl<N>
    extends JobConditionFluentImpl<JobStatusFluent.ConditionsNested<N>>
    implements JobStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final JobConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, JobCondition item) {
            this.index = index;
            this.builder = new JobConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new JobConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

