/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder.v3_0;

import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public final class ValidationUtils {
    public static <T> void validate(T item) {
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder("Constraint Validations: ");
            boolean first = true;
            for (ConstraintViolation violation : violations) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                Object leafBean = violation.getLeafBean();
                sb.append(violation.getPropertyPath() + " " + violation.getMessage() + " on bean: " + leafBean);
            }
            throw new ConstraintViolationException(sb.toString(), violations);
        }
    }
}

