/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_0;

import io.fabric8.kubernetes.api.builder.v3_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_0.Nested;
import io.fabric8.kubernetes.api.model.v3_0.Taint;
import io.fabric8.kubernetes.api.model.v3_0.TaintFluent;
import io.fabric8.kubernetes.api.model.v3_0.Time;
import io.fabric8.kubernetes.api.model.v3_0.TimeBuilder;
import io.fabric8.kubernetes.api.model.v3_0.TimeFluentImpl;

public class TaintFluentImpl<A extends TaintFluent<A>>
extends BaseFluent<A>
implements TaintFluent<A> {
    private String effect;
    private String key;
    private TimeBuilder timeAdded;
    private String value;

    public TaintFluentImpl() {
    }

    public TaintFluentImpl(Taint instance) {
        this.withEffect(instance.getEffect());
        this.withKey(instance.getKey());
        this.withTimeAdded(instance.getTimeAdded());
        this.withValue(instance.getValue());
    }

    @Override
    public String getEffect() {
        return this.effect;
    }

    @Override
    public A withEffect(String effect) {
        this.effect = effect;
        return (A)this;
    }

    @Override
    public Boolean hasEffect() {
        return this.effect != null;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public A withKey(String key) {
        this.key = key;
        return (A)this;
    }

    @Override
    public Boolean hasKey() {
        return this.key != null;
    }

    @Override
    @Deprecated
    public Time getTimeAdded() {
        return this.timeAdded != null ? this.timeAdded.build() : null;
    }

    @Override
    public Time buildTimeAdded() {
        return this.timeAdded != null ? this.timeAdded.build() : null;
    }

    @Override
    public A withTimeAdded(Time timeAdded) {
        this._visitables.remove(this.timeAdded);
        if (timeAdded != null) {
            this.timeAdded = new TimeBuilder(timeAdded);
            this._visitables.add(this.timeAdded);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTimeAdded() {
        return this.timeAdded != null;
    }

    @Override
    public TaintFluent.TimeAddedNested<A> withNewTimeAdded() {
        return new TimeAddedNestedImpl();
    }

    @Override
    public TaintFluent.TimeAddedNested<A> withNewTimeAddedLike(Time item) {
        return new TimeAddedNestedImpl(item);
    }

    @Override
    public TaintFluent.TimeAddedNested<A> editTimeAdded() {
        return this.withNewTimeAddedLike(this.getTimeAdded());
    }

    @Override
    public TaintFluent.TimeAddedNested<A> editOrNewTimeAdded() {
        return this.withNewTimeAddedLike(this.getTimeAdded() != null ? this.getTimeAdded() : new TimeBuilder().build());
    }

    @Override
    public TaintFluent.TimeAddedNested<A> editOrNewTimeAddedLike(Time item) {
        return this.withNewTimeAddedLike(this.getTimeAdded() != null ? this.getTimeAdded() : item);
    }

    @Override
    public A withNewTimeAdded(String time) {
        return this.withTimeAdded(new Time(time));
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public A withValue(String value) {
        this.value = value;
        return (A)this;
    }

    @Override
    public Boolean hasValue() {
        return this.value != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaintFluentImpl that = (TaintFluentImpl)o;
        if (this.effect != null ? !this.effect.equals(that.effect) : that.effect != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.timeAdded != null ? !this.timeAdded.equals(that.timeAdded) : that.timeAdded != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public class TimeAddedNestedImpl<N>
    extends TimeFluentImpl<TaintFluent.TimeAddedNested<N>>
    implements TaintFluent.TimeAddedNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        TimeAddedNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        TimeAddedNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaintFluentImpl.this.withTimeAdded(this.builder.build());
        }

        @Override
        public N endTimeAdded() {
            return this.and();
        }
    }
}

