/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_0;

import io.fabric8.kubernetes.api.builder.v3_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_0.Nested;
import io.fabric8.kubernetes.api.builder.v3_0.Predicate;
import io.fabric8.kubernetes.api.model.v3_0.CronJobStatus;
import io.fabric8.kubernetes.api.model.v3_0.CronJobStatusFluent;
import io.fabric8.kubernetes.api.model.v3_0.ObjectReference;
import io.fabric8.kubernetes.api.model.v3_0.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v3_0.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v3_0.Time;
import io.fabric8.kubernetes.api.model.v3_0.TimeBuilder;
import io.fabric8.kubernetes.api.model.v3_0.TimeFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CronJobStatusFluentImpl<A extends CronJobStatusFluent<A>>
extends BaseFluent<A>
implements CronJobStatusFluent<A> {
    private List<ObjectReferenceBuilder> active = new ArrayList<ObjectReferenceBuilder>();
    private TimeBuilder lastScheduleTime;

    public CronJobStatusFluentImpl() {
    }

    public CronJobStatusFluentImpl(CronJobStatus instance) {
        this.withActive(instance.getActive());
        this.withLastScheduleTime(instance.getLastScheduleTime());
    }

    @Override
    public A addToActive(int index, ObjectReference item) {
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.active.add(index >= 0 ? index : this.active.size(), builder);
        return (A)this;
    }

    @Override
    public A setToActive(int index, ObjectReference item) {
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.active.size()) {
            this.active.add(builder);
        } else {
            this.active.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToActive(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.active.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToActive(Collection<ObjectReference> items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.active.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromActive(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.active.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromActive(Collection<ObjectReference> items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.active.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ObjectReference> getActive() {
        return CronJobStatusFluentImpl.build(this.active);
    }

    @Override
    public List<ObjectReference> buildActive() {
        return CronJobStatusFluentImpl.build(this.active);
    }

    @Override
    public ObjectReference buildActive(int index) {
        return this.active.get(index).build();
    }

    @Override
    public ObjectReference buildFirstActive() {
        return this.active.get(0).build();
    }

    @Override
    public ObjectReference buildLastActive() {
        return this.active.get(this.active.size() - 1).build();
    }

    @Override
    public ObjectReference buildMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.active) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withActive(List<ObjectReference> active) {
        this._visitables.removeAll(this.active);
        this.active.clear();
        if (active != null) {
            for (ObjectReference item : active) {
                this.addToActive(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withActive(ObjectReference ... active) {
        this.active.clear();
        if (active != null) {
            for (ObjectReference item : active) {
                this.addToActive(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> addNewActive() {
        return new ActiveNestedImpl();
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> addNewActiveLike(ObjectReference item) {
        return new ActiveNestedImpl(-1, item);
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> setNewActiveLike(int index, ObjectReference item) {
        return new ActiveNestedImpl(index, item);
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> editActive(int index) {
        if (this.active.size() <= index) {
            throw new RuntimeException("Can't edit active. Index exceeds size.");
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> editFirstActive() {
        if (this.active.size() == 0) {
            throw new RuntimeException("Can't edit first active. The list is empty.");
        }
        return this.setNewActiveLike(0, this.buildActive(0));
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> editLastActive() {
        int index = this.active.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last active. The list is empty.");
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    @Override
    public CronJobStatusFluent.ActiveNested<A> editMatchingActive(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.active.size(); ++i) {
            if (!predicate.apply(this.active.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching active. No match found.");
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    @Override
    @Deprecated
    public Time getLastScheduleTime() {
        return this.lastScheduleTime != null ? this.lastScheduleTime.build() : null;
    }

    @Override
    public Time buildLastScheduleTime() {
        return this.lastScheduleTime != null ? this.lastScheduleTime.build() : null;
    }

    @Override
    public A withLastScheduleTime(Time lastScheduleTime) {
        this._visitables.remove(this.lastScheduleTime);
        if (lastScheduleTime != null) {
            this.lastScheduleTime = new TimeBuilder(lastScheduleTime);
            this._visitables.add(this.lastScheduleTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastScheduleTime() {
        return this.lastScheduleTime != null;
    }

    @Override
    public CronJobStatusFluent.LastScheduleTimeNested<A> withNewLastScheduleTime() {
        return new LastScheduleTimeNestedImpl();
    }

    @Override
    public CronJobStatusFluent.LastScheduleTimeNested<A> withNewLastScheduleTimeLike(Time item) {
        return new LastScheduleTimeNestedImpl(item);
    }

    @Override
    public CronJobStatusFluent.LastScheduleTimeNested<A> editLastScheduleTime() {
        return this.withNewLastScheduleTimeLike(this.getLastScheduleTime());
    }

    @Override
    public CronJobStatusFluent.LastScheduleTimeNested<A> editOrNewLastScheduleTime() {
        return this.withNewLastScheduleTimeLike(this.getLastScheduleTime() != null ? this.getLastScheduleTime() : new TimeBuilder().build());
    }

    @Override
    public CronJobStatusFluent.LastScheduleTimeNested<A> editOrNewLastScheduleTimeLike(Time item) {
        return this.withNewLastScheduleTimeLike(this.getLastScheduleTime() != null ? this.getLastScheduleTime() : item);
    }

    @Override
    public A withNewLastScheduleTime(String time) {
        return this.withLastScheduleTime(new Time(time));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CronJobStatusFluentImpl that = (CronJobStatusFluentImpl)o;
        if (this.active != null ? !this.active.equals(that.active) : that.active != null) {
            return false;
        }
        return !(this.lastScheduleTime != null ? !this.lastScheduleTime.equals(that.lastScheduleTime) : that.lastScheduleTime != null);
    }

    public class LastScheduleTimeNestedImpl<N>
    extends TimeFluentImpl<CronJobStatusFluent.LastScheduleTimeNested<N>>
    implements CronJobStatusFluent.LastScheduleTimeNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        LastScheduleTimeNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        LastScheduleTimeNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobStatusFluentImpl.this.withLastScheduleTime(this.builder.build());
        }

        @Override
        public N endLastScheduleTime() {
            return this.and();
        }
    }

    public class ActiveNestedImpl<N>
    extends ObjectReferenceFluentImpl<CronJobStatusFluent.ActiveNested<N>>
    implements CronJobStatusFluent.ActiveNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;
        private final int index;

        ActiveNestedImpl(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ActiveNestedImpl() {
            this.index = -1;
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobStatusFluentImpl.this.setToActive(this.index, this.builder.build());
        }

        @Override
        public N endActive() {
            return this.and();
        }
    }
}

