/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_6;

import io.fabric8.kubernetes.api.builder.v2_6.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_6.VisitableBuilder;
import io.fabric8.openshift.api.model.v2_6.DockerBuildStrategy;
import io.fabric8.openshift.api.model.v2_6.DockerBuildStrategyFluent;
import io.fabric8.openshift.api.model.v2_6.DockerBuildStrategyFluentImpl;

public class DockerBuildStrategyBuilder
extends DockerBuildStrategyFluentImpl<DockerBuildStrategyBuilder>
implements VisitableBuilder<DockerBuildStrategy, DockerBuildStrategyBuilder> {
    DockerBuildStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public DockerBuildStrategyBuilder() {
        this(true);
    }

    public DockerBuildStrategyBuilder(Boolean validationEnabled) {
        this(new DockerBuildStrategy(), validationEnabled);
    }

    public DockerBuildStrategyBuilder(DockerBuildStrategyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DockerBuildStrategyBuilder(DockerBuildStrategyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DockerBuildStrategy(), validationEnabled);
    }

    public DockerBuildStrategyBuilder(DockerBuildStrategyFluent<?> fluent, DockerBuildStrategy instance) {
        this(fluent, instance, true);
    }

    public DockerBuildStrategyBuilder(DockerBuildStrategyFluent<?> fluent, DockerBuildStrategy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDockerfilePath(instance.getDockerfilePath());
        fluent.withEnv(instance.getEnv());
        fluent.withForcePull(instance.getForcePull());
        fluent.withFrom(instance.getFrom());
        fluent.withNoCache(instance.getNoCache());
        fluent.withPullSecret(instance.getPullSecret());
        this.validationEnabled = validationEnabled;
    }

    public DockerBuildStrategyBuilder(DockerBuildStrategy instance) {
        this(instance, (Boolean)true);
    }

    public DockerBuildStrategyBuilder(DockerBuildStrategy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDockerfilePath(instance.getDockerfilePath());
        this.withEnv(instance.getEnv());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withNoCache(instance.getNoCache());
        this.withPullSecret(instance.getPullSecret());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public DockerBuildStrategy build() {
        DockerBuildStrategy buildable = new DockerBuildStrategy(this.fluent.getDockerfilePath(), this.fluent.getEnv(), this.fluent.isForcePull(), this.fluent.getFrom(), this.fluent.isNoCache(), this.fluent.getPullSecret());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DockerBuildStrategyBuilder that = (DockerBuildStrategyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

