/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_6;

import io.fabric8.kubernetes.api.builder.v2_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_6.Nested;
import io.fabric8.kubernetes.api.builder.v2_6.Predicate;
import io.fabric8.kubernetes.api.model.v2_6.EnvVar;
import io.fabric8.kubernetes.api.model.v2_6.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.v2_6.EnvVarFluentImpl;
import io.fabric8.openshift.api.model.v2_6.CustomDeploymentStrategyParams;
import io.fabric8.openshift.api.model.v2_6.CustomDeploymentStrategyParamsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CustomDeploymentStrategyParamsFluentImpl<A extends CustomDeploymentStrategyParamsFluent<A>>
extends BaseFluent<A>
implements CustomDeploymentStrategyParamsFluent<A> {
    private List<String> command = new ArrayList<String>();
    private List<EnvVarBuilder> environment = new ArrayList<EnvVarBuilder>();
    private String image;

    public CustomDeploymentStrategyParamsFluentImpl() {
    }

    public CustomDeploymentStrategyParamsFluentImpl(CustomDeploymentStrategyParams instance) {
        this.withCommand(instance.getCommand());
        this.withEnvironment(instance.getEnvironment());
        this.withImage(instance.getImage());
    }

    @Override
    public A addToCommand(int index, String item) {
        this.command.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCommand(int index, String item) {
        this.command.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCommand(String ... items) {
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCommand(Collection<String> items) {
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCommand(String ... items) {
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public String getCommand(int index) {
        return this.command.get(index);
    }

    @Override
    public String getFirstCommand() {
        return this.command.get(0);
    }

    @Override
    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    @Override
    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withCommand(List<String> command) {
        this.command.clear();
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withCommand(String ... command) {
        this.command.clear();
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    @Override
    public A addToEnvironment(int index, EnvVar item) {
        EnvVarBuilder builder = new EnvVarBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.environment.add(index >= 0 ? index : this.environment.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvironment(int index, EnvVar item) {
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.environment.size()) {
            this.environment.add(builder);
        } else {
            this.environment.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvironment(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.environment.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnvironment(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.environment.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvironment(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.environment.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnvironment(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.environment.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvVar> getEnvironment() {
        return CustomDeploymentStrategyParamsFluentImpl.build(this.environment);
    }

    @Override
    public List<EnvVar> buildEnvironment() {
        return CustomDeploymentStrategyParamsFluentImpl.build(this.environment);
    }

    @Override
    public EnvVar buildEnvironment(int index) {
        return this.environment.get(index).build();
    }

    @Override
    public EnvVar buildFirstEnvironment() {
        return this.environment.get(0).build();
    }

    @Override
    public EnvVar buildLastEnvironment() {
        return this.environment.get(this.environment.size() - 1).build();
    }

    @Override
    public EnvVar buildMatchingEnvironment(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.environment) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withEnvironment(List<EnvVar> environment) {
        this._visitables.removeAll(this.environment);
        this.environment.clear();
        if (environment != null) {
            for (EnvVar item : environment) {
                this.addToEnvironment(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withEnvironment(EnvVar ... environment) {
        this.environment.clear();
        if (environment != null) {
            for (EnvVar item : environment) {
                this.addToEnvironment(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvironment() {
        return this.environment != null && !this.environment.isEmpty();
    }

    @Override
    public CustomDeploymentStrategyParamsFluent.EnvironmentNested<A> addNewEnvironment() {
        return new EnvironmentNestedImpl();
    }

    @Override
    public CustomDeploymentStrategyParamsFluent.EnvironmentNested<A> addNewEnvironmentLike(EnvVar item) {
        return new EnvironmentNestedImpl(-1, item);
    }

    @Override
    public CustomDeploymentStrategyParamsFluent.EnvironmentNested<A> setNewEnvironmentLike(int index, EnvVar item) {
        return new EnvironmentNestedImpl(index, item);
    }

    @Override
    public CustomDeploymentStrategyParamsFluent.EnvironmentNested<A> editEnvironment(int index) {
        if (this.environment.size() <= index) {
            throw new RuntimeException("Can't edit environment. Index exceeds size.");
        }
        return this.setNewEnvironmentLike(index, this.buildEnvironment(index));
    }

    @Override
    public CustomDeploymentStrategyParamsFluent.EnvironmentNested<A> editFirstEnvironment() {
        if (this.environment.size() == 0) {
            throw new RuntimeException("Can't edit first environment. The list is empty.");
        }
        return this.setNewEnvironmentLike(0, this.buildEnvironment(0));
    }

    @Override
    public CustomDeploymentStrategyParamsFluent.EnvironmentNested<A> editLastEnvironment() {
        int index = this.environment.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last environment. The list is empty.");
        }
        return this.setNewEnvironmentLike(index, this.buildEnvironment(index));
    }

    @Override
    public CustomDeploymentStrategyParamsFluent.EnvironmentNested<A> editMatchingEnvironment(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.environment.size(); ++i) {
            if (!predicate.apply(this.environment.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching environment. No match found.");
        }
        return this.setNewEnvironmentLike(index, this.buildEnvironment(index));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomDeploymentStrategyParamsFluentImpl that = (CustomDeploymentStrategyParamsFluentImpl)o;
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) {
            return false;
        }
        return !(this.image != null ? !this.image.equals(that.image) : that.image != null);
    }

    public class EnvironmentNestedImpl<N>
    extends EnvVarFluentImpl<CustomDeploymentStrategyParamsFluent.EnvironmentNested<N>>
    implements CustomDeploymentStrategyParamsFluent.EnvironmentNested<N>,
    Nested<N> {
        private final EnvVarBuilder builder;
        private final int index;

        EnvironmentNestedImpl(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        EnvironmentNestedImpl() {
            this.index = -1;
            this.builder = new EnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)CustomDeploymentStrategyParamsFluentImpl.this.setToEnvironment(this.index, this.builder.build());
        }

        @Override
        public N endEnvironment() {
            return this.and();
        }
    }
}

