/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v2_6.dsl.internal;

import io.fabric8.kubernetes.api.model.v2_6.LabelSelector;
import io.fabric8.kubernetes.api.model.v2_6.extensions.Deployment;
import io.fabric8.kubernetes.api.model.v2_6.extensions.DeploymentFluent;
import io.fabric8.kubernetes.api.model.v2_6.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.v2_6.extensions.DoneableDeployment;
import io.fabric8.kubernetes.clnt.v2_6.Config;
import io.fabric8.kubernetes.clnt.v2_6.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v2_6.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v2_6.dsl.Reaper;
import io.fabric8.kubernetes.clnt.v2_6.dsl.ScalableResource;
import io.fabric8.kubernetes.clnt.v2_6.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v2_6.dsl.internal.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v2_6.utils.Utils;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentOperationsImpl
extends HasMetadataOperation<Deployment, DeploymentList, DoneableDeployment, ScalableResource<Deployment, DoneableDeployment>>
implements ScalableResource<Deployment, DoneableDeployment> {
    static final transient Logger LOG = LoggerFactory.getLogger(DeploymentOperationsImpl.class);

    public DeploymentOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, "v1beta1", namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public DeploymentOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, Deployment item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, config, "extensions", apiVersion, "deployments", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.reaper = new DeploymentReaper(this);
    }

    @Override
    public Deployment scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Deployment scale(int count, boolean wait) {
        Deployment res = ((DoneableDeployment)((DeploymentFluent.SpecNested)((DoneableDeployment)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
        if (wait) {
            this.waitUntilDeploymentIsScaled(count);
            res = (Deployment)this.getMandatory();
        }
        return res;
    }

    @Override
    public DoneableDeployment edit() {
        if (this.isCascading().booleanValue()) {
            return (DoneableDeployment)this.cascading(false).edit();
        }
        return (DoneableDeployment)super.edit();
    }

    @Override
    public Deployment replace(Deployment item) {
        if (this.isCascading().booleanValue()) {
            return (Deployment)this.cascading(false).replace(item);
        }
        return super.replace(item);
    }

    @Override
    public Deployment patch(Deployment item) {
        if (this.isCascading().booleanValue()) {
            return (Deployment)this.cascading(false).patch(item);
        }
        return super.patch(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDeploymentIsScaled(final int count) {
        final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        final AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        final String namespace = this.checkNamespace(this.getItem());
        Runnable deploymentPoller = new Runnable(){

            @Override
            public void run() {
                try {
                    long observedGeneration;
                    Deployment deployment = (Deployment)DeploymentOperationsImpl.this.get();
                    if (deployment == null) {
                        if (count == 0) {
                            queue.put(true);
                            return;
                        }
                        queue.put(new IllegalStateException("Can't wait for Deployment: " + DeploymentOperationsImpl.this.checkName(DeploymentOperationsImpl.this.getItem()) + " in namespace: " + DeploymentOperationsImpl.this.checkName(DeploymentOperationsImpl.this.getItem()) + " to scale. Resource is no longer available."));
                        return;
                    }
                    replicasRef.set(deployment.getStatus().getReplicas());
                    int currentReplicas = deployment.getStatus().getReplicas() != null ? deployment.getStatus().getReplicas() : 0;
                    long generation = deployment.getMetadata().getGeneration() != null ? deployment.getMetadata().getGeneration() : 0L;
                    long l = observedGeneration = deployment.getStatus() != null && deployment.getStatus().getObservedGeneration() != null ? deployment.getStatus().getObservedGeneration() : -1L;
                    if (observedGeneration >= generation && Objects.equals(deployment.getSpec().getReplicas(), currentReplicas)) {
                        queue.put(true);
                    } else {
                        LOG.debug("Only {}/{} pods scheduled for Deployment: {} in namespace: {} seconds so waiting...", new Object[]{deployment.getStatus().getReplicas(), deployment.getSpec().getReplicas(), deployment.getMetadata().getName(), namespace});
                    }
                }
                catch (Throwable t) {
                    LOG.error("Error while waiting for Deployment to be scaled.", t);
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS)) {
                LOG.debug("{}/{} pod(s) ready for Deployment: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
            } else {
                LOG.error("{}/{} pod(s) ready for Deployment: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    @Override
    public Deployment waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        Deployment deployment = (Deployment)this.get();
        if (deployment == null) {
            throw new IllegalArgumentException("Deployment with name:[" + this.name + "] in namespace:[" + this.namespace + "] not found!");
        }
        return (Deployment)this.periodicWatchUntilReady(10, System.currentTimeMillis(), Math.max(timeUnit.toMillis(amount) / 10L, 1000L), amount);
    }

    private static class DeploymentReaper
    implements Reaper {
        private DeploymentOperationsImpl oper;

        public DeploymentReaper(DeploymentOperationsImpl oper) {
            this.oper = oper;
        }

        @Override
        public boolean reap() {
            Deployment deployment = ((DoneableDeployment)((DeploymentFluent.SpecNested)((DoneableDeployment)this.oper.cascading(false).edit()).editSpec().withReplicas(0)).endSpec()).done();
            this.waitForObservedGeneration(deployment.getStatus().getObservedGeneration());
            this.reapMatchingReplicaSets(deployment.getSpec().getSelector());
            return false;
        }

        private void waitForObservedGeneration(final long observedGeneration) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable deploymentPoller = new Runnable(){

                @Override
                public void run() {
                    Deployment deployment = (Deployment)DeploymentReaper.this.oper.getMandatory();
                    if (observedGeneration <= deployment.getStatus().getObservedGeneration()) {
                        countDownLatch.countDown();
                    }
                }
            };
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 10L, TimeUnit.MILLISECONDS);
            try {
                countDownLatch.await(1L, TimeUnit.MINUTES);
                executor.shutdown();
            }
            catch (InterruptedException e) {
                poller.cancel(true);
                executor.shutdown();
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        private void reapMatchingReplicaSets(LabelSelector selector) {
            if (selector == null || selector.getMatchLabels() == null && selector.getMatchExpressions() == null) {
                return;
            }
            ReplicaSetOperationsImpl rsOper = new ReplicaSetOperationsImpl(this.oper.client, this.oper.getConfig(), this.oper.getNamespace());
            ((FilterWatchListDeletable)rsOper.inNamespace(this.oper.getNamespace()).withLabelSelector(selector)).delete();
        }
    }
}

