/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v2_6;

import io.fabric8.kubernetes.api.builder.v2_6.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_6.HasMetadata;
import io.fabric8.kubernetes.clnt.v2_6.ResourceHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public final class Handlers {
    private static final Set<ClassLoader> CLASS_LOADERS = new HashSet<ClassLoader>();
    private static final Map<String, ResourceHandler> RESOURCE_HANDLER_MAP = new HashMap<String, ResourceHandler>();

    private Handlers() {
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> void register(ResourceHandler<T, V> handler) {
        RESOURCE_HANDLER_MAP.put(handler.getKind().toLowerCase(), handler);
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> void unregister(ResourceHandler<T, V> handler) {
        RESOURCE_HANDLER_MAP.remove(handler.getKind().toLowerCase());
    }

    public static <T extends HasMetadata, V extends VisitableBuilder<T, V>> ResourceHandler<T, V> get(String kind) {
        if (RESOURCE_HANDLER_MAP.containsKey(kind.toLowerCase())) {
            return RESOURCE_HANDLER_MAP.get(kind.toLowerCase());
        }
        for (ResourceHandler handler : ServiceLoader.load(ResourceHandler.class, Thread.currentThread().getContextClassLoader())) {
            if (!handler.getKind().equals(kind)) continue;
            return handler;
        }
        return null;
    }

    private static void discoverHandlers(ClassLoader classLoader) {
        if (classLoader != null && CLASS_LOADERS.add(classLoader)) {
            for (ResourceHandler handler : ServiceLoader.load(ResourceHandler.class, classLoader)) {
                Handlers.register(handler);
            }
        }
    }

    static {
        Handlers.discoverHandlers(ResourceHandler.class.getClassLoader());
    }
}

