/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_6.extensions;

import io.fabric8.kubernetes.api.builder.v2_6.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_6.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_6.extensions.ScaleStatus;
import io.fabric8.kubernetes.api.model.v2_6.extensions.ScaleStatusFluent;
import io.fabric8.kubernetes.api.model.v2_6.extensions.ScaleStatusFluentImpl;

public class ScaleStatusBuilder
extends ScaleStatusFluentImpl<ScaleStatusBuilder>
implements VisitableBuilder<ScaleStatus, ScaleStatusBuilder> {
    ScaleStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ScaleStatusBuilder() {
        this(true);
    }

    public ScaleStatusBuilder(Boolean validationEnabled) {
        this(new ScaleStatus(), validationEnabled);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ScaleStatus(), validationEnabled);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent, ScaleStatus instance) {
        this(fluent, instance, true);
    }

    public ScaleStatusBuilder(ScaleStatusFluent<?> fluent, ScaleStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withReplicas(instance.getReplicas());
        fluent.withSelector(instance.getSelector());
        fluent.withTargetSelector(instance.getTargetSelector());
        this.validationEnabled = validationEnabled;
    }

    public ScaleStatusBuilder(ScaleStatus instance) {
        this(instance, (Boolean)true);
    }

    public ScaleStatusBuilder(ScaleStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTargetSelector(instance.getTargetSelector());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ScaleStatus build() {
        ScaleStatus buildable = new ScaleStatus(this.fluent.getReplicas(), this.fluent.getSelector(), this.fluent.getTargetSelector());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleStatusBuilder that = (ScaleStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

