/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_6.extensions;

import io.fabric8.kubernetes.api.builder.v2_6.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_6.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_6.extensions.APIVersion;
import io.fabric8.kubernetes.api.model.v2_6.extensions.APIVersionFluent;
import io.fabric8.kubernetes.api.model.v2_6.extensions.APIVersionFluentImpl;

public class APIVersionBuilder
extends APIVersionFluentImpl<APIVersionBuilder>
implements VisitableBuilder<APIVersion, APIVersionBuilder> {
    APIVersionFluent<?> fluent;
    Boolean validationEnabled;

    public APIVersionBuilder() {
        this(true);
    }

    public APIVersionBuilder(Boolean validationEnabled) {
        this(new APIVersion(), validationEnabled);
    }

    public APIVersionBuilder(APIVersionFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public APIVersionBuilder(APIVersionFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIVersion(), validationEnabled);
    }

    public APIVersionBuilder(APIVersionFluent<?> fluent, APIVersion instance) {
        this(fluent, instance, true);
    }

    public APIVersionBuilder(APIVersionFluent<?> fluent, APIVersion instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public APIVersionBuilder(APIVersion instance) {
        this(instance, (Boolean)true);
    }

    public APIVersionBuilder(APIVersion instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public APIVersion build() {
        APIVersion buildable = new APIVersion(this.fluent.getName());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIVersionBuilder that = (APIVersionBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

