/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_6;

import io.fabric8.kubernetes.api.builder.v2_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_6.Nested;
import io.fabric8.kubernetes.api.builder.v2_6.Predicate;
import io.fabric8.kubernetes.api.model.v2_6.LabelSelector;
import io.fabric8.kubernetes.api.model.v2_6.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v2_6.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v2_6.PersistentVolumeClaimSpec;
import io.fabric8.kubernetes.api.model.v2_6.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.v2_6.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v2_6.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v2_6.ResourceRequirementsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PersistentVolumeClaimSpecFluentImpl<A extends PersistentVolumeClaimSpecFluent<A>>
extends BaseFluent<A>
implements PersistentVolumeClaimSpecFluent<A> {
    private List<String> accessModes = new ArrayList<String>();
    private ResourceRequirementsBuilder resources;
    private LabelSelectorBuilder selector;
    private String volumeName;

    public PersistentVolumeClaimSpecFluentImpl() {
    }

    public PersistentVolumeClaimSpecFluentImpl(PersistentVolumeClaimSpec instance) {
        this.withAccessModes(instance.getAccessModes());
        this.withResources(instance.getResources());
        this.withSelector(instance.getSelector());
        this.withVolumeName(instance.getVolumeName());
    }

    @Override
    public A addToAccessModes(int index, String item) {
        this.accessModes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAccessModes(int index, String item) {
        this.accessModes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAccessModes(Collection<String> items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAccessModes(Collection<String> items) {
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    @Override
    public String getAccessMode(int index) {
        return this.accessModes.get(index);
    }

    @Override
    public String getFirstAccessMode() {
        return this.accessModes.get(0);
    }

    @Override
    public String getLastAccessMode() {
        return this.accessModes.get(this.accessModes.size() - 1);
    }

    @Override
    public String getMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withAccessModes(List<String> accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAccessModes(String ... accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAccessModes() {
        return this.accessModes != null && !this.accessModes.isEmpty();
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeName() {
        return this.volumeName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentVolumeClaimSpecFluentImpl that = (PersistentVolumeClaimSpecFluentImpl)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null);
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<PersistentVolumeClaimSpecFluent.SelectorNested<N>>
    implements PersistentVolumeClaimSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<PersistentVolumeClaimSpecFluent.ResourcesNested<N>>
    implements PersistentVolumeClaimSpecFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }
}

