/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_6;

import io.fabric8.kubernetes.api.builder.v2_6.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_6.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_6.Job;
import io.fabric8.kubernetes.api.model.v2_6.JobFluent;
import io.fabric8.kubernetes.api.model.v2_6.JobFluentImpl;

public class JobBuilder
extends JobFluentImpl<JobBuilder>
implements VisitableBuilder<Job, JobBuilder> {
    JobFluent<?> fluent;
    Boolean validationEnabled;

    public JobBuilder() {
        this(true);
    }

    public JobBuilder(Boolean validationEnabled) {
        this(new Job(), validationEnabled);
    }

    public JobBuilder(JobFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public JobBuilder(JobFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Job(), validationEnabled);
    }

    public JobBuilder(JobFluent<?> fluent, Job instance) {
        this(fluent, instance, true);
    }

    public JobBuilder(JobFluent<?> fluent, Job instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public JobBuilder(Job instance) {
        this(instance, (Boolean)true);
    }

    public JobBuilder(Job instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Job build() {
        Job buildable = new Job(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobBuilder that = (JobBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

