/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_6;

import io.fabric8.kubernetes.api.builder.v2_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_6.Nested;
import io.fabric8.kubernetes.api.builder.v2_6.Predicate;
import io.fabric8.kubernetes.api.model.v2_6.ComponentCondition;
import io.fabric8.kubernetes.api.model.v2_6.ComponentConditionBuilder;
import io.fabric8.kubernetes.api.model.v2_6.ComponentConditionFluentImpl;
import io.fabric8.kubernetes.api.model.v2_6.ComponentStatus;
import io.fabric8.kubernetes.api.model.v2_6.ComponentStatusFluent;
import io.fabric8.kubernetes.api.model.v2_6.ObjectMeta;
import io.fabric8.kubernetes.api.model.v2_6.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v2_6.ObjectMetaFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComponentStatusFluentImpl<A extends ComponentStatusFluent<A>>
extends BaseFluent<A>
implements ComponentStatusFluent<A> {
    private String apiVersion;
    private List<ComponentConditionBuilder> conditions = new ArrayList<ComponentConditionBuilder>();
    private String kind;
    private ObjectMetaBuilder metadata;

    public ComponentStatusFluentImpl() {
    }

    public ComponentStatusFluentImpl(ComponentStatus instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withConditions(instance.getConditions());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToConditions(int index, ComponentCondition item) {
        ComponentConditionBuilder builder = new ComponentConditionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, ComponentCondition item) {
        ComponentConditionBuilder builder = new ComponentConditionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(ComponentCondition ... items) {
        for (ComponentCondition item : items) {
            ComponentConditionBuilder builder = new ComponentConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<ComponentCondition> items) {
        for (ComponentCondition item : items) {
            ComponentConditionBuilder builder = new ComponentConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(ComponentCondition ... items) {
        for (ComponentCondition item : items) {
            ComponentConditionBuilder builder = new ComponentConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<ComponentCondition> items) {
        for (ComponentCondition item : items) {
            ComponentConditionBuilder builder = new ComponentConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ComponentCondition> getConditions() {
        return ComponentStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<ComponentCondition> buildConditions() {
        return ComponentStatusFluentImpl.build(this.conditions);
    }

    @Override
    public ComponentCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public ComponentCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public ComponentCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public ComponentCondition buildMatchingCondition(Predicate<ComponentConditionBuilder> predicate) {
        for (ComponentConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withConditions(List<ComponentCondition> conditions) {
        this._visitables.removeAll(this.conditions);
        this.conditions.clear();
        if (conditions != null) {
            for (ComponentCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(ComponentCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (ComponentCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public ComponentStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ComponentStatusFluent.ConditionsNested<A> addNewConditionLike(ComponentCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public ComponentStatusFluent.ConditionsNested<A> setNewConditionLike(int index, ComponentCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public ComponentStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ComponentStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public ComponentStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public ComponentStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ComponentConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public A addNewCondition(String error, String message, String status, String type) {
        return this.addToConditions(new ComponentCondition(error, message, status, type));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ComponentStatusFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ComponentStatusFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ComponentStatusFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ComponentStatusFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ComponentStatusFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentStatusFluentImpl that = (ComponentStatusFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ComponentStatusFluent.MetadataNested<N>>
    implements ComponentStatusFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentStatusFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends ComponentConditionFluentImpl<ComponentStatusFluent.ConditionsNested<N>>
    implements ComponentStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final ComponentConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, ComponentCondition item) {
            this.index = index;
            this.builder = new ComponentConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ComponentConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

