/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder.v2_6;

import io.fabric8.kubernetes.api.builder.v2_6.Builder;
import io.fabric8.kubernetes.api.builder.v2_6.Fluent;
import io.fabric8.kubernetes.api.builder.v2_6.PathAwareTypedVisitor;
import io.fabric8.kubernetes.api.builder.v2_6.TypedVisitor;
import io.fabric8.kubernetes.api.builder.v2_6.Visitable;
import io.fabric8.kubernetes.api.builder.v2_6.Visitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class BaseFluent<F extends Fluent<F>>
implements Fluent<F>,
Visitable<F> {
    private static final String VISIT = "visit";
    public final List<Visitable> _visitables = new ArrayList<Visitable>();

    public static <T> ArrayList<T> build(List<? extends Builder<? extends T>> list) {
        ArrayList<T> result = new ArrayList<T>();
        for (Builder<T> builder : list) {
            result.add(builder.build());
        }
        return result;
    }

    public static <T> List<T> build(Set<? extends Builder<? extends T>> list) {
        ArrayList<T> result = new ArrayList<T>();
        for (Builder<T> builder : list) {
            result.add(builder.build());
        }
        return result;
    }

    public static <T> ArrayList<T> aggregate(List<? extends T> ... lists) {
        ArrayList<? extends T> result = new ArrayList<T>();
        for (List<? extends T> list : lists) {
            result.addAll(list);
        }
        return result;
    }

    public static <T> LinkedHashSet<T> aggregate(Set ... sets) {
        LinkedHashSet result = new LinkedHashSet();
        for (Set set : sets) {
            result.addAll(set);
        }
        return result;
    }

    private static <V, F> Boolean canVisit(V visitor, F fluent) {
        Class actaulParentType;
        PathAwareTypedVisitor pathAwareTypedVisitor;
        Class parentType;
        if (visitor instanceof TypedVisitor && !((TypedVisitor)visitor).getType().isAssignableFrom(fluent.getClass())) {
            return false;
        }
        if (visitor instanceof PathAwareTypedVisitor && !(parentType = (pathAwareTypedVisitor = (PathAwareTypedVisitor)visitor).getParentType()).isAssignableFrom(actaulParentType = pathAwareTypedVisitor.getActualParentType())) {
            return false;
        }
        return BaseFluent.hasCompatibleVisitMethod(visitor, fluent);
    }

    private static <V, F> Boolean hasCompatibleVisitMethod(V visitor, F fluent) {
        for (Method method : visitor.getClass().getMethods()) {
            if (!method.getName().equals(VISIT) || method.getParameterTypes().length != 1) continue;
            Class<?> visitorType = method.getParameterTypes()[0];
            if (visitorType.isAssignableFrom(fluent.getClass())) {
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public F accept(Visitor visitor) {
        if (visitor instanceof PathAwareTypedVisitor) {
            return this.acceptPathAware((PathAwareTypedVisitor)visitor);
        }
        return this.acceptInternal(visitor);
    }

    private F acceptInternal(Visitor visitor) {
        for (Visitable visitable : this._visitables) {
            visitable.accept(visitor);
        }
        if (BaseFluent.canVisit(visitor, this).booleanValue()) {
            visitor.visit(this);
        }
        return (F)this;
    }

    private F acceptPathAware(PathAwareTypedVisitor pathAwareTypedVisitor) {
        return this.acceptInternal(pathAwareTypedVisitor.next(this));
    }
}

