/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v2_6.utils;

import io.fabric8.kubernetes.clnt.v2_6.Callback;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamPumper
implements Runnable,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStreamReader.class);
    private final InputStream in;
    private final Callback<byte[]> callback;
    private final Runnable onClose;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean keepReading = true;
    private Thread thread;

    public InputStreamPumper(InputStream in, Callback<byte[]> callback) {
        this(in, callback, null);
    }

    public InputStreamPumper(InputStream in, Callback<byte[]> callback, Runnable onClose) {
        this.in = in;
        this.callback = callback;
        this.onClose = onClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamPumper inputStreamPumper = this;
        synchronized (inputStreamPumper) {
            this.thread = Thread.currentThread();
        }
        byte[] buffer = new byte[1024];
        try {
            while (this.keepReading && !Thread.currentThread().isInterrupted()) {
                while (this.in.available() > 0 && this.keepReading && !Thread.currentThread().isInterrupted()) {
                    int length = this.in.read(buffer);
                    if (length < 0) {
                        throw new IOException("EOF has been reached!");
                    }
                    byte[] actual = new byte[length];
                    System.arraycopy(buffer, 0, actual, 0, length);
                    this.callback.call(actual);
                }
                Thread.sleep(50L);
            }
        }
        catch (IOException e) {
            if (!this.keepReading) {
                return;
            }
            if (!this.thread.isInterrupted()) {
                LOGGER.error("Error while pumping stream.", (Throwable)e);
            } else {
                LOGGER.debug("Interrupted while pumping stream.");
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    @Override
    public synchronized void close() {
        this.keepReading = false;
        if (this.thread != null && !this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
        if (this.closed.compareAndSet(false, true) && this.onClose != null) {
            this.onClose.run();
        }
    }
}

