/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v2_6;

import io.fabric8.kubernetes.api.model.v2_6.ComponentStatus;
import io.fabric8.kubernetes.api.model.v2_6.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v2_6.ConfigMap;
import io.fabric8.kubernetes.api.model.v2_6.ConfigMapList;
import io.fabric8.kubernetes.api.model.v2_6.DoneableComponentStatus;
import io.fabric8.kubernetes.api.model.v2_6.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.v2_6.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.v2_6.DoneableEvent;
import io.fabric8.kubernetes.api.model.v2_6.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.v2_6.DoneableNamespace;
import io.fabric8.kubernetes.api.model.v2_6.DoneableNode;
import io.fabric8.kubernetes.api.model.v2_6.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.v2_6.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v2_6.DoneablePod;
import io.fabric8.kubernetes.api.model.v2_6.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.v2_6.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.v2_6.DoneableSecret;
import io.fabric8.kubernetes.api.model.v2_6.DoneableSecurityContextConstraints;
import io.fabric8.kubernetes.api.model.v2_6.DoneableService;
import io.fabric8.kubernetes.api.model.v2_6.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.v2_6.Endpoints;
import io.fabric8.kubernetes.api.model.v2_6.EndpointsList;
import io.fabric8.kubernetes.api.model.v2_6.Event;
import io.fabric8.kubernetes.api.model.v2_6.EventList;
import io.fabric8.kubernetes.api.model.v2_6.HasMetadata;
import io.fabric8.kubernetes.api.model.v2_6.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v2_6.LimitRange;
import io.fabric8.kubernetes.api.model.v2_6.LimitRangeList;
import io.fabric8.kubernetes.api.model.v2_6.Namespace;
import io.fabric8.kubernetes.api.model.v2_6.NamespaceList;
import io.fabric8.kubernetes.api.model.v2_6.Node;
import io.fabric8.kubernetes.api.model.v2_6.NodeList;
import io.fabric8.kubernetes.api.model.v2_6.PersistentVolume;
import io.fabric8.kubernetes.api.model.v2_6.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v2_6.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v2_6.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v2_6.Pod;
import io.fabric8.kubernetes.api.model.v2_6.PodList;
import io.fabric8.kubernetes.api.model.v2_6.ReplicationController;
import io.fabric8.kubernetes.api.model.v2_6.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v2_6.ResourceQuota;
import io.fabric8.kubernetes.api.model.v2_6.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v2_6.RootPaths;
import io.fabric8.kubernetes.api.model.v2_6.Secret;
import io.fabric8.kubernetes.api.model.v2_6.SecretList;
import io.fabric8.kubernetes.api.model.v2_6.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.v2_6.SecurityContextConstraintsList;
import io.fabric8.kubernetes.api.model.v2_6.Service;
import io.fabric8.kubernetes.api.model.v2_6.ServiceAccount;
import io.fabric8.kubernetes.api.model.v2_6.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v2_6.ServiceList;
import io.fabric8.kubernetes.clnt.v2_6.Adapters;
import io.fabric8.kubernetes.clnt.v2_6.Config;
import io.fabric8.kubernetes.clnt.v2_6.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v2_6.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v2_6.ExtensionAdapter;
import io.fabric8.kubernetes.clnt.v2_6.KubernetesClient;
import io.fabric8.kubernetes.clnt.v2_6.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v2_6.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v2_6.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v2_6.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v2_6.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v2_6.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v2_6.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v2_6.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v2_6.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v2_6.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v2_6.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v2_6.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v2_6.dsl.Resource;
import io.fabric8.kubernetes.clnt.v2_6.dsl.RollableScalableResource;
import java.io.InputStream;
import java.net.URL;
import okhttp3.OkHttpClient;

public class AutoAdaptableKubernetesClient
extends DefaultKubernetesClient {
    private KubernetesClient delegate;

    public AutoAdaptableKubernetesClient() throws KubernetesClientException {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient());
    }

    public AutoAdaptableKubernetesClient(OkHttpClient httpClient, Config config) throws KubernetesClientException {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(httpClient, config));
    }

    public AutoAdaptableKubernetesClient(Config config) throws KubernetesClientException {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(config));
    }

    public AutoAdaptableKubernetesClient(String masterUrl) throws KubernetesClientException {
        this.delegate = AutoAdaptableKubernetesClient.adapt(new DefaultKubernetesClient(masterUrl));
    }

    public static KubernetesClient adapt(KubernetesClient initial) {
        KubernetesClient result = initial;
        for (ExtensionAdapter<KubernetesClient> adapter : Adapters.list(KubernetesClient.class)) {
            if (!adapter.isAdaptable(result).booleanValue()) continue;
            result = adapter.adapt(result);
        }
        return result;
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String namespace) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new AutoAdaptableKubernetesClient(this.httpClient, updated);
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.delegate.apps();
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.delegate.autoscaling();
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata is) {
        return this.delegate.resource(is);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<Service, ServiceList, DoneableService, Resource<Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, Resource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return this.delegate.securityContextConstraints();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public <C> Boolean isAdaptable(Class<C> type) {
        return this.delegate.isAdaptable(type);
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }
}

