/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_6;

import io.fabric8.kubernetes.api.builder.v2_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_6.Nested;
import io.fabric8.kubernetes.api.model.v2_6.Namespace;
import io.fabric8.kubernetes.api.model.v2_6.NamespaceFluent;
import io.fabric8.kubernetes.api.model.v2_6.NamespaceSpec;
import io.fabric8.kubernetes.api.model.v2_6.NamespaceSpecBuilder;
import io.fabric8.kubernetes.api.model.v2_6.NamespaceSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v2_6.NamespaceStatus;
import io.fabric8.kubernetes.api.model.v2_6.NamespaceStatusBuilder;
import io.fabric8.kubernetes.api.model.v2_6.NamespaceStatusFluentImpl;
import io.fabric8.kubernetes.api.model.v2_6.ObjectMeta;
import io.fabric8.kubernetes.api.model.v2_6.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v2_6.ObjectMetaFluentImpl;

public class NamespaceFluentImpl<A extends NamespaceFluent<A>>
extends BaseFluent<A>
implements NamespaceFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private NamespaceSpecBuilder spec;
    private NamespaceStatusBuilder status;

    public NamespaceFluentImpl() {
    }

    public NamespaceFluentImpl(Namespace instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public NamespaceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public NamespaceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public NamespaceFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public NamespaceFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public NamespaceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public NamespaceSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public NamespaceSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(NamespaceSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new NamespaceSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public NamespaceFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public NamespaceFluent.SpecNested<A> withNewSpecLike(NamespaceSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public NamespaceFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public NamespaceFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new NamespaceSpecBuilder().build());
    }

    @Override
    public NamespaceFluent.SpecNested<A> editOrNewSpecLike(NamespaceSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public NamespaceStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public NamespaceStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(NamespaceStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new NamespaceStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public NamespaceFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public NamespaceFluent.StatusNested<A> withNewStatusLike(NamespaceStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public NamespaceFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public NamespaceFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new NamespaceStatusBuilder().build());
    }

    @Override
    public NamespaceFluent.StatusNested<A> editOrNewStatusLike(NamespaceStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public A withNewStatus(String phase) {
        return this.withStatus(new NamespaceStatus(phase));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespaceFluentImpl that = (NamespaceFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends NamespaceStatusFluentImpl<NamespaceFluent.StatusNested<N>>
    implements NamespaceFluent.StatusNested<N>,
    Nested<N> {
        private final NamespaceStatusBuilder builder;

        StatusNestedImpl(NamespaceStatus item) {
            this.builder = new NamespaceStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new NamespaceStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamespaceFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends NamespaceSpecFluentImpl<NamespaceFluent.SpecNested<N>>
    implements NamespaceFluent.SpecNested<N>,
    Nested<N> {
        private final NamespaceSpecBuilder builder;

        SpecNestedImpl(NamespaceSpec item) {
            this.builder = new NamespaceSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new NamespaceSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamespaceFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<NamespaceFluent.MetadataNested<N>>
    implements NamespaceFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamespaceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

