/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_6;

import io.fabric8.kubernetes.api.builder.v2_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_6.Nested;
import io.fabric8.kubernetes.api.builder.v2_6.Predicate;
import io.fabric8.kubernetes.api.model.v2_6.Container;
import io.fabric8.kubernetes.api.model.v2_6.ContainerFluent;
import io.fabric8.kubernetes.api.model.v2_6.ContainerPort;
import io.fabric8.kubernetes.api.model.v2_6.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.v2_6.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.v2_6.EnvVar;
import io.fabric8.kubernetes.api.model.v2_6.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.v2_6.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.v2_6.Lifecycle;
import io.fabric8.kubernetes.api.model.v2_6.LifecycleBuilder;
import io.fabric8.kubernetes.api.model.v2_6.LifecycleFluentImpl;
import io.fabric8.kubernetes.api.model.v2_6.Probe;
import io.fabric8.kubernetes.api.model.v2_6.ProbeBuilder;
import io.fabric8.kubernetes.api.model.v2_6.ProbeFluentImpl;
import io.fabric8.kubernetes.api.model.v2_6.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v2_6.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v2_6.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.v2_6.SecurityContext;
import io.fabric8.kubernetes.api.model.v2_6.SecurityContextBuilder;
import io.fabric8.kubernetes.api.model.v2_6.SecurityContextFluentImpl;
import io.fabric8.kubernetes.api.model.v2_6.VolumeMount;
import io.fabric8.kubernetes.api.model.v2_6.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.v2_6.VolumeMountFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContainerFluentImpl<A extends ContainerFluent<A>>
extends BaseFluent<A>
implements ContainerFluent<A> {
    private List<String> args = new ArrayList<String>();
    private List<String> command = new ArrayList<String>();
    private List<EnvVarBuilder> env = new ArrayList<EnvVarBuilder>();
    private String image;
    private String imagePullPolicy;
    private LifecycleBuilder lifecycle;
    private ProbeBuilder livenessProbe;
    private String name;
    private List<ContainerPortBuilder> ports = new ArrayList<ContainerPortBuilder>();
    private ProbeBuilder readinessProbe;
    private ResourceRequirementsBuilder resources;
    private SecurityContextBuilder securityContext;
    private Boolean stdin;
    private Boolean stdinOnce;
    private String terminationMessagePath;
    private Boolean tty;
    private List<VolumeMountBuilder> volumeMounts = new ArrayList<VolumeMountBuilder>();
    private String workingDir;

    public ContainerFluentImpl() {
    }

    public ContainerFluentImpl(Container instance) {
        this.withArgs(instance.getArgs());
        this.withCommand(instance.getCommand());
        this.withEnv(instance.getEnv());
        this.withImage(instance.getImage());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withLifecycle(instance.getLifecycle());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withName(instance.getName());
        this.withPorts(instance.getPorts());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withResources(instance.getResources());
        this.withSecurityContext(instance.getSecurityContext());
        this.withStdin(instance.getStdin());
        this.withStdinOnce(instance.getStdinOnce());
        this.withTerminationMessagePath(instance.getTerminationMessagePath());
        this.withTty(instance.getTty());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withWorkingDir(instance.getWorkingDir());
    }

    @Override
    public A addToArgs(int index, String item) {
        this.args.add(index, item);
        return (A)this;
    }

    @Override
    public A setToArgs(int index, String item) {
        this.args.set(index, item);
        return (A)this;
    }

    @Override
    public A addToArgs(String ... items) {
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToArgs(Collection<String> items) {
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromArgs(String ... items) {
        for (String item : items) {
            this.args.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromArgs(Collection<String> items) {
        for (String item : items) {
            this.args.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getArgs() {
        return this.args;
    }

    @Override
    public String getArg(int index) {
        return this.args.get(index);
    }

    @Override
    public String getFirstArg() {
        return this.args.get(0);
    }

    @Override
    public String getLastArg() {
        return this.args.get(this.args.size() - 1);
    }

    @Override
    public String getMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withArgs(List<String> args) {
        this.args.clear();
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withArgs(String ... args) {
        this.args.clear();
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasArgs() {
        return this.args != null && !this.args.isEmpty();
    }

    @Override
    public A addToCommand(int index, String item) {
        this.command.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCommand(int index, String item) {
        this.command.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCommand(String ... items) {
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCommand(Collection<String> items) {
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCommand(String ... items) {
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public String getCommand(int index) {
        return this.command.get(index);
    }

    @Override
    public String getFirstCommand() {
        return this.command.get(0);
    }

    @Override
    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    @Override
    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withCommand(List<String> command) {
        this.command.clear();
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withCommand(String ... command) {
        this.command.clear();
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    @Override
    public A addToEnv(int index, EnvVar item) {
        EnvVarBuilder builder = new EnvVarBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.env.add(index >= 0 ? index : this.env.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnv(int index, EnvVar item) {
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.env.size()) {
            this.env.add(builder);
        } else {
            this.env.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EnvVar> getEnv() {
        return ContainerFluentImpl.build(this.env);
    }

    @Override
    public List<EnvVar> buildEnv() {
        return ContainerFluentImpl.build(this.env);
    }

    @Override
    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    @Override
    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    @Override
    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    @Override
    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        this._visitables.removeAll(this.env);
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public ContainerFluent.EnvNested<A> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public ContainerFluent.EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(-1, item);
    }

    @Override
    public ContainerFluent.EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNestedImpl(index, item);
    }

    @Override
    public ContainerFluent.EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ContainerFluent.EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    @Override
    public ContainerFluent.EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public ContainerFluent.EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.apply(this.env.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Override
    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    @Override
    @Deprecated
    public Lifecycle getLifecycle() {
        return this.lifecycle != null ? this.lifecycle.build() : null;
    }

    @Override
    public Lifecycle buildLifecycle() {
        return this.lifecycle != null ? this.lifecycle.build() : null;
    }

    @Override
    public A withLifecycle(Lifecycle lifecycle) {
        this._visitables.remove(this.lifecycle);
        if (lifecycle != null) {
            this.lifecycle = new LifecycleBuilder(lifecycle);
            this._visitables.add(this.lifecycle);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLifecycle() {
        return this.lifecycle != null;
    }

    @Override
    public ContainerFluent.LifecycleNested<A> withNewLifecycle() {
        return new LifecycleNestedImpl();
    }

    @Override
    public ContainerFluent.LifecycleNested<A> withNewLifecycleLike(Lifecycle item) {
        return new LifecycleNestedImpl(item);
    }

    @Override
    public ContainerFluent.LifecycleNested<A> editLifecycle() {
        return this.withNewLifecycleLike(this.getLifecycle());
    }

    @Override
    public ContainerFluent.LifecycleNested<A> editOrNewLifecycle() {
        return this.withNewLifecycleLike(this.getLifecycle() != null ? this.getLifecycle() : new LifecycleBuilder().build());
    }

    @Override
    public ContainerFluent.LifecycleNested<A> editOrNewLifecycleLike(Lifecycle item) {
        return this.withNewLifecycleLike(this.getLifecycle() != null ? this.getLifecycle() : item);
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A addToPorts(int index, ContainerPort item) {
        ContainerPortBuilder builder = new ContainerPortBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, ContainerPort item) {
        ContainerPortBuilder builder = new ContainerPortBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(ContainerPort ... items) {
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<ContainerPort> items) {
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(ContainerPort ... items) {
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<ContainerPort> items) {
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerPort> getPorts() {
        return ContainerFluentImpl.build(this.ports);
    }

    @Override
    public List<ContainerPort> buildPorts() {
        return ContainerFluentImpl.build(this.ports);
    }

    @Override
    public ContainerPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public ContainerPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public ContainerPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public ContainerPort buildMatchingPort(Predicate<ContainerPortBuilder> predicate) {
        for (ContainerPortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withPorts(List<ContainerPort> ports) {
        this._visitables.removeAll(this.ports);
        this.ports.clear();
        if (ports != null) {
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withPorts(ContainerPort ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public ContainerFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ContainerFluent.PortsNested<A> addNewPortLike(ContainerPort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public ContainerFluent.PortsNested<A> setNewPortLike(int index, ContainerPort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public ContainerFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ContainerFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public ContainerFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ContainerFluent.PortsNested<A> editMatchingPort(Predicate<ContainerPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply(this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public A addNewPort(Integer containerPort, String hostIP, Integer hostPort, String name, String protocol) {
        return this.addToPorts(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public ContainerFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public ContainerFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public ContainerFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public ContainerFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public ContainerFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public SecurityContext getSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    @Override
    public SecurityContext buildSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    @Override
    public A withSecurityContext(SecurityContext securityContext) {
        this._visitables.remove(this.securityContext);
        if (securityContext != null) {
            this.securityContext = new SecurityContextBuilder(securityContext);
            this._visitables.add(this.securityContext);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public ContainerFluent.SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNestedImpl();
    }

    @Override
    public ContainerFluent.SecurityContextNested<A> withNewSecurityContextLike(SecurityContext item) {
        return new SecurityContextNestedImpl(item);
    }

    @Override
    public ContainerFluent.SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext());
    }

    @Override
    public ContainerFluent.SecurityContextNested<A> editOrNewSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext() != null ? this.getSecurityContext() : new SecurityContextBuilder().build());
    }

    @Override
    public ContainerFluent.SecurityContextNested<A> editOrNewSecurityContextLike(SecurityContext item) {
        return this.withNewSecurityContextLike(this.getSecurityContext() != null ? this.getSecurityContext() : item);
    }

    @Override
    public Boolean isStdin() {
        return this.stdin;
    }

    @Override
    public A withStdin(Boolean stdin) {
        this.stdin = stdin;
        return (A)this;
    }

    @Override
    public Boolean hasStdin() {
        return this.stdin != null;
    }

    @Override
    public Boolean isStdinOnce() {
        return this.stdinOnce;
    }

    @Override
    public A withStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return (A)this;
    }

    @Override
    public Boolean hasStdinOnce() {
        return this.stdinOnce != null;
    }

    @Override
    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    @Override
    public A withTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return (A)this;
    }

    @Override
    public Boolean hasTerminationMessagePath() {
        return this.terminationMessagePath != null;
    }

    @Override
    public Boolean isTty() {
        return this.tty;
    }

    @Override
    public A withTty(Boolean tty) {
        this.tty = tty;
        return (A)this;
    }

    @Override
    public Boolean hasTty() {
        return this.tty != null;
    }

    @Override
    public A addToVolumeMounts(int index, VolumeMount item) {
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.volumeMounts.add(index >= 0 ? index : this.volumeMounts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumeMounts(int index, VolumeMount item) {
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.volumeMounts.size()) {
            this.volumeMounts.add(builder);
        } else {
            this.volumeMounts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.remove(builder);
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.remove(builder);
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<VolumeMount> getVolumeMounts() {
        return ContainerFluentImpl.build(this.volumeMounts);
    }

    @Override
    public List<VolumeMount> buildVolumeMounts() {
        return ContainerFluentImpl.build(this.volumeMounts);
    }

    @Override
    public VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    @Override
    public VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    @Override
    public VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    @Override
    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        this._visitables.removeAll(this.volumeMounts);
        this.volumeMounts.clear();
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        this.volumeMounts.clear();
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNestedImpl();
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNestedImpl(-1, item);
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index, VolumeMount item) {
        return new VolumeMountsNestedImpl(index, item);
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public ContainerFluent.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.apply(this.volumeMounts.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public A addNewVolumeMount(String mountPath, String name, Boolean readOnly, String subPath) {
        return this.addToVolumeMounts(new VolumeMount(mountPath, name, readOnly, subPath));
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public A withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (A)this;
    }

    @Override
    public Boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerFluentImpl that = (ContainerFluentImpl)o;
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals(that.imagePullPolicy) : that.imagePullPolicy != null) {
            return false;
        }
        if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.stdin != null ? !this.stdin.equals(that.stdin) : that.stdin != null) {
            return false;
        }
        if (this.stdinOnce != null ? !this.stdinOnce.equals(that.stdinOnce) : that.stdinOnce != null) {
            return false;
        }
        if (this.terminationMessagePath != null ? !this.terminationMessagePath.equals(that.terminationMessagePath) : that.terminationMessagePath != null) {
            return false;
        }
        if (this.tty != null ? !this.tty.equals(that.tty) : that.tty != null) {
            return false;
        }
        if (this.volumeMounts != null ? !this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts != null) {
            return false;
        }
        return !(this.workingDir != null ? !this.workingDir.equals(that.workingDir) : that.workingDir != null);
    }

    public class VolumeMountsNestedImpl<N>
    extends VolumeMountFluentImpl<ContainerFluent.VolumeMountsNested<N>>
    implements ContainerFluent.VolumeMountsNested<N>,
    Nested<N> {
        private final VolumeMountBuilder builder;
        private final int index;

        VolumeMountsNestedImpl(int index, VolumeMount item) {
            this.index = index;
            this.builder = new VolumeMountBuilder(this, item);
        }

        VolumeMountsNestedImpl() {
            this.index = -1;
            this.builder = new VolumeMountBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.setToVolumeMounts(this.index, this.builder.build());
        }

        @Override
        public N endVolumeMount() {
            return this.and();
        }
    }

    public class SecurityContextNestedImpl<N>
    extends SecurityContextFluentImpl<ContainerFluent.SecurityContextNested<N>>
    implements ContainerFluent.SecurityContextNested<N>,
    Nested<N> {
        private final SecurityContextBuilder builder;

        SecurityContextNestedImpl(SecurityContext item) {
            this.builder = new SecurityContextBuilder(this, item);
        }

        SecurityContextNestedImpl() {
            this.builder = new SecurityContextBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withSecurityContext(this.builder.build());
        }

        @Override
        public N endSecurityContext() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<ContainerFluent.ResourcesNested<N>>
    implements ContainerFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<ContainerFluent.ReadinessProbeNested<N>>
    implements ContainerFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class PortsNestedImpl<N>
    extends ContainerPortFluentImpl<ContainerFluent.PortsNested<N>>
    implements ContainerFluent.PortsNested<N>,
    Nested<N> {
        private final ContainerPortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, ContainerPort item) {
            this.index = index;
            this.builder = new ContainerPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new ContainerPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<ContainerFluent.LivenessProbeNested<N>>
    implements ContainerFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class LifecycleNestedImpl<N>
    extends LifecycleFluentImpl<ContainerFluent.LifecycleNested<N>>
    implements ContainerFluent.LifecycleNested<N>,
    Nested<N> {
        private final LifecycleBuilder builder;

        LifecycleNestedImpl(Lifecycle item) {
            this.builder = new LifecycleBuilder(this, item);
        }

        LifecycleNestedImpl() {
            this.builder = new LifecycleBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withLifecycle(this.builder.build());
        }

        @Override
        public N endLifecycle() {
            return this.and();
        }
    }

    public class EnvNestedImpl<N>
    extends EnvVarFluentImpl<ContainerFluent.EnvNested<N>>
    implements ContainerFluent.EnvNested<N>,
    Nested<N> {
        private final EnvVarBuilder builder;
        private final int index;

        EnvNestedImpl(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        EnvNestedImpl() {
            this.index = -1;
            this.builder = new EnvVarBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.setToEnv(this.index, this.builder.build());
        }

        @Override
        public N endEnv() {
            return this.and();
        }
    }
}

