/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_5.extensions;

import io.fabric8.kubernetes.api.builder.v2_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_5.Nested;
import io.fabric8.kubernetes.api.model.v2_5.ObjectMeta;
import io.fabric8.kubernetes.api.model.v2_5.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v2_5.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v2_5.extensions.Scale;
import io.fabric8.kubernetes.api.model.v2_5.extensions.ScaleFluent;
import io.fabric8.kubernetes.api.model.v2_5.extensions.ScaleSpec;
import io.fabric8.kubernetes.api.model.v2_5.extensions.ScaleSpecBuilder;
import io.fabric8.kubernetes.api.model.v2_5.extensions.ScaleSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v2_5.extensions.ScaleStatus;
import io.fabric8.kubernetes.api.model.v2_5.extensions.ScaleStatusBuilder;
import io.fabric8.kubernetes.api.model.v2_5.extensions.ScaleStatusFluentImpl;

public class ScaleFluentImpl<A extends ScaleFluent<A>>
extends BaseFluent<A>
implements ScaleFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ScaleSpecBuilder spec;
    private ScaleStatusBuilder status;

    public ScaleFluentImpl() {
    }

    public ScaleFluentImpl(Scale instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ScaleFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ScaleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ScaleFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ScaleFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ScaleFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ScaleSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ScaleSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ScaleSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new ScaleSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ScaleFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ScaleFluent.SpecNested<A> withNewSpecLike(ScaleSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ScaleFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ScaleFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ScaleSpecBuilder().build());
    }

    @Override
    public ScaleFluent.SpecNested<A> editOrNewSpecLike(ScaleSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    public A withNewSpec(Integer replicas) {
        return this.withSpec(new ScaleSpec(replicas));
    }

    @Override
    @Deprecated
    public ScaleStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ScaleStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ScaleStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new ScaleStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ScaleFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ScaleFluent.StatusNested<A> withNewStatusLike(ScaleStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ScaleFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ScaleFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ScaleStatusBuilder().build());
    }

    @Override
    public ScaleFluent.StatusNested<A> editOrNewStatusLike(ScaleStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScaleFluentImpl that = (ScaleFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends ScaleStatusFluentImpl<ScaleFluent.StatusNested<N>>
    implements ScaleFluent.StatusNested<N>,
    Nested<N> {
        private final ScaleStatusBuilder builder;

        StatusNestedImpl(ScaleStatus item) {
            this.builder = new ScaleStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ScaleStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ScaleFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ScaleSpecFluentImpl<ScaleFluent.SpecNested<N>>
    implements ScaleFluent.SpecNested<N>,
    Nested<N> {
        private final ScaleSpecBuilder builder;

        SpecNestedImpl(ScaleSpec item) {
            this.builder = new ScaleSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ScaleSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ScaleFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ScaleFluent.MetadataNested<N>>
    implements ScaleFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ScaleFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

