/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_5;

import io.fabric8.kubernetes.api.builder.v2_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_5.Predicate;
import io.fabric8.openshift.api.model.v2_5.ClusterRoleScopeRestriction;
import io.fabric8.openshift.api.model.v2_5.ClusterRoleScopeRestrictionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClusterRoleScopeRestrictionFluentImpl<A extends ClusterRoleScopeRestrictionFluent<A>>
extends BaseFluent<A>
implements ClusterRoleScopeRestrictionFluent<A> {
    private Boolean allowEscalation;
    private List<String> namespaces = new ArrayList<String>();
    private List<String> roleNames = new ArrayList<String>();

    public ClusterRoleScopeRestrictionFluentImpl() {
    }

    public ClusterRoleScopeRestrictionFluentImpl(ClusterRoleScopeRestriction instance) {
        this.withAllowEscalation(instance.getAllowEscalation());
        this.withNamespaces(instance.getNamespaces());
        this.withRoleNames(instance.getRoleNames());
    }

    @Override
    public Boolean isAllowEscalation() {
        return this.allowEscalation;
    }

    @Override
    public A withAllowEscalation(Boolean allowEscalation) {
        this.allowEscalation = allowEscalation;
        return (A)this;
    }

    @Override
    public Boolean hasAllowEscalation() {
        return this.allowEscalation != null;
    }

    @Override
    public A addToNamespaces(int index, String item) {
        this.namespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNamespaces(int index, String item) {
        this.namespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNamespaces(String ... items) {
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNamespaces(Collection<String> items) {
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNamespaces(String ... items) {
        for (String item : items) {
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    @Override
    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    @Override
    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    @Override
    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withNamespaces(List<String> namespaces) {
        this.namespaces.clear();
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withNamespaces(String ... namespaces) {
        this.namespaces.clear();
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    public A addToRoleNames(int index, String item) {
        this.roleNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRoleNames(int index, String item) {
        this.roleNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRoleNames(String ... items) {
        for (String item : items) {
            this.roleNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRoleNames(Collection<String> items) {
        for (String item : items) {
            this.roleNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoleNames(String ... items) {
        for (String item : items) {
            this.roleNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRoleNames(Collection<String> items) {
        for (String item : items) {
            this.roleNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRoleNames() {
        return this.roleNames;
    }

    @Override
    public String getRoleName(int index) {
        return this.roleNames.get(index);
    }

    @Override
    public String getFirstRoleName() {
        return this.roleNames.get(0);
    }

    @Override
    public String getLastRoleName() {
        return this.roleNames.get(this.roleNames.size() - 1);
    }

    @Override
    public String getMatchingRoleName(Predicate<String> predicate) {
        for (String item : this.roleNames) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withRoleNames(List<String> roleNames) {
        this.roleNames.clear();
        if (roleNames != null) {
            for (String item : roleNames) {
                this.addToRoleNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRoleNames(String ... roleNames) {
        this.roleNames.clear();
        if (roleNames != null) {
            for (String item : roleNames) {
                this.addToRoleNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleNames() {
        return this.roleNames != null && !this.roleNames.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterRoleScopeRestrictionFluentImpl that = (ClusterRoleScopeRestrictionFluentImpl)o;
        if (this.allowEscalation != null ? !this.allowEscalation.equals(that.allowEscalation) : that.allowEscalation != null) {
            return false;
        }
        if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) {
            return false;
        }
        return !(this.roleNames != null ? !this.roleNames.equals(that.roleNames) : that.roleNames != null);
    }
}

