/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v2_5.internal.readiness;

import io.fabric8.kubernetes.api.model.v2_5.HasMetadata;
import io.fabric8.kubernetes.clnt.v2_5.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v2_5.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.clnt.v2_5.Watcher;
import io.fabric8.kubernetes.clnt.v2_5.internal.readiness.Readiness;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class ReadinessWatcher<T extends HasMetadata>
implements Watcher<T> {
    private final BlockingQueue<T> queue = new ArrayBlockingQueue<T>(1);
    private final T resource;

    public ReadinessWatcher(T resource) {
        this.resource = resource;
    }

    @Override
    public void eventReceived(Watcher.Action action, T resource) {
        switch (action) {
            case MODIFIED: {
                if (!Readiness.isReady(resource)) break;
                this.queue.add(resource);
                break;
            }
        }
    }

    @Override
    public void onClose(KubernetesClientException e) {
    }

    public T await(long amount, TimeUnit timeUnit) {
        try {
            HasMetadata item = (HasMetadata)this.queue.poll(amount, timeUnit);
            if (item != null) {
                return (T)item;
            }
            throw new KubernetesClientTimeoutException((HasMetadata)this.resource, amount, timeUnit);
        }
        catch (InterruptedException e) {
            throw new KubernetesClientTimeoutException((HasMetadata)this.resource, amount, timeUnit);
        }
    }
}

