/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_5;

import io.fabric8.kubernetes.api.builder.v2_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_5.EnvVar;
import io.fabric8.kubernetes.api.model.v2_5.EnvVarFluent;
import io.fabric8.kubernetes.api.model.v2_5.EnvVarFluentImpl;

public class EnvVarBuilder
extends EnvVarFluentImpl<EnvVarBuilder>
implements VisitableBuilder<EnvVar, EnvVarBuilder> {
    EnvVarFluent<?> fluent;
    Boolean validationEnabled;

    public EnvVarBuilder() {
        this(true);
    }

    public EnvVarBuilder(Boolean validationEnabled) {
        this(new EnvVar(), validationEnabled);
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EnvVar(), validationEnabled);
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent, EnvVar instance) {
        this(fluent, instance, true);
    }

    public EnvVarBuilder(EnvVarFluent<?> fluent, EnvVar instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
        fluent.withValueFrom(instance.getValueFrom());
        this.validationEnabled = validationEnabled;
    }

    public EnvVarBuilder(EnvVar instance) {
        this(instance, (Boolean)true);
    }

    public EnvVarBuilder(EnvVar instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withValue(instance.getValue());
        this.withValueFrom(instance.getValueFrom());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EnvVar build() {
        EnvVar buildable = new EnvVar(this.fluent.getName(), this.fluent.getValue(), this.fluent.getValueFrom());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnvVarBuilder that = (EnvVarBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

