/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_5.extensions;

import io.fabric8.kubernetes.api.builder.v2_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_5.extensions.NetworkPolicyPeer;
import io.fabric8.kubernetes.api.model.v2_5.extensions.NetworkPolicyPeerFluent;
import io.fabric8.kubernetes.api.model.v2_5.extensions.NetworkPolicyPeerFluentImpl;

public class NetworkPolicyPeerBuilder
extends NetworkPolicyPeerFluentImpl<NetworkPolicyPeerBuilder>
implements VisitableBuilder<NetworkPolicyPeer, NetworkPolicyPeerBuilder> {
    NetworkPolicyPeerFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkPolicyPeerBuilder() {
        this(true);
    }

    public NetworkPolicyPeerBuilder(Boolean validationEnabled) {
        this(new NetworkPolicyPeer(), validationEnabled);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkPolicyPeer(), validationEnabled);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent, NetworkPolicyPeer instance) {
        this(fluent, instance, true);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeerFluent<?> fluent, NetworkPolicyPeer instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNamespaceSelector(instance.getNamespaceSelector());
        fluent.withPodSelector(instance.getPodSelector());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeer instance) {
        this(instance, (Boolean)true);
    }

    public NetworkPolicyPeerBuilder(NetworkPolicyPeer instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withPodSelector(instance.getPodSelector());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkPolicyPeer build() {
        NetworkPolicyPeer buildable = new NetworkPolicyPeer(this.fluent.getNamespaceSelector(), this.fluent.getPodSelector());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyPeerBuilder that = (NetworkPolicyPeerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

