/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_5;

import io.fabric8.kubernetes.api.builder.v2_5.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_5.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_5.PodSecurityContext;
import io.fabric8.kubernetes.api.model.v2_5.PodSecurityContextFluent;
import io.fabric8.kubernetes.api.model.v2_5.PodSecurityContextFluentImpl;

public class PodSecurityContextBuilder
extends PodSecurityContextFluentImpl<PodSecurityContextBuilder>
implements VisitableBuilder<PodSecurityContext, PodSecurityContextBuilder> {
    PodSecurityContextFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityContextBuilder() {
        this(true);
    }

    public PodSecurityContextBuilder(Boolean validationEnabled) {
        this(new PodSecurityContext(), validationEnabled);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodSecurityContext(), validationEnabled);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent, PodSecurityContext instance) {
        this(fluent, instance, true);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent, PodSecurityContext instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFsGroup(instance.getFsGroup());
        fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
        fluent.withSupplementalGroups(instance.getSupplementalGroups());
        this.validationEnabled = validationEnabled;
    }

    public PodSecurityContextBuilder(PodSecurityContext instance) {
        this(instance, (Boolean)true);
    }

    public PodSecurityContextBuilder(PodSecurityContext instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFsGroup(instance.getFsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PodSecurityContext build() {
        PodSecurityContext buildable = new PodSecurityContext(this.fluent.getFsGroup(), this.fluent.isRunAsNonRoot(), this.fluent.getRunAsUser(), this.fluent.getSeLinuxOptions(), this.fluent.getSupplementalGroups());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityContextBuilder that = (PodSecurityContextBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

