/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_5;

import io.fabric8.kubernetes.api.builder.v2_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_5.Nested;
import io.fabric8.kubernetes.api.builder.v2_5.Predicate;
import io.fabric8.openshift.api.model.v2_5.RoutePort;
import io.fabric8.openshift.api.model.v2_5.RoutePortBuilder;
import io.fabric8.openshift.api.model.v2_5.RoutePortFluentImpl;
import io.fabric8.openshift.api.model.v2_5.RouteSpec;
import io.fabric8.openshift.api.model.v2_5.RouteSpecFluent;
import io.fabric8.openshift.api.model.v2_5.RouteTargetReference;
import io.fabric8.openshift.api.model.v2_5.RouteTargetReferenceBuilder;
import io.fabric8.openshift.api.model.v2_5.RouteTargetReferenceFluentImpl;
import io.fabric8.openshift.api.model.v2_5.TLSConfig;
import io.fabric8.openshift.api.model.v2_5.TLSConfigBuilder;
import io.fabric8.openshift.api.model.v2_5.TLSConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RouteSpecFluentImpl<A extends RouteSpecFluent<A>>
extends BaseFluent<A>
implements RouteSpecFluent<A> {
    private List<RouteTargetReferenceBuilder> alternateBackends = new ArrayList<RouteTargetReferenceBuilder>();
    private String host;
    private String path;
    private RoutePortBuilder port;
    private TLSConfigBuilder tls;
    private RouteTargetReferenceBuilder to;
    private String wildcardPolicy;

    public RouteSpecFluentImpl() {
    }

    public RouteSpecFluentImpl(RouteSpec instance) {
        this.withAlternateBackends(instance.getAlternateBackends());
        this.withHost(instance.getHost());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withTls(instance.getTls());
        this.withTo(instance.getTo());
        this.withWildcardPolicy(instance.getWildcardPolicy());
    }

    @Override
    public A addToAlternateBackends(int index, RouteTargetReference item) {
        RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.alternateBackends.add(index >= 0 ? index : this.alternateBackends.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAlternateBackends(int index, RouteTargetReference item) {
        RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.alternateBackends.size()) {
            this.alternateBackends.add(builder);
        } else {
            this.alternateBackends.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAlternateBackends(RouteTargetReference ... items) {
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.add(builder);
            this.alternateBackends.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAlternateBackends(Collection<RouteTargetReference> items) {
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.add(builder);
            this.alternateBackends.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAlternateBackends(RouteTargetReference ... items) {
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.remove(builder);
            this.alternateBackends.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAlternateBackends(Collection<RouteTargetReference> items) {
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.remove(builder);
            this.alternateBackends.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RouteTargetReference> getAlternateBackends() {
        return RouteSpecFluentImpl.build(this.alternateBackends);
    }

    @Override
    public List<RouteTargetReference> buildAlternateBackends() {
        return RouteSpecFluentImpl.build(this.alternateBackends);
    }

    @Override
    public RouteTargetReference buildAlternateBackend(int index) {
        return this.alternateBackends.get(index).build();
    }

    @Override
    public RouteTargetReference buildFirstAlternateBackend() {
        return this.alternateBackends.get(0).build();
    }

    @Override
    public RouteTargetReference buildLastAlternateBackend() {
        return this.alternateBackends.get(this.alternateBackends.size() - 1).build();
    }

    @Override
    public RouteTargetReference buildMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
        for (RouteTargetReferenceBuilder item : this.alternateBackends) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withAlternateBackends(List<RouteTargetReference> alternateBackends) {
        this._visitables.removeAll(this.alternateBackends);
        this.alternateBackends.clear();
        if (alternateBackends != null) {
            for (RouteTargetReference item : alternateBackends) {
                this.addToAlternateBackends(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAlternateBackends(RouteTargetReference ... alternateBackends) {
        this.alternateBackends.clear();
        if (alternateBackends != null) {
            for (RouteTargetReference item : alternateBackends) {
                this.addToAlternateBackends(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAlternateBackends() {
        return this.alternateBackends != null && !this.alternateBackends.isEmpty();
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackend() {
        return new AlternateBackendsNestedImpl();
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackendLike(RouteTargetReference item) {
        return new AlternateBackendsNestedImpl(-1, item);
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> setNewAlternateBackendLike(int index, RouteTargetReference item) {
        return new AlternateBackendsNestedImpl(index, item);
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> editAlternateBackend(int index) {
        if (this.alternateBackends.size() <= index) {
            throw new RuntimeException("Can't edit alternateBackends. Index exceeds size.");
        }
        return this.setNewAlternateBackendLike(index, this.buildAlternateBackend(index));
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> editFirstAlternateBackend() {
        if (this.alternateBackends.size() == 0) {
            throw new RuntimeException("Can't edit first alternateBackends. The list is empty.");
        }
        return this.setNewAlternateBackendLike(0, this.buildAlternateBackend(0));
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> editLastAlternateBackend() {
        int index = this.alternateBackends.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last alternateBackends. The list is empty.");
        }
        return this.setNewAlternateBackendLike(index, this.buildAlternateBackend(index));
    }

    @Override
    public RouteSpecFluent.AlternateBackendsNested<A> editMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.alternateBackends.size(); ++i) {
            if (!predicate.apply(this.alternateBackends.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching alternateBackends. No match found.");
        }
        return this.setNewAlternateBackendLike(index, this.buildAlternateBackend(index));
    }

    @Override
    public A addNewAlternateBackend(String kind, String name, Integer weight) {
        return this.addToAlternateBackends(new RouteTargetReference(kind, name, weight));
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public RoutePort getPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public RoutePort buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    @Override
    public A withPort(RoutePort port) {
        this._visitables.remove(this.port);
        if (port != null) {
            this.port = new RoutePortBuilder(port);
            this._visitables.add(this.port);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public RouteSpecFluent.PortNested<A> withNewPort() {
        return new PortNestedImpl();
    }

    @Override
    public RouteSpecFluent.PortNested<A> withNewPortLike(RoutePort item) {
        return new PortNestedImpl(item);
    }

    @Override
    public RouteSpecFluent.PortNested<A> editPort() {
        return this.withNewPortLike(this.getPort());
    }

    @Override
    public RouteSpecFluent.PortNested<A> editOrNewPort() {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : new RoutePortBuilder().build());
    }

    @Override
    public RouteSpecFluent.PortNested<A> editOrNewPortLike(RoutePort item) {
        return this.withNewPortLike(this.getPort() != null ? this.getPort() : item);
    }

    @Override
    @Deprecated
    public TLSConfig getTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public TLSConfig buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    @Override
    public A withTls(TLSConfig tls) {
        this._visitables.remove(this.tls);
        if (tls != null) {
            this.tls = new TLSConfigBuilder(tls);
            this._visitables.add(this.tls);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTls() {
        return this.tls != null;
    }

    @Override
    public RouteSpecFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    @Override
    public RouteSpecFluent.TlsNested<A> withNewTlsLike(TLSConfig item) {
        return new TlsNestedImpl(item);
    }

    @Override
    public RouteSpecFluent.TlsNested<A> editTls() {
        return this.withNewTlsLike(this.getTls());
    }

    @Override
    public RouteSpecFluent.TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : new TLSConfigBuilder().build());
    }

    @Override
    public RouteSpecFluent.TlsNested<A> editOrNewTlsLike(TLSConfig item) {
        return this.withNewTlsLike(this.getTls() != null ? this.getTls() : item);
    }

    @Override
    @Deprecated
    public RouteTargetReference getTo() {
        return this.to != null ? this.to.build() : null;
    }

    @Override
    public RouteTargetReference buildTo() {
        return this.to != null ? this.to.build() : null;
    }

    @Override
    public A withTo(RouteTargetReference to) {
        this._visitables.remove(this.to);
        if (to != null) {
            this.to = new RouteTargetReferenceBuilder(to);
            this._visitables.add(this.to);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTo() {
        return this.to != null;
    }

    @Override
    public RouteSpecFluent.ToNested<A> withNewTo() {
        return new ToNestedImpl();
    }

    @Override
    public RouteSpecFluent.ToNested<A> withNewToLike(RouteTargetReference item) {
        return new ToNestedImpl(item);
    }

    @Override
    public RouteSpecFluent.ToNested<A> editTo() {
        return this.withNewToLike(this.getTo());
    }

    @Override
    public RouteSpecFluent.ToNested<A> editOrNewTo() {
        return this.withNewToLike(this.getTo() != null ? this.getTo() : new RouteTargetReferenceBuilder().build());
    }

    @Override
    public RouteSpecFluent.ToNested<A> editOrNewToLike(RouteTargetReference item) {
        return this.withNewToLike(this.getTo() != null ? this.getTo() : item);
    }

    @Override
    public A withNewTo(String kind, String name, Integer weight) {
        return this.withTo(new RouteTargetReference(kind, name, weight));
    }

    @Override
    public String getWildcardPolicy() {
        return this.wildcardPolicy;
    }

    @Override
    public A withWildcardPolicy(String wildcardPolicy) {
        this.wildcardPolicy = wildcardPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasWildcardPolicy() {
        return this.wildcardPolicy != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteSpecFluentImpl that = (RouteSpecFluentImpl)o;
        if (this.alternateBackends != null ? !this.alternateBackends.equals(that.alternateBackends) : that.alternateBackends != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.tls != null ? !this.tls.equals(that.tls) : that.tls != null) {
            return false;
        }
        if (this.to != null ? !this.to.equals(that.to) : that.to != null) {
            return false;
        }
        return !(this.wildcardPolicy != null ? !this.wildcardPolicy.equals(that.wildcardPolicy) : that.wildcardPolicy != null);
    }

    public class ToNestedImpl<N>
    extends RouteTargetReferenceFluentImpl<RouteSpecFluent.ToNested<N>>
    implements RouteSpecFluent.ToNested<N>,
    Nested<N> {
        private final RouteTargetReferenceBuilder builder;

        ToNestedImpl(RouteTargetReference item) {
            this.builder = new RouteTargetReferenceBuilder(this, item);
        }

        ToNestedImpl() {
            this.builder = new RouteTargetReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.withTo(this.builder.build());
        }

        @Override
        public N endTo() {
            return this.and();
        }
    }

    public class TlsNestedImpl<N>
    extends TLSConfigFluentImpl<RouteSpecFluent.TlsNested<N>>
    implements RouteSpecFluent.TlsNested<N>,
    Nested<N> {
        private final TLSConfigBuilder builder;

        TlsNestedImpl(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        TlsNestedImpl() {
            this.builder = new TLSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.withTls(this.builder.build());
        }

        @Override
        public N endTls() {
            return this.and();
        }
    }

    public class PortNestedImpl<N>
    extends RoutePortFluentImpl<RouteSpecFluent.PortNested<N>>
    implements RouteSpecFluent.PortNested<N>,
    Nested<N> {
        private final RoutePortBuilder builder;

        PortNestedImpl(RoutePort item) {
            this.builder = new RoutePortBuilder(this, item);
        }

        PortNestedImpl() {
            this.builder = new RoutePortBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.withPort(this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class AlternateBackendsNestedImpl<N>
    extends RouteTargetReferenceFluentImpl<RouteSpecFluent.AlternateBackendsNested<N>>
    implements RouteSpecFluent.AlternateBackendsNested<N>,
    Nested<N> {
        private final RouteTargetReferenceBuilder builder;
        private final int index;

        AlternateBackendsNestedImpl(int index, RouteTargetReference item) {
            this.index = index;
            this.builder = new RouteTargetReferenceBuilder(this, item);
        }

        AlternateBackendsNestedImpl() {
            this.index = -1;
            this.builder = new RouteTargetReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluentImpl.this.setToAlternateBackends(this.index, this.builder.build());
        }

        @Override
        public N endAlternateBackend() {
            return this.and();
        }
    }
}

