/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v2_5.osgi;

import io.fabric8.kubernetes.api.model.v2_5.ComponentStatus;
import io.fabric8.kubernetes.api.model.v2_5.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v2_5.ConfigMap;
import io.fabric8.kubernetes.api.model.v2_5.ConfigMapList;
import io.fabric8.kubernetes.api.model.v2_5.DoneableComponentStatus;
import io.fabric8.kubernetes.api.model.v2_5.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.v2_5.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.v2_5.DoneableEvent;
import io.fabric8.kubernetes.api.model.v2_5.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.v2_5.DoneableNamespace;
import io.fabric8.kubernetes.api.model.v2_5.DoneableNode;
import io.fabric8.kubernetes.api.model.v2_5.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.v2_5.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v2_5.DoneablePod;
import io.fabric8.kubernetes.api.model.v2_5.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.v2_5.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.v2_5.DoneableSecret;
import io.fabric8.kubernetes.api.model.v2_5.DoneableSecurityContextConstraints;
import io.fabric8.kubernetes.api.model.v2_5.DoneableService;
import io.fabric8.kubernetes.api.model.v2_5.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.v2_5.Endpoints;
import io.fabric8.kubernetes.api.model.v2_5.EndpointsList;
import io.fabric8.kubernetes.api.model.v2_5.Event;
import io.fabric8.kubernetes.api.model.v2_5.EventList;
import io.fabric8.kubernetes.api.model.v2_5.HasMetadata;
import io.fabric8.kubernetes.api.model.v2_5.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v2_5.LimitRange;
import io.fabric8.kubernetes.api.model.v2_5.LimitRangeList;
import io.fabric8.kubernetes.api.model.v2_5.Namespace;
import io.fabric8.kubernetes.api.model.v2_5.NamespaceList;
import io.fabric8.kubernetes.api.model.v2_5.Node;
import io.fabric8.kubernetes.api.model.v2_5.NodeList;
import io.fabric8.kubernetes.api.model.v2_5.PersistentVolume;
import io.fabric8.kubernetes.api.model.v2_5.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v2_5.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v2_5.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v2_5.Pod;
import io.fabric8.kubernetes.api.model.v2_5.PodList;
import io.fabric8.kubernetes.api.model.v2_5.ReplicationController;
import io.fabric8.kubernetes.api.model.v2_5.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v2_5.ResourceQuota;
import io.fabric8.kubernetes.api.model.v2_5.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v2_5.RootPaths;
import io.fabric8.kubernetes.api.model.v2_5.Secret;
import io.fabric8.kubernetes.api.model.v2_5.SecretList;
import io.fabric8.kubernetes.api.model.v2_5.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.v2_5.SecurityContextConstraintsList;
import io.fabric8.kubernetes.api.model.v2_5.ServiceAccount;
import io.fabric8.kubernetes.api.model.v2_5.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v2_5.ServiceList;
import io.fabric8.kubernetes.api.model.v2_5.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.v2_5.apiextensions.CustomResourceDefinitionList;
import io.fabric8.kubernetes.api.model.v2_5.apiextensions.DoneableCustomResourceDefinition;
import io.fabric8.kubernetes.clnt.v2_5.Adapters;
import io.fabric8.kubernetes.clnt.v2_5.BaseClient;
import io.fabric8.kubernetes.clnt.v2_5.Config;
import io.fabric8.kubernetes.clnt.v2_5.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v2_5.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v2_5.ExtensionAdapter;
import io.fabric8.kubernetes.clnt.v2_5.Handlers;
import io.fabric8.kubernetes.clnt.v2_5.KubernetesClient;
import io.fabric8.kubernetes.clnt.v2_5.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v2_5.RequestConfig;
import io.fabric8.kubernetes.clnt.v2_5.ResourceHandler;
import io.fabric8.kubernetes.clnt.v2_5.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v2_5.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v2_5.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v2_5.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v2_5.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v2_5.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v2_5.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v2_5.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v2_5.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v2_5.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v2_5.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v2_5.dsl.Resource;
import io.fabric8.kubernetes.clnt.v2_5.dsl.RollableScalableResource;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true, configurationPid="io.fabric8.kubernetes.clnt.v2_5", policy=ConfigurationPolicy.OPTIONAL)
@Service(value={KubernetesClient.class, NamespacedKubernetesClient.class})
@References(value={@Reference(referenceInterface=ResourceHandler.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindResourceHandler", unbind="unbindResourceHandler"), @Reference(referenceInterface=ExtensionAdapter.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindExtensionAdapter", unbind="unbindExtensionAdapter")})
public class ManagedKubernetesClient
extends BaseClient
implements NamespacedKubernetesClient {
    private NamespacedKubernetesClient delegate;

    @Activate
    public void activate(Map<String, Object> properties) {
        ConfigBuilder builder = new ConfigBuilder();
        if (properties.containsKey("kubernetes.master")) {
            builder.withMasterUrl((String)properties.get("kubernetes.master"));
        }
        if (properties.containsKey("kubernetes.api.version")) {
            builder.withApiVersion((String)properties.get("kubernetes.api.version"));
        }
        if (properties.containsKey("kubernetes.namespace")) {
            builder.withNamespace((String)properties.get("kubernetes.namespace"));
        }
        if (properties.containsKey("kubernetes.certs.ca.file")) {
            builder.withCaCertFile((String)properties.get("kubernetes.certs.ca.file"));
        }
        if (properties.containsKey("kubernetes.certs.ca.data")) {
            builder.withCaCertData((String)properties.get("kubernetes.certs.ca.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.file")) {
            builder.withClientCertFile((String)properties.get("kubernetes.certs.client.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.data")) {
            builder.withClientCertData((String)properties.get("kubernetes.certs.client.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.file")) {
            builder.withClientKeyFile((String)properties.get("kubernetes.certs.client.key.file"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.data")) {
            builder.withClientKeyData((String)properties.get("kubernetes.certs.client.key.data"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.algo")) {
            builder.withClientKeyAlgo((String)properties.get("kubernetes.certs.client.key.algo"));
        }
        if (properties.containsKey("kubernetes.certs.client.key.passphrase")) {
            builder.withClientKeyPassphrase((String)properties.get("kubernetes.certs.client.key.passphrase"));
        }
        if (properties.containsKey("kubernetes.auth.basic.username")) {
            builder.withUsername((String)properties.get("kubernetes.auth.basic.username"));
        }
        if (properties.containsKey("kubernetes.auth.basic.password")) {
            builder.withPassword((String)properties.get("kubernetes.auth.basic.password"));
        }
        if (properties.containsKey("kubernetes.auth.token")) {
            builder.withOauthToken((String)properties.get("kubernetes.auth.token"));
        }
        if (properties.containsKey("kubernetes.watch.reconnectInterval")) {
            builder.withWatchReconnectInterval(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectInterval")));
        }
        if (properties.containsKey("kubernetes.watch.reconnectLimit")) {
            builder.withWatchReconnectLimit(Integer.parseInt((String)properties.get("kubernetes.watch.reconnectLimit")));
        }
        if (properties.containsKey("kubernetes.request.timeout")) {
            builder.withRequestTimeout(Integer.parseInt((String)properties.get("kubernetes.request.timeout")));
        }
        if (properties.containsKey("http.proxy")) {
            builder.withHttpProxy((String)properties.get("http.proxy"));
        }
        if (properties.containsKey("https.proxy")) {
            builder.withHttpsProxy((String)properties.get("https.proxy"));
        }
        if (properties.containsKey("no.proxy")) {
            String noProxyProperty = (String)properties.get("no.proxy");
            builder.withNoProxy(noProxyProperty.split(","));
        }
        if (properties.containsKey("kubernetes.websocket.timeout")) {
            builder.withWebsocketTimeout(Long.parseLong((String)properties.get("kubernetes.websocket.timeout")));
        }
        if (properties.containsKey("kubernetes.websocket.ping.interval")) {
            builder.withWebsocketPingInterval(Long.parseLong((String)properties.get("kubernetes.websocket.ping.interval")));
        }
        if (properties.containsKey("kubernetes.truststore.file")) {
            builder.withTrustStoreFile((String)properties.get("kubernetes.truststore.file"));
        }
        if (properties.containsKey("kubernetes.truststore.passphrase")) {
            builder.withTrustStorePassphrase((String)properties.get("kubernetes.truststore.passphrase"));
        }
        if (properties.containsKey("kubernetes.keystore.file")) {
            builder.withKeyStoreFile((String)properties.get("kubernetes.keystore.file"));
        }
        if (properties.containsKey("kubernetes.keystore.passphrase")) {
            builder.withKeyStorePassphrase((String)properties.get("kubernetes.keystore.passphrase"));
        }
        this.delegate = new DefaultKubernetesClient(builder.build());
    }

    @Deactivate
    public void deactivate() {
        this.delegate.close();
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return this.delegate.componentstatuses();
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata ... items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata is) {
        return this.delegate.resource(is);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<io.fabric8.kubernetes.api.model.v2_5.Service, ServiceList, DoneableService, Resource<io.fabric8.kubernetes.api.model.v2_5.Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, Resource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return this.delegate.securityContextConstraints();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public RootPaths rootPaths() {
        return this.delegate.rootPaths();
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.delegate.extensions();
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.delegate.apps();
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.delegate.autoscaling();
    }

    @Override
    public NonNamespaceOperation<CustomResourceDefinition, CustomResourceDefinitionList, DoneableCustomResourceDefinition, Resource<CustomResourceDefinition, DoneableCustomResourceDefinition>> customResourceDefinitions() {
        return this.delegate.customResourceDefinitions();
    }

    @Override
    public String getApiVersion() {
        return this.delegate.getApiVersion();
    }

    @Override
    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    @Override
    public URL getMasterUrl() {
        return this.delegate.getMasterUrl();
    }

    @Override
    public <C> C adapt(Class<C> type) {
        return this.delegate.adapt(type);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public Config getConfiguration() {
        return this.delegate.getConfiguration();
    }

    public void bindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.register(resourceHandler);
    }

    public void unbindResourceHandler(ResourceHandler resourceHandler) {
        Handlers.unregister(resourceHandler);
    }

    public void bindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.register(adapter);
    }

    public void unbindExtensionAdapter(ExtensionAdapter adapter) {
        Adapters.unregister(adapter);
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return (NamespacedKubernetesClient)this.delegate.inAnyNamespace();
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String name) {
        return (NamespacedKubernetesClient)this.delegate.inNamespace(name);
    }

    @Override
    public FunctionCallable<NamespacedKubernetesClient> withRequestConfig(RequestConfig requestConfig) {
        return this.delegate.withRequestConfig(requestConfig);
    }
}

