/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_5;

import io.fabric8.kubernetes.api.builder.v2_5.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_5.Nested;
import io.fabric8.kubernetes.api.builder.v2_5.Predicate;
import io.fabric8.kubernetes.api.model.v2_5.FSGroupStrategyOptions;
import io.fabric8.kubernetes.api.model.v2_5.FSGroupStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.v2_5.FSGroupStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.v2_5.ObjectMeta;
import io.fabric8.kubernetes.api.model.v2_5.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v2_5.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v2_5.RunAsUserStrategyOptions;
import io.fabric8.kubernetes.api.model.v2_5.RunAsUserStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.v2_5.RunAsUserStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.v2_5.SELinuxContextStrategyOptions;
import io.fabric8.kubernetes.api.model.v2_5.SELinuxContextStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.v2_5.SELinuxContextStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.v2_5.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.v2_5.SecurityContextConstraintsFluent;
import io.fabric8.kubernetes.api.model.v2_5.SupplementalGroupsStrategyOptions;
import io.fabric8.kubernetes.api.model.v2_5.SupplementalGroupsStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.v2_5.SupplementalGroupsStrategyOptionsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SecurityContextConstraintsFluentImpl<A extends SecurityContextConstraintsFluent<A>>
extends BaseFluent<A>
implements SecurityContextConstraintsFluent<A> {
    private Boolean allowHostDirVolumePlugin;
    private Boolean allowHostIPC;
    private Boolean allowHostNetwork;
    private Boolean allowHostPID;
    private Boolean allowHostPorts;
    private Boolean allowPrivilegedContainer;
    private List<String> allowedCapabilities = new ArrayList<String>();
    private String apiVersion;
    private List<String> defaultAddCapabilities = new ArrayList<String>();
    private FSGroupStrategyOptionsBuilder fsGroup;
    private List<String> groups = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private Integer priority;
    private Boolean readOnlyRootFilesystem;
    private List<String> requiredDropCapabilities = new ArrayList<String>();
    private RunAsUserStrategyOptionsBuilder runAsUser;
    private SELinuxContextStrategyOptionsBuilder seLinuxContext;
    private List<String> seccompProfiles = new ArrayList<String>();
    private SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
    private List<String> users = new ArrayList<String>();
    private List<String> volumes = new ArrayList<String>();

    public SecurityContextConstraintsFluentImpl() {
    }

    public SecurityContextConstraintsFluentImpl(SecurityContextConstraints instance) {
        this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin());
        this.withAllowHostIPC(instance.getAllowHostIPC());
        this.withAllowHostNetwork(instance.getAllowHostNetwork());
        this.withAllowHostPID(instance.getAllowHostPID());
        this.withAllowHostPorts(instance.getAllowHostPorts());
        this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer());
        this.withAllowedCapabilities(instance.getAllowedCapabilities());
        this.withApiVersion(instance.getApiVersion());
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        this.withFsGroup(instance.getFsGroup());
        this.withGroups(instance.getGroups());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withPriority(instance.getPriority());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxContext(instance.getSeLinuxContext());
        this.withSeccompProfiles(instance.getSeccompProfiles());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withUsers(instance.getUsers());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Boolean isAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin;
    }

    @Override
    public A withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin) {
        this.allowHostDirVolumePlugin = allowHostDirVolumePlugin;
        return (A)this;
    }

    @Override
    public Boolean hasAllowHostDirVolumePlugin() {
        return this.allowHostDirVolumePlugin != null;
    }

    @Override
    public Boolean isAllowHostIPC() {
        return this.allowHostIPC;
    }

    @Override
    public A withAllowHostIPC(Boolean allowHostIPC) {
        this.allowHostIPC = allowHostIPC;
        return (A)this;
    }

    @Override
    public Boolean hasAllowHostIPC() {
        return this.allowHostIPC != null;
    }

    @Override
    public Boolean isAllowHostNetwork() {
        return this.allowHostNetwork;
    }

    @Override
    public A withAllowHostNetwork(Boolean allowHostNetwork) {
        this.allowHostNetwork = allowHostNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasAllowHostNetwork() {
        return this.allowHostNetwork != null;
    }

    @Override
    public Boolean isAllowHostPID() {
        return this.allowHostPID;
    }

    @Override
    public A withAllowHostPID(Boolean allowHostPID) {
        this.allowHostPID = allowHostPID;
        return (A)this;
    }

    @Override
    public Boolean hasAllowHostPID() {
        return this.allowHostPID != null;
    }

    @Override
    public Boolean isAllowHostPorts() {
        return this.allowHostPorts;
    }

    @Override
    public A withAllowHostPorts(Boolean allowHostPorts) {
        this.allowHostPorts = allowHostPorts;
        return (A)this;
    }

    @Override
    public Boolean hasAllowHostPorts() {
        return this.allowHostPorts != null;
    }

    @Override
    public Boolean isAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer;
    }

    @Override
    public A withAllowPrivilegedContainer(Boolean allowPrivilegedContainer) {
        this.allowPrivilegedContainer = allowPrivilegedContainer;
        return (A)this;
    }

    @Override
    public Boolean hasAllowPrivilegedContainer() {
        return this.allowPrivilegedContainer != null;
    }

    @Override
    public A addToAllowedCapabilities(int index, String item) {
        this.allowedCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedCapabilities(int index, String item) {
        this.allowedCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedCapabilities(Collection<String> items) {
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedCapabilities(Collection<String> items) {
        for (String item : items) {
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    @Override
    public String getAllowedCapability(int index) {
        return this.allowedCapabilities.get(index);
    }

    @Override
    public String getFirstAllowedCapability() {
        return this.allowedCapabilities.get(0);
    }

    @Override
    public String getLastAllowedCapability() {
        return this.allowedCapabilities.get(this.allowedCapabilities.size() - 1);
    }

    @Override
    public String getMatchingAllowedCapability(Predicate<String> predicate) {
        for (String item : this.allowedCapabilities) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withAllowedCapabilities(List<String> allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAllowedCapabilities(String ... allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedCapabilities() {
        return this.allowedCapabilities != null && !this.allowedCapabilities.isEmpty();
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToDefaultAddCapabilities(int index, String item) {
        this.defaultAddCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDefaultAddCapabilities(int index, String item) {
        this.defaultAddCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDefaultAddCapabilities(String ... items) {
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDefaultAddCapabilities(Collection<String> items) {
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDefaultAddCapabilities(String ... items) {
        for (String item : items) {
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDefaultAddCapabilities(Collection<String> items) {
        for (String item : items) {
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDefaultAddCapabilities() {
        return this.defaultAddCapabilities;
    }

    @Override
    public String getDefaultAddCapability(int index) {
        return this.defaultAddCapabilities.get(index);
    }

    @Override
    public String getFirstDefaultAddCapability() {
        return this.defaultAddCapabilities.get(0);
    }

    @Override
    public String getLastDefaultAddCapability() {
        return this.defaultAddCapabilities.get(this.defaultAddCapabilities.size() - 1);
    }

    @Override
    public String getMatchingDefaultAddCapability(Predicate<String> predicate) {
        for (String item : this.defaultAddCapabilities) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities) {
        this.defaultAddCapabilities.clear();
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDefaultAddCapabilities(String ... defaultAddCapabilities) {
        this.defaultAddCapabilities.clear();
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultAddCapabilities() {
        return this.defaultAddCapabilities != null && !this.defaultAddCapabilities.isEmpty();
    }

    @Override
    @Deprecated
    public FSGroupStrategyOptions getFsGroup() {
        return this.fsGroup != null ? this.fsGroup.build() : null;
    }

    @Override
    public FSGroupStrategyOptions buildFsGroup() {
        return this.fsGroup != null ? this.fsGroup.build() : null;
    }

    @Override
    public A withFsGroup(FSGroupStrategyOptions fsGroup) {
        this._visitables.remove(this.fsGroup);
        if (fsGroup != null) {
            this.fsGroup = new FSGroupStrategyOptionsBuilder(fsGroup);
            this._visitables.add(this.fsGroup);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroup() {
        return new FsGroupNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item) {
        return new FsGroupNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> editFsGroup() {
        return this.withNewFsGroupLike(this.getFsGroup());
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroup() {
        return this.withNewFsGroupLike(this.getFsGroup() != null ? this.getFsGroup() : new FSGroupStrategyOptionsBuilder().build());
    }

    @Override
    public SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item) {
        return this.withNewFsGroupLike(this.getFsGroup() != null ? this.getFsGroup() : item);
    }

    @Override
    public A addToGroups(int index, String item) {
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(int index, String item) {
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(int index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withGroups(List<String> groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    @Override
    public Boolean hasPriority() {
        return this.priority != null;
    }

    @Override
    public Boolean isReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    @Override
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    @Override
    public A addToRequiredDropCapabilities(int index, String item) {
        this.requiredDropCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRequiredDropCapabilities(int index, String item) {
        this.requiredDropCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRequiredDropCapabilities(String ... items) {
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRequiredDropCapabilities(Collection<String> items) {
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequiredDropCapabilities(String ... items) {
        for (String item : items) {
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRequiredDropCapabilities(Collection<String> items) {
        for (String item : items) {
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRequiredDropCapabilities() {
        return this.requiredDropCapabilities;
    }

    @Override
    public String getRequiredDropCapability(int index) {
        return this.requiredDropCapabilities.get(index);
    }

    @Override
    public String getFirstRequiredDropCapability() {
        return this.requiredDropCapabilities.get(0);
    }

    @Override
    public String getLastRequiredDropCapability() {
        return this.requiredDropCapabilities.get(this.requiredDropCapabilities.size() - 1);
    }

    @Override
    public String getMatchingRequiredDropCapability(Predicate<String> predicate) {
        for (String item : this.requiredDropCapabilities) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities) {
        this.requiredDropCapabilities.clear();
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRequiredDropCapabilities(String ... requiredDropCapabilities) {
        this.requiredDropCapabilities.clear();
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequiredDropCapabilities() {
        return this.requiredDropCapabilities != null && !this.requiredDropCapabilities.isEmpty();
    }

    @Override
    @Deprecated
    public RunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser != null ? this.runAsUser.build() : null;
    }

    @Override
    public RunAsUserStrategyOptions buildRunAsUser() {
        return this.runAsUser != null ? this.runAsUser.build() : null;
    }

    @Override
    public A withRunAsUser(RunAsUserStrategyOptions runAsUser) {
        this._visitables.remove(this.runAsUser);
        if (runAsUser != null) {
            this.runAsUser = new RunAsUserStrategyOptionsBuilder(runAsUser);
            this._visitables.add(this.runAsUser);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUser() {
        return new RunAsUserNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return new RunAsUserNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> editRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser());
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser() != null ? this.getRunAsUser() : new RunAsUserStrategyOptionsBuilder().build());
    }

    @Override
    public SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUserLike(RunAsUserStrategyOptions item) {
        return this.withNewRunAsUserLike(this.getRunAsUser() != null ? this.getRunAsUser() : item);
    }

    @Override
    public A withNewRunAsUser(String type, Long uid, Long uidRangeMax, Long uidRangeMin) {
        return this.withRunAsUser(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
    }

    @Override
    @Deprecated
    public SELinuxContextStrategyOptions getSeLinuxContext() {
        return this.seLinuxContext != null ? this.seLinuxContext.build() : null;
    }

    @Override
    public SELinuxContextStrategyOptions buildSeLinuxContext() {
        return this.seLinuxContext != null ? this.seLinuxContext.build() : null;
    }

    @Override
    public A withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext) {
        this._visitables.remove(this.seLinuxContext);
        if (seLinuxContext != null) {
            this.seLinuxContext = new SELinuxContextStrategyOptionsBuilder(seLinuxContext);
            this._visitables.add(this.seLinuxContext);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeLinuxContext() {
        return this.seLinuxContext != null;
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContext() {
        return new SeLinuxContextNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContextLike(SELinuxContextStrategyOptions item) {
        return new SeLinuxContextNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editSeLinuxContext() {
        return this.withNewSeLinuxContextLike(this.getSeLinuxContext());
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContext() {
        return this.withNewSeLinuxContextLike(this.getSeLinuxContext() != null ? this.getSeLinuxContext() : new SELinuxContextStrategyOptionsBuilder().build());
    }

    @Override
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContextLike(SELinuxContextStrategyOptions item) {
        return this.withNewSeLinuxContextLike(this.getSeLinuxContext() != null ? this.getSeLinuxContext() : item);
    }

    @Override
    public A addToSeccompProfiles(int index, String item) {
        this.seccompProfiles.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSeccompProfiles(int index, String item) {
        this.seccompProfiles.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSeccompProfiles(String ... items) {
        for (String item : items) {
            this.seccompProfiles.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSeccompProfiles(Collection<String> items) {
        for (String item : items) {
            this.seccompProfiles.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSeccompProfiles(String ... items) {
        for (String item : items) {
            this.seccompProfiles.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSeccompProfiles(Collection<String> items) {
        for (String item : items) {
            this.seccompProfiles.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSeccompProfiles() {
        return this.seccompProfiles;
    }

    @Override
    public String getSeccompProfile(int index) {
        return this.seccompProfiles.get(index);
    }

    @Override
    public String getFirstSeccompProfile() {
        return this.seccompProfiles.get(0);
    }

    @Override
    public String getLastSeccompProfile() {
        return this.seccompProfiles.get(this.seccompProfiles.size() - 1);
    }

    @Override
    public String getMatchingSeccompProfile(Predicate<String> predicate) {
        for (String item : this.seccompProfiles) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withSeccompProfiles(List<String> seccompProfiles) {
        this.seccompProfiles.clear();
        if (seccompProfiles != null) {
            for (String item : seccompProfiles) {
                this.addToSeccompProfiles(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSeccompProfiles(String ... seccompProfiles) {
        this.seccompProfiles.clear();
        if (seccompProfiles != null) {
            for (String item : seccompProfiles) {
                this.addToSeccompProfiles(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeccompProfiles() {
        return this.seccompProfiles != null && !this.seccompProfiles.isEmpty();
    }

    @Override
    @Deprecated
    public SupplementalGroupsStrategyOptions getSupplementalGroups() {
        return this.supplementalGroups != null ? this.supplementalGroups.build() : null;
    }

    @Override
    public SupplementalGroupsStrategyOptions buildSupplementalGroups() {
        return this.supplementalGroups != null ? this.supplementalGroups.build() : null;
    }

    @Override
    public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
        this._visitables.remove(this.supplementalGroups);
        if (supplementalGroups != null) {
            this.supplementalGroups = new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups);
            this._visitables.add(this.supplementalGroups);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSupplementalGroups() {
        return this.supplementalGroups != null;
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroups() {
        return new SupplementalGroupsNestedImpl();
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return new SupplementalGroupsNestedImpl(item);
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups());
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups() != null ? this.getSupplementalGroups() : new SupplementalGroupsStrategyOptionsBuilder().build());
    }

    @Override
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups() != null ? this.getSupplementalGroups() : item);
    }

    @Override
    public A addToUsers(int index, String item) {
        this.users.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUsers(int index, String item) {
        this.users.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUsers(String ... items) {
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUsers(Collection<String> items) {
        for (String item : items) {
            this.users.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsers(String ... items) {
        for (String item : items) {
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUsers(Collection<String> items) {
        for (String item : items) {
            this.users.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUsers() {
        return this.users;
    }

    @Override
    public String getUser(int index) {
        return this.users.get(index);
    }

    @Override
    public String getFirstUser() {
        return this.users.get(0);
    }

    @Override
    public String getLastUser() {
        return this.users.get(this.users.size() - 1);
    }

    @Override
    public String getMatchingUser(Predicate<String> predicate) {
        for (String item : this.users) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withUsers(List<String> users) {
        this.users.clear();
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withUsers(String ... users) {
        this.users.clear();
        if (users != null) {
            for (String item : users) {
                this.addToUsers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUsers() {
        return this.users != null && !this.users.isEmpty();
    }

    @Override
    public A addToVolumes(int index, String item) {
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, String item) {
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(String ... items) {
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<String> items) {
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(String ... items) {
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<String> items) {
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumes() {
        return this.volumes;
    }

    @Override
    public String getVolume(int index) {
        return this.volumes.get(index);
    }

    @Override
    public String getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public String getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public String getMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withVolumes(List<String> volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVolumes(String ... volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecurityContextConstraintsFluentImpl that = (SecurityContextConstraintsFluentImpl)o;
        if (this.allowHostDirVolumePlugin != null ? !this.allowHostDirVolumePlugin.equals(that.allowHostDirVolumePlugin) : that.allowHostDirVolumePlugin != null) {
            return false;
        }
        if (this.allowHostIPC != null ? !this.allowHostIPC.equals(that.allowHostIPC) : that.allowHostIPC != null) {
            return false;
        }
        if (this.allowHostNetwork != null ? !this.allowHostNetwork.equals(that.allowHostNetwork) : that.allowHostNetwork != null) {
            return false;
        }
        if (this.allowHostPID != null ? !this.allowHostPID.equals(that.allowHostPID) : that.allowHostPID != null) {
            return false;
        }
        if (this.allowHostPorts != null ? !this.allowHostPorts.equals(that.allowHostPorts) : that.allowHostPorts != null) {
            return false;
        }
        if (this.allowPrivilegedContainer != null ? !this.allowPrivilegedContainer.equals(that.allowPrivilegedContainer) : that.allowPrivilegedContainer != null) {
            return false;
        }
        if (this.allowedCapabilities != null ? !this.allowedCapabilities.equals(that.allowedCapabilities) : that.allowedCapabilities != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.defaultAddCapabilities != null ? !this.defaultAddCapabilities.equals(that.defaultAddCapabilities) : that.defaultAddCapabilities != null) {
            return false;
        }
        if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.readOnlyRootFilesystem != null ? !this.readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) : that.readOnlyRootFilesystem != null) {
            return false;
        }
        if (this.requiredDropCapabilities != null ? !this.requiredDropCapabilities.equals(that.requiredDropCapabilities) : that.requiredDropCapabilities != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxContext != null ? !this.seLinuxContext.equals(that.seLinuxContext) : that.seLinuxContext != null) {
            return false;
        }
        if (this.seccompProfiles != null ? !this.seccompProfiles.equals(that.seccompProfiles) : that.seccompProfiles != null) {
            return false;
        }
        if (this.supplementalGroups != null ? !this.supplementalGroups.equals(that.supplementalGroups) : that.supplementalGroups != null) {
            return false;
        }
        if (this.users != null ? !this.users.equals(that.users) : that.users != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public class SupplementalGroupsNestedImpl<N>
    extends SupplementalGroupsStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.SupplementalGroupsNested<N>>
    implements SecurityContextConstraintsFluent.SupplementalGroupsNested<N>,
    Nested<N> {
        private final SupplementalGroupsStrategyOptionsBuilder builder;

        SupplementalGroupsNestedImpl(SupplementalGroupsStrategyOptions item) {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
        }

        SupplementalGroupsNestedImpl() {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withSupplementalGroups(this.builder.build());
        }

        @Override
        public N endSupplementalGroups() {
            return this.and();
        }
    }

    public class SeLinuxContextNestedImpl<N>
    extends SELinuxContextStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.SeLinuxContextNested<N>>
    implements SecurityContextConstraintsFluent.SeLinuxContextNested<N>,
    Nested<N> {
        private final SELinuxContextStrategyOptionsBuilder builder;

        SeLinuxContextNestedImpl(SELinuxContextStrategyOptions item) {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
        }

        SeLinuxContextNestedImpl() {
            this.builder = new SELinuxContextStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withSeLinuxContext(this.builder.build());
        }

        @Override
        public N endSeLinuxContext() {
            return this.and();
        }
    }

    public class RunAsUserNestedImpl<N>
    extends RunAsUserStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.RunAsUserNested<N>>
    implements SecurityContextConstraintsFluent.RunAsUserNested<N>,
    Nested<N> {
        private final RunAsUserStrategyOptionsBuilder builder;

        RunAsUserNestedImpl(RunAsUserStrategyOptions item) {
            this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
        }

        RunAsUserNestedImpl() {
            this.builder = new RunAsUserStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withRunAsUser(this.builder.build());
        }

        @Override
        public N endRunAsUser() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<SecurityContextConstraintsFluent.MetadataNested<N>>
    implements SecurityContextConstraintsFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class FsGroupNestedImpl<N>
    extends FSGroupStrategyOptionsFluentImpl<SecurityContextConstraintsFluent.FsGroupNested<N>>
    implements SecurityContextConstraintsFluent.FsGroupNested<N>,
    Nested<N> {
        private final FSGroupStrategyOptionsBuilder builder;

        FsGroupNestedImpl(FSGroupStrategyOptions item) {
            this.builder = new FSGroupStrategyOptionsBuilder(this, item);
        }

        FsGroupNestedImpl() {
            this.builder = new FSGroupStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecurityContextConstraintsFluentImpl.this.withFsGroup(this.builder.build());
        }

        @Override
        public N endFsGroup() {
            return this.and();
        }
    }
}

