/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_4;

import io.fabric8.kubernetes.api.builder.v2_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_4.VisitableBuilder;
import io.fabric8.openshift.api.model.v2_4.Policy;
import io.fabric8.openshift.api.model.v2_4.PolicyFluent;
import io.fabric8.openshift.api.model.v2_4.PolicyFluentImpl;

public class PolicyBuilder
extends PolicyFluentImpl<PolicyBuilder>
implements VisitableBuilder<Policy, PolicyBuilder> {
    PolicyFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyBuilder() {
        this(true);
    }

    public PolicyBuilder(Boolean validationEnabled) {
        this(new Policy(), validationEnabled);
    }

    public PolicyBuilder(PolicyFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PolicyBuilder(PolicyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Policy(), validationEnabled);
    }

    public PolicyBuilder(PolicyFluent<?> fluent, Policy instance) {
        this(fluent, instance, true);
    }

    public PolicyBuilder(PolicyFluent<?> fluent, Policy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withLastModified(instance.getLastModified());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRoles(instance.getRoles());
        this.validationEnabled = validationEnabled;
    }

    public PolicyBuilder(Policy instance) {
        this(instance, (Boolean)true);
    }

    public PolicyBuilder(Policy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLastModified(instance.getLastModified());
        this.withMetadata(instance.getMetadata());
        this.withRoles(instance.getRoles());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Policy build() {
        Policy buildable = new Policy(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getLastModified(), this.fluent.getMetadata(), this.fluent.getRoles());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyBuilder that = (PolicyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

