/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_4;

import io.fabric8.kubernetes.api.builder.v2_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_4.Nested;
import io.fabric8.kubernetes.api.builder.v2_4.Predicate;
import io.fabric8.openshift.api.model.v2_4.ImageStreamSpec;
import io.fabric8.openshift.api.model.v2_4.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.v2_4.TagReference;
import io.fabric8.openshift.api.model.v2_4.TagReferenceBuilder;
import io.fabric8.openshift.api.model.v2_4.TagReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImageStreamSpecFluentImpl<A extends ImageStreamSpecFluent<A>>
extends BaseFluent<A>
implements ImageStreamSpecFluent<A> {
    private String dockerImageRepository;
    private List<TagReferenceBuilder> tags = new ArrayList<TagReferenceBuilder>();

    public ImageStreamSpecFluentImpl() {
    }

    public ImageStreamSpecFluentImpl(ImageStreamSpec instance) {
        this.withDockerImageRepository(instance.getDockerImageRepository());
        this.withTags(instance.getTags());
    }

    @Override
    public String getDockerImageRepository() {
        return this.dockerImageRepository;
    }

    @Override
    public A withDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
        return (A)this;
    }

    @Override
    public Boolean hasDockerImageRepository() {
        return this.dockerImageRepository != null;
    }

    @Override
    public A addToTags(int index, TagReference item) {
        TagReferenceBuilder builder = new TagReferenceBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.tags.add(index >= 0 ? index : this.tags.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTags(int index, TagReference item) {
        TagReferenceBuilder builder = new TagReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.tags.size()) {
            this.tags.add(builder);
        } else {
            this.tags.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTags(TagReference ... items) {
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTags(Collection<TagReference> items) {
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.add(builder);
            this.tags.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(TagReference ... items) {
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.remove(builder);
            this.tags.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTags(Collection<TagReference> items) {
        for (TagReference item : items) {
            TagReferenceBuilder builder = new TagReferenceBuilder(item);
            this._visitables.remove(builder);
            this.tags.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TagReference> getTags() {
        return ImageStreamSpecFluentImpl.build(this.tags);
    }

    @Override
    public List<TagReference> buildTags() {
        return ImageStreamSpecFluentImpl.build(this.tags);
    }

    @Override
    public TagReference buildTag(int index) {
        return this.tags.get(index).build();
    }

    @Override
    public TagReference buildFirstTag() {
        return this.tags.get(0).build();
    }

    @Override
    public TagReference buildLastTag() {
        return this.tags.get(this.tags.size() - 1).build();
    }

    @Override
    public TagReference buildMatchingTag(Predicate<TagReferenceBuilder> predicate) {
        for (TagReferenceBuilder item : this.tags) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withTags(List<TagReference> tags) {
        this._visitables.removeAll(this.tags);
        this.tags.clear();
        if (tags != null) {
            for (TagReference item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTags(TagReference ... tags) {
        this.tags.clear();
        if (tags != null) {
            for (TagReference item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> addNewTag() {
        return new TagsNestedImpl();
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> addNewTagLike(TagReference item) {
        return new TagsNestedImpl(-1, item);
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> setNewTagLike(int index, TagReference item) {
        return new TagsNestedImpl(index, item);
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> editTag(int index) {
        if (this.tags.size() <= index) {
            throw new RuntimeException("Can't edit tags. Index exceeds size.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> editFirstTag() {
        if (this.tags.size() == 0) {
            throw new RuntimeException("Can't edit first tags. The list is empty.");
        }
        return this.setNewTagLike(0, this.buildTag(0));
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> editLastTag() {
        int index = this.tags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tags. The list is empty.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    @Override
    public ImageStreamSpecFluent.TagsNested<A> editMatchingTag(Predicate<TagReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tags.size(); ++i) {
            if (!predicate.apply(this.tags.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tags. No match found.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamSpecFluentImpl that = (ImageStreamSpecFluentImpl)o;
        if (this.dockerImageRepository != null ? !this.dockerImageRepository.equals(that.dockerImageRepository) : that.dockerImageRepository != null) {
            return false;
        }
        return !(this.tags != null ? !this.tags.equals(that.tags) : that.tags != null);
    }

    public class TagsNestedImpl<N>
    extends TagReferenceFluentImpl<ImageStreamSpecFluent.TagsNested<N>>
    implements ImageStreamSpecFluent.TagsNested<N>,
    Nested<N> {
        private final TagReferenceBuilder builder;
        private final int index;

        TagsNestedImpl(int index, TagReference item) {
            this.index = index;
            this.builder = new TagReferenceBuilder(this, item);
        }

        TagsNestedImpl() {
            this.index = -1;
            this.builder = new TagReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamSpecFluentImpl.this.setToTags(this.index, this.builder.build());
        }

        @Override
        public N endTag() {
            return this.and();
        }
    }
}

