/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_4;

import io.fabric8.kubernetes.api.builder.v2_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_4.Nested;
import io.fabric8.kubernetes.api.model.v2_4.ObjectReference;
import io.fabric8.kubernetes.api.model.v2_4.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v2_4.BuildStatus;
import io.fabric8.openshift.api.model.v2_4.BuildStatusFluent;
import io.fabric8.openshift.api.model.v2_4.BuildStatusOutput;
import io.fabric8.openshift.api.model.v2_4.BuildStatusOutputBuilder;
import io.fabric8.openshift.api.model.v2_4.BuildStatusOutputFluentImpl;

public class BuildStatusFluentImpl<A extends BuildStatusFluent<A>>
extends BaseFluent<A>
implements BuildStatusFluent<A> {
    private Boolean cancelled;
    private String completionTimestamp;
    private ObjectReferenceBuilder config;
    private Long duration;
    private String message;
    private BuildStatusOutputBuilder output;
    private String outputDockerImageReference;
    private String phase;
    private String reason;
    private String startTimestamp;

    public BuildStatusFluentImpl() {
    }

    public BuildStatusFluentImpl(BuildStatus instance) {
        this.withCancelled(instance.getCancelled());
        this.withCompletionTimestamp(instance.getCompletionTimestamp());
        this.withConfig(instance.getConfig());
        this.withDuration(instance.getDuration());
        this.withMessage(instance.getMessage());
        this.withOutput(instance.getOutput());
        this.withOutputDockerImageReference(instance.getOutputDockerImageReference());
        this.withPhase(instance.getPhase());
        this.withReason(instance.getReason());
        this.withStartTimestamp(instance.getStartTimestamp());
    }

    @Override
    public Boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public A withCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
        return (A)this;
    }

    @Override
    public Boolean hasCancelled() {
        return this.cancelled != null;
    }

    @Override
    public String getCompletionTimestamp() {
        return this.completionTimestamp;
    }

    @Override
    public A withCompletionTimestamp(String completionTimestamp) {
        this.completionTimestamp = completionTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionTimestamp() {
        return this.completionTimestamp != null;
    }

    @Override
    @Deprecated
    public ObjectReference getConfig() {
        return this.config != null ? this.config.build() : null;
    }

    @Override
    public ObjectReference buildConfig() {
        return this.config != null ? this.config.build() : null;
    }

    @Override
    public A withConfig(ObjectReference config) {
        this._visitables.remove(this.config);
        if (config != null) {
            this.config = new ObjectReferenceBuilder(config);
            this._visitables.add(this.config);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfig() {
        return this.config != null;
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> withNewConfig() {
        return new ConfigNestedImpl();
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> withNewConfigLike(ObjectReference item) {
        return new ConfigNestedImpl(item);
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> editConfig() {
        return this.withNewConfigLike(this.getConfig());
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> editOrNewConfig() {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BuildStatusFluent.ConfigNested<A> editOrNewConfigLike(ObjectReference item) {
        return this.withNewConfigLike(this.getConfig() != null ? this.getConfig() : item);
    }

    @Override
    public Long getDuration() {
        return this.duration;
    }

    @Override
    public A withDuration(Long duration) {
        this.duration = duration;
        return (A)this;
    }

    @Override
    public Boolean hasDuration() {
        return this.duration != null;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    @Deprecated
    public BuildStatusOutput getOutput() {
        return this.output != null ? this.output.build() : null;
    }

    @Override
    public BuildStatusOutput buildOutput() {
        return this.output != null ? this.output.build() : null;
    }

    @Override
    public A withOutput(BuildStatusOutput output) {
        this._visitables.remove(this.output);
        if (output != null) {
            this.output = new BuildStatusOutputBuilder(output);
            this._visitables.add(this.output);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutput() {
        return this.output != null;
    }

    @Override
    public BuildStatusFluent.OutputNested<A> withNewOutput() {
        return new OutputNestedImpl();
    }

    @Override
    public BuildStatusFluent.OutputNested<A> withNewOutputLike(BuildStatusOutput item) {
        return new OutputNestedImpl(item);
    }

    @Override
    public BuildStatusFluent.OutputNested<A> editOutput() {
        return this.withNewOutputLike(this.getOutput());
    }

    @Override
    public BuildStatusFluent.OutputNested<A> editOrNewOutput() {
        return this.withNewOutputLike(this.getOutput() != null ? this.getOutput() : new BuildStatusOutputBuilder().build());
    }

    @Override
    public BuildStatusFluent.OutputNested<A> editOrNewOutputLike(BuildStatusOutput item) {
        return this.withNewOutputLike(this.getOutput() != null ? this.getOutput() : item);
    }

    @Override
    public String getOutputDockerImageReference() {
        return this.outputDockerImageReference;
    }

    @Override
    public A withOutputDockerImageReference(String outputDockerImageReference) {
        this.outputDockerImageReference = outputDockerImageReference;
        return (A)this;
    }

    @Override
    public Boolean hasOutputDockerImageReference() {
        return this.outputDockerImageReference != null;
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    public String getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public A withStartTimestamp(String startTimestamp) {
        this.startTimestamp = startTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasStartTimestamp() {
        return this.startTimestamp != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildStatusFluentImpl that = (BuildStatusFluentImpl)o;
        if (this.cancelled != null ? !this.cancelled.equals(that.cancelled) : that.cancelled != null) {
            return false;
        }
        if (this.completionTimestamp != null ? !this.completionTimestamp.equals(that.completionTimestamp) : that.completionTimestamp != null) {
            return false;
        }
        if (this.config != null ? !this.config.equals(that.config) : that.config != null) {
            return false;
        }
        if (this.duration != null ? !this.duration.equals(that.duration) : that.duration != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.outputDockerImageReference != null ? !this.outputDockerImageReference.equals(that.outputDockerImageReference) : that.outputDockerImageReference != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        return !(this.startTimestamp != null ? !this.startTimestamp.equals(that.startTimestamp) : that.startTimestamp != null);
    }

    public class OutputNestedImpl<N>
    extends BuildStatusOutputFluentImpl<BuildStatusFluent.OutputNested<N>>
    implements BuildStatusFluent.OutputNested<N>,
    Nested<N> {
        private final BuildStatusOutputBuilder builder;

        OutputNestedImpl(BuildStatusOutput item) {
            this.builder = new BuildStatusOutputBuilder(this, item);
        }

        OutputNestedImpl() {
            this.builder = new BuildStatusOutputBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluentImpl.this.withOutput(this.builder.build());
        }

        @Override
        public N endOutput() {
            return this.and();
        }
    }

    public class ConfigNestedImpl<N>
    extends ObjectReferenceFluentImpl<BuildStatusFluent.ConfigNested<N>>
    implements BuildStatusFluent.ConfigNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        ConfigNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ConfigNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildStatusFluentImpl.this.withConfig(this.builder.build());
        }

        @Override
        public N endConfig() {
            return this.and();
        }
    }
}

