/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_4;

import io.fabric8.kubernetes.api.builder.v2_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_4.VisitableBuilder;
import io.fabric8.openshift.api.model.v2_4.BuildSource;
import io.fabric8.openshift.api.model.v2_4.BuildSourceFluent;
import io.fabric8.openshift.api.model.v2_4.BuildSourceFluentImpl;

public class BuildSourceBuilder
extends BuildSourceFluentImpl<BuildSourceBuilder>
implements VisitableBuilder<BuildSource, BuildSourceBuilder> {
    BuildSourceFluent<?> fluent;
    Boolean validationEnabled;

    public BuildSourceBuilder() {
        this(true);
    }

    public BuildSourceBuilder(Boolean validationEnabled) {
        this(new BuildSource(), validationEnabled);
    }

    public BuildSourceBuilder(BuildSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildSourceBuilder(BuildSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildSource(), validationEnabled);
    }

    public BuildSourceBuilder(BuildSourceFluent<?> fluent, BuildSource instance) {
        this(fluent, instance, true);
    }

    public BuildSourceBuilder(BuildSourceFluent<?> fluent, BuildSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBinary(instance.getBinary());
        fluent.withContextDir(instance.getContextDir());
        fluent.withDockerfile(instance.getDockerfile());
        fluent.withGit(instance.getGit());
        fluent.withImages(instance.getImages());
        fluent.withSecrets(instance.getSecrets());
        fluent.withSourceSecret(instance.getSourceSecret());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public BuildSourceBuilder(BuildSource instance) {
        this(instance, (Boolean)true);
    }

    public BuildSourceBuilder(BuildSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBinary(instance.getBinary());
        this.withContextDir(instance.getContextDir());
        this.withDockerfile(instance.getDockerfile());
        this.withGit(instance.getGit());
        this.withImages(instance.getImages());
        this.withSecrets(instance.getSecrets());
        this.withSourceSecret(instance.getSourceSecret());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public BuildSource build() {
        BuildSource buildable = new BuildSource(this.fluent.getBinary(), this.fluent.getContextDir(), this.fluent.getDockerfile(), this.fluent.getGit(), this.fluent.getImages(), this.fluent.getSecrets(), this.fluent.getSourceSecret(), this.fluent.getType());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildSourceBuilder that = (BuildSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

