/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v2_4.utils;

import io.fabric8.kubernetes.clnt.v2_4.KubernetesClientException;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    private static final String ALL_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789";

    public static <T> T checkNotNull(T ref, String message) {
        if (ref == null) {
            throw new NullPointerException(message);
        }
        return ref;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotNullOrEmpty(String str) {
        return !Utils.isNullOrEmpty(str);
    }

    public static String getProperty(Map<String, Object> properties, String propertyName, String defaultValue) {
        String answer = (String)properties.get(propertyName);
        if (!Utils.isNullOrEmpty(answer)) {
            return answer;
        }
        return Utils.getSystemPropertyOrEnvVar(propertyName, defaultValue);
    }

    public static String getProperty(Map<String, Object> properties, String propertyName) {
        return Utils.getProperty(properties, propertyName, null);
    }

    public static String getSystemPropertyOrEnvVar(String systemPropertyName, String envVarName, String defaultValue) {
        String answer = System.getProperty(systemPropertyName);
        if (Utils.isNotNullOrEmpty(answer)) {
            return answer;
        }
        answer = System.getenv(envVarName);
        if (Utils.isNotNullOrEmpty(answer)) {
            return answer;
        }
        return defaultValue;
    }

    public static String convertSystemPropertyNameToEnvVar(String systemPropertyName) {
        return systemPropertyName.toUpperCase().replaceAll("[.-]", "_");
    }

    public static String getEnvVar(String envVarName, String defaultValue) {
        String answer = System.getenv(envVarName);
        return Utils.isNotNullOrEmpty(answer) ? answer : defaultValue;
    }

    public static String getSystemPropertyOrEnvVar(String systemPropertyName, String defaultValue) {
        return Utils.getSystemPropertyOrEnvVar(systemPropertyName, Utils.convertSystemPropertyNameToEnvVar(systemPropertyName), defaultValue);
    }

    public static String getSystemPropertyOrEnvVar(String systemPropertyName) {
        return Utils.getSystemPropertyOrEnvVar(systemPropertyName, (String)null);
    }

    public static Boolean getSystemPropertyOrEnvVar(String systemPropertyName, Boolean defaultValue) {
        String result = Utils.getSystemPropertyOrEnvVar(systemPropertyName, defaultValue.toString());
        return Boolean.parseBoolean(result);
    }

    public static int getSystemPropertyOrEnvVar(String systemPropertyName, int defaultValue) {
        String result = Utils.getSystemPropertyOrEnvVar(systemPropertyName, new Integer(defaultValue).toString());
        return Integer.parseInt(result);
    }

    public static String join(Object[] array) {
        return Utils.join(array, ',');
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static boolean waitUntilReady(BlockingQueue<Object> queue, long amount, TimeUnit timeUnit) {
        try {
            Object obj = queue.poll(amount, timeUnit);
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof Throwable) {
                throw (Throwable)obj;
            }
            return false;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(t);
        }
    }

    public static boolean shutdownExecutorService(ExecutorService executorService) {
        if (executorService == null) {
            return false;
        }
        if (!executorService.isShutdown()) {
            executorService.shutdown();
        }
        try {
            List<Runnable> tasks;
            if (executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                return true;
            }
            if (!executorService.isTerminated()) {
                executorService.shutdownNow();
            }
            if (executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                return true;
            }
            if (LOGGER.isDebugEnabled() && !(tasks = executorService.shutdownNow()).isEmpty()) {
                LOGGER.debug("ExecutorService was not cleanly shutdown, after waiting for 10 seconds. Number of remaining tasks:" + tasks.size());
            }
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
        return false;
    }

    public static void closeQuietly(Iterable<Closeable> closeables) {
        for (Closeable c : closeables) {
            try {
                if (c instanceof Flushable) {
                    ((Flushable)((Object)c)).flush();
                }
                if (c == null) continue;
                c.close();
            }
            catch (IOException e) {
                LOGGER.debug("Error closing:" + c);
            }
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        Utils.closeQuietly(Arrays.asList(closeables));
    }

    public static String replaceAllWithoutRegex(String text, String from, String to) {
        if (text == null) {
            return null;
        }
        int idx = 0;
        while ((idx = text.indexOf(from, idx)) >= 0) {
            text = text.substring(0, idx) + to + text.substring(idx + from.length());
            idx += to.length();
        }
        return text;
    }

    public static String randomString(int length) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(ALL_CHARS.length());
            sb.append(ALL_CHARS.charAt(index));
        }
        return sb.toString();
    }

    public static String randomString(String prefix, int length) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length - prefix.length(); ++i) {
            int index = random.nextInt(ALL_CHARS.length());
            sb.append(ALL_CHARS.charAt(index));
        }
        return sb.toString();
    }
}

