/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_4;

import io.fabric8.kubernetes.api.builder.v2_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_4.SELinuxOptions;
import io.fabric8.kubernetes.api.model.v2_4.SELinuxOptionsFluent;
import io.fabric8.kubernetes.api.model.v2_4.SELinuxOptionsFluentImpl;

public class SELinuxOptionsBuilder
extends SELinuxOptionsFluentImpl<SELinuxOptionsBuilder>
implements VisitableBuilder<SELinuxOptions, SELinuxOptionsBuilder> {
    SELinuxOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public SELinuxOptionsBuilder() {
        this(true);
    }

    public SELinuxOptionsBuilder(Boolean validationEnabled) {
        this(new SELinuxOptions(), validationEnabled);
    }

    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SELinuxOptions(), validationEnabled);
    }

    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent, SELinuxOptions instance) {
        this(fluent, instance, true);
    }

    public SELinuxOptionsBuilder(SELinuxOptionsFluent<?> fluent, SELinuxOptions instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withLevel(instance.getLevel());
        fluent.withRole(instance.getRole());
        fluent.withType(instance.getType());
        fluent.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    public SELinuxOptionsBuilder(SELinuxOptions instance) {
        this(instance, (Boolean)true);
    }

    public SELinuxOptionsBuilder(SELinuxOptions instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withLevel(instance.getLevel());
        this.withRole(instance.getRole());
        this.withType(instance.getType());
        this.withUser(instance.getUser());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SELinuxOptions build() {
        SELinuxOptions buildable = new SELinuxOptions(this.fluent.getLevel(), this.fluent.getRole(), this.fluent.getType(), this.fluent.getUser());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SELinuxOptionsBuilder that = (SELinuxOptionsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

