/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_4;

import io.fabric8.kubernetes.api.builder.v2_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_4.Nested;
import io.fabric8.kubernetes.api.builder.v2_4.Predicate;
import io.fabric8.kubernetes.api.model.v2_4.AWSElasticBlockStoreVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.AWSElasticBlockStoreVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.AWSElasticBlockStoreVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.AzureDiskVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.AzureDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.AzureDiskVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.AzureFileVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.AzureFileVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.AzureFileVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.CephFSVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.CephFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.CephFSVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.CinderVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.CinderVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.CinderVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.FCVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.FCVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.FCVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.FlexVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.FlexVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.FlexVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.FlockerVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.FlockerVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.FlockerVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.GCEPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.GCEPersistentDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.GCEPersistentDiskVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.GlusterfsVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.GlusterfsVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.HostPathVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.HostPathVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.ISCSIVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.ISCSIVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.NFSVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.NFSVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.NFSVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.ObjectReference;
import io.fabric8.kubernetes.api.model.v2_4.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.PersistentVolumeSpec;
import io.fabric8.kubernetes.api.model.v2_4.PersistentVolumeSpecFluent;
import io.fabric8.kubernetes.api.model.v2_4.PhotonPersistentDiskVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.PhotonPersistentDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.PhotonPersistentDiskVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.Quantity;
import io.fabric8.kubernetes.api.model.v2_4.QuobyteVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.QuobyteVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.QuobyteVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.RBDVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.RBDVolumeSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.VsphereVirtualDiskVolumeSource;
import io.fabric8.kubernetes.api.model.v2_4.VsphereVirtualDiskVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.v2_4.VsphereVirtualDiskVolumeSourceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PersistentVolumeSpecFluentImpl<A extends PersistentVolumeSpecFluent<A>>
extends BaseFluent<A>
implements PersistentVolumeSpecFluent<A> {
    private List<String> accessModes = new ArrayList<String>();
    private AWSElasticBlockStoreVolumeSourceBuilder awsElasticBlockStore;
    private AzureDiskVolumeSourceBuilder azureDisk;
    private AzureFileVolumeSourceBuilder azureFile;
    private Map<String, Quantity> capacity = new LinkedHashMap<String, Quantity>();
    private CephFSVolumeSourceBuilder cephfs;
    private CinderVolumeSourceBuilder cinder;
    private ObjectReferenceBuilder claimRef;
    private FCVolumeSourceBuilder fc;
    private FlexVolumeSourceBuilder flexVolume;
    private FlockerVolumeSourceBuilder flocker;
    private GCEPersistentDiskVolumeSourceBuilder gcePersistentDisk;
    private GlusterfsVolumeSourceBuilder glusterfs;
    private HostPathVolumeSourceBuilder hostPath;
    private ISCSIVolumeSourceBuilder iscsi;
    private NFSVolumeSourceBuilder nfs;
    private String persistentVolumeReclaimPolicy;
    private PhotonPersistentDiskVolumeSourceBuilder photonPersistentDisk;
    private QuobyteVolumeSourceBuilder quobyte;
    private RBDVolumeSourceBuilder rbd;
    private VsphereVirtualDiskVolumeSourceBuilder vsphereVolume;

    public PersistentVolumeSpecFluentImpl() {
    }

    public PersistentVolumeSpecFluentImpl(PersistentVolumeSpec instance) {
        this.withAccessModes(instance.getAccessModes());
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withAzureDisk(instance.getAzureDisk());
        this.withAzureFile(instance.getAzureFile());
        this.withCapacity(instance.getCapacity());
        this.withCephfs(instance.getCephfs());
        this.withCinder(instance.getCinder());
        this.withClaimRef(instance.getClaimRef());
        this.withFc(instance.getFc());
        this.withFlexVolume(instance.getFlexVolume());
        this.withFlocker(instance.getFlocker());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withIscsi(instance.getIscsi());
        this.withNfs(instance.getNfs());
        this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy());
        this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
        this.withQuobyte(instance.getQuobyte());
        this.withRbd(instance.getRbd());
        this.withVsphereVolume(instance.getVsphereVolume());
    }

    @Override
    public A addToAccessModes(int index, String item) {
        this.accessModes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAccessModes(int index, String item) {
        this.accessModes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAccessModes(Collection<String> items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAccessModes(Collection<String> items) {
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    @Override
    public String getAccessMode(int index) {
        return this.accessModes.get(index);
    }

    @Override
    public String getFirstAccessMode() {
        return this.accessModes.get(0);
    }

    @Override
    public String getLastAccessMode() {
        return this.accessModes.get(this.accessModes.size() - 1);
    }

    @Override
    public String getMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withAccessModes(List<String> accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAccessModes(String ... accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAccessModes() {
        return this.accessModes != null && !this.accessModes.isEmpty();
    }

    @Override
    @Deprecated
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
        return this.awsElasticBlockStore != null ? this.awsElasticBlockStore.build() : null;
    }

    @Override
    public AWSElasticBlockStoreVolumeSource buildAwsElasticBlockStore() {
        return this.awsElasticBlockStore != null ? this.awsElasticBlockStore.build() : null;
    }

    @Override
    public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
        this._visitables.remove(this.awsElasticBlockStore);
        if (awsElasticBlockStore != null) {
            this.awsElasticBlockStore = new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore);
            this._visitables.add(this.awsElasticBlockStore);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAwsElasticBlockStore() {
        return this.awsElasticBlockStore != null;
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore() {
        return new AwsElasticBlockStoreNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
        return new AwsElasticBlockStoreNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore() {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore());
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStore() {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore() != null ? this.getAwsElasticBlockStore() : new AWSElasticBlockStoreVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
        return this.withNewAwsElasticBlockStoreLike(this.getAwsElasticBlockStore() != null ? this.getAwsElasticBlockStore() : item);
    }

    @Override
    public A withNewAwsElasticBlockStore(String fsType, Integer partition, Boolean readOnly, String volumeID) {
        return this.withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    @Override
    @Deprecated
    public AzureDiskVolumeSource getAzureDisk() {
        return this.azureDisk != null ? this.azureDisk.build() : null;
    }

    @Override
    public AzureDiskVolumeSource buildAzureDisk() {
        return this.azureDisk != null ? this.azureDisk.build() : null;
    }

    @Override
    public A withAzureDisk(AzureDiskVolumeSource azureDisk) {
        this._visitables.remove(this.azureDisk);
        if (azureDisk != null) {
            this.azureDisk = new AzureDiskVolumeSourceBuilder(azureDisk);
            this._visitables.add(this.azureDisk);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAzureDisk() {
        return this.azureDisk != null;
    }

    @Override
    public PersistentVolumeSpecFluent.AzureDiskNested<A> withNewAzureDisk() {
        return new AzureDiskNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.AzureDiskNested<A> withNewAzureDiskLike(AzureDiskVolumeSource item) {
        return new AzureDiskNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.AzureDiskNested<A> editAzureDisk() {
        return this.withNewAzureDiskLike(this.getAzureDisk());
    }

    @Override
    public PersistentVolumeSpecFluent.AzureDiskNested<A> editOrNewAzureDisk() {
        return this.withNewAzureDiskLike(this.getAzureDisk() != null ? this.getAzureDisk() : new AzureDiskVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.AzureDiskNested<A> editOrNewAzureDiskLike(AzureDiskVolumeSource item) {
        return this.withNewAzureDiskLike(this.getAzureDisk() != null ? this.getAzureDisk() : item);
    }

    @Override
    public A withNewAzureDisk(String cachingMode, String diskName, String diskURI, String fsType, Boolean readOnly) {
        return this.withAzureDisk(new AzureDiskVolumeSource(cachingMode, diskName, diskURI, fsType, readOnly));
    }

    @Override
    @Deprecated
    public AzureFileVolumeSource getAzureFile() {
        return this.azureFile != null ? this.azureFile.build() : null;
    }

    @Override
    public AzureFileVolumeSource buildAzureFile() {
        return this.azureFile != null ? this.azureFile.build() : null;
    }

    @Override
    public A withAzureFile(AzureFileVolumeSource azureFile) {
        this._visitables.remove(this.azureFile);
        if (azureFile != null) {
            this.azureFile = new AzureFileVolumeSourceBuilder(azureFile);
            this._visitables.add(this.azureFile);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAzureFile() {
        return this.azureFile != null;
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFile() {
        return new AzureFileNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item) {
        return new AzureFileNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> editAzureFile() {
        return this.withNewAzureFileLike(this.getAzureFile());
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> editOrNewAzureFile() {
        return this.withNewAzureFileLike(this.getAzureFile() != null ? this.getAzureFile() : new AzureFileVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.AzureFileNested<A> editOrNewAzureFileLike(AzureFileVolumeSource item) {
        return this.withNewAzureFileLike(this.getAzureFile() != null ? this.getAzureFile() : item);
    }

    @Override
    public A withNewAzureFile(Boolean readOnly, String secretName, String shareName) {
        return this.withAzureFile(new AzureFileVolumeSource(readOnly, secretName, shareName));
    }

    @Override
    public A addToCapacity(String key, Quantity value) {
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToCapacity(Map<String, Quantity> map) {
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(String key) {
        if (key != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    @Override
    public A withCapacity(Map<String, Quantity> capacity) {
        this.capacity.clear();
        if (capacity != null) {
            this.capacity.putAll(capacity);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCapacity() {
        return this.capacity != null;
    }

    @Override
    @Deprecated
    public CephFSVolumeSource getCephfs() {
        return this.cephfs != null ? this.cephfs.build() : null;
    }

    @Override
    public CephFSVolumeSource buildCephfs() {
        return this.cephfs != null ? this.cephfs.build() : null;
    }

    @Override
    public A withCephfs(CephFSVolumeSource cephfs) {
        this._visitables.remove(this.cephfs);
        if (cephfs != null) {
            this.cephfs = new CephFSVolumeSourceBuilder(cephfs);
            this._visitables.add(this.cephfs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCephfs() {
        return this.cephfs != null;
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfs() {
        return new CephfsNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item) {
        return new CephfsNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> editCephfs() {
        return this.withNewCephfsLike(this.getCephfs());
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> editOrNewCephfs() {
        return this.withNewCephfsLike(this.getCephfs() != null ? this.getCephfs() : new CephFSVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.CephfsNested<A> editOrNewCephfsLike(CephFSVolumeSource item) {
        return this.withNewCephfsLike(this.getCephfs() != null ? this.getCephfs() : item);
    }

    @Override
    @Deprecated
    public CinderVolumeSource getCinder() {
        return this.cinder != null ? this.cinder.build() : null;
    }

    @Override
    public CinderVolumeSource buildCinder() {
        return this.cinder != null ? this.cinder.build() : null;
    }

    @Override
    public A withCinder(CinderVolumeSource cinder) {
        this._visitables.remove(this.cinder);
        if (cinder != null) {
            this.cinder = new CinderVolumeSourceBuilder(cinder);
            this._visitables.add(this.cinder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCinder() {
        return this.cinder != null;
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinder() {
        return new CinderNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinderLike(CinderVolumeSource item) {
        return new CinderNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> editCinder() {
        return this.withNewCinderLike(this.getCinder());
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> editOrNewCinder() {
        return this.withNewCinderLike(this.getCinder() != null ? this.getCinder() : new CinderVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.CinderNested<A> editOrNewCinderLike(CinderVolumeSource item) {
        return this.withNewCinderLike(this.getCinder() != null ? this.getCinder() : item);
    }

    @Override
    public A withNewCinder(String fsType, Boolean readOnly, String volumeID) {
        return this.withCinder(new CinderVolumeSource(fsType, readOnly, volumeID));
    }

    @Override
    @Deprecated
    public ObjectReference getClaimRef() {
        return this.claimRef != null ? this.claimRef.build() : null;
    }

    @Override
    public ObjectReference buildClaimRef() {
        return this.claimRef != null ? this.claimRef.build() : null;
    }

    @Override
    public A withClaimRef(ObjectReference claimRef) {
        this._visitables.remove(this.claimRef);
        if (claimRef != null) {
            this.claimRef = new ObjectReferenceBuilder(claimRef);
            this._visitables.add(this.claimRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClaimRef() {
        return this.claimRef != null;
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRef() {
        return new ClaimRefNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRefLike(ObjectReference item) {
        return new ClaimRefNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editClaimRef() {
        return this.withNewClaimRefLike(this.getClaimRef());
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editOrNewClaimRef() {
        return this.withNewClaimRefLike(this.getClaimRef() != null ? this.getClaimRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editOrNewClaimRefLike(ObjectReference item) {
        return this.withNewClaimRefLike(this.getClaimRef() != null ? this.getClaimRef() : item);
    }

    @Override
    @Deprecated
    public FCVolumeSource getFc() {
        return this.fc != null ? this.fc.build() : null;
    }

    @Override
    public FCVolumeSource buildFc() {
        return this.fc != null ? this.fc.build() : null;
    }

    @Override
    public A withFc(FCVolumeSource fc) {
        this._visitables.remove(this.fc);
        if (fc != null) {
            this.fc = new FCVolumeSourceBuilder(fc);
            this._visitables.add(this.fc);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFc() {
        return this.fc != null;
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> withNewFc() {
        return new FcNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> withNewFcLike(FCVolumeSource item) {
        return new FcNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> editFc() {
        return this.withNewFcLike(this.getFc());
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> editOrNewFc() {
        return this.withNewFcLike(this.getFc() != null ? this.getFc() : new FCVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.FcNested<A> editOrNewFcLike(FCVolumeSource item) {
        return this.withNewFcLike(this.getFc() != null ? this.getFc() : item);
    }

    @Override
    @Deprecated
    public FlexVolumeSource getFlexVolume() {
        return this.flexVolume != null ? this.flexVolume.build() : null;
    }

    @Override
    public FlexVolumeSource buildFlexVolume() {
        return this.flexVolume != null ? this.flexVolume.build() : null;
    }

    @Override
    public A withFlexVolume(FlexVolumeSource flexVolume) {
        this._visitables.remove(this.flexVolume);
        if (flexVolume != null) {
            this.flexVolume = new FlexVolumeSourceBuilder(flexVolume);
            this._visitables.add(this.flexVolume);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFlexVolume() {
        return this.flexVolume != null;
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolume() {
        return new FlexVolumeNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item) {
        return new FlexVolumeNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editFlexVolume() {
        return this.withNewFlexVolumeLike(this.getFlexVolume());
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editOrNewFlexVolume() {
        return this.withNewFlexVolumeLike(this.getFlexVolume() != null ? this.getFlexVolume() : new FlexVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editOrNewFlexVolumeLike(FlexVolumeSource item) {
        return this.withNewFlexVolumeLike(this.getFlexVolume() != null ? this.getFlexVolume() : item);
    }

    @Override
    @Deprecated
    public FlockerVolumeSource getFlocker() {
        return this.flocker != null ? this.flocker.build() : null;
    }

    @Override
    public FlockerVolumeSource buildFlocker() {
        return this.flocker != null ? this.flocker.build() : null;
    }

    @Override
    public A withFlocker(FlockerVolumeSource flocker) {
        this._visitables.remove(this.flocker);
        if (flocker != null) {
            this.flocker = new FlockerVolumeSourceBuilder(flocker);
            this._visitables.add(this.flocker);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFlocker() {
        return this.flocker != null;
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlocker() {
        return new FlockerNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item) {
        return new FlockerNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> editFlocker() {
        return this.withNewFlockerLike(this.getFlocker());
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> editOrNewFlocker() {
        return this.withNewFlockerLike(this.getFlocker() != null ? this.getFlocker() : new FlockerVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.FlockerNested<A> editOrNewFlockerLike(FlockerVolumeSource item) {
        return this.withNewFlockerLike(this.getFlocker() != null ? this.getFlocker() : item);
    }

    @Override
    public A withNewFlocker(String datasetName, String datasetUUID) {
        return this.withFlocker(new FlockerVolumeSource(datasetName, datasetUUID));
    }

    @Override
    @Deprecated
    public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
        return this.gcePersistentDisk != null ? this.gcePersistentDisk.build() : null;
    }

    @Override
    public GCEPersistentDiskVolumeSource buildGcePersistentDisk() {
        return this.gcePersistentDisk != null ? this.gcePersistentDisk.build() : null;
    }

    @Override
    public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
        this._visitables.remove(this.gcePersistentDisk);
        if (gcePersistentDisk != null) {
            this.gcePersistentDisk = new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk);
            this._visitables.add(this.gcePersistentDisk);
        }
        return (A)this;
    }

    @Override
    public Boolean hasGcePersistentDisk() {
        return this.gcePersistentDisk != null;
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk() {
        return new GcePersistentDiskNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
        return new GcePersistentDiskNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editGcePersistentDisk() {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk());
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDisk() {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk() != null ? this.getGcePersistentDisk() : new GCEPersistentDiskVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
        return this.withNewGcePersistentDiskLike(this.getGcePersistentDisk() != null ? this.getGcePersistentDisk() : item);
    }

    @Override
    public A withNewGcePersistentDisk(String fsType, Integer partition, String pdName, Boolean readOnly) {
        return this.withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    @Override
    @Deprecated
    public GlusterfsVolumeSource getGlusterfs() {
        return this.glusterfs != null ? this.glusterfs.build() : null;
    }

    @Override
    public GlusterfsVolumeSource buildGlusterfs() {
        return this.glusterfs != null ? this.glusterfs.build() : null;
    }

    @Override
    public A withGlusterfs(GlusterfsVolumeSource glusterfs) {
        this._visitables.remove(this.glusterfs);
        if (glusterfs != null) {
            this.glusterfs = new GlusterfsVolumeSourceBuilder(glusterfs);
            this._visitables.add(this.glusterfs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasGlusterfs() {
        return this.glusterfs != null;
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfs() {
        return new GlusterfsNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item) {
        return new GlusterfsNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editGlusterfs() {
        return this.withNewGlusterfsLike(this.getGlusterfs());
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editOrNewGlusterfs() {
        return this.withNewGlusterfsLike(this.getGlusterfs() != null ? this.getGlusterfs() : new GlusterfsVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editOrNewGlusterfsLike(GlusterfsVolumeSource item) {
        return this.withNewGlusterfsLike(this.getGlusterfs() != null ? this.getGlusterfs() : item);
    }

    @Override
    public A withNewGlusterfs(String endpoints, String path, Boolean readOnly) {
        return this.withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    @Override
    @Deprecated
    public HostPathVolumeSource getHostPath() {
        return this.hostPath != null ? this.hostPath.build() : null;
    }

    @Override
    public HostPathVolumeSource buildHostPath() {
        return this.hostPath != null ? this.hostPath.build() : null;
    }

    @Override
    public A withHostPath(HostPathVolumeSource hostPath) {
        this._visitables.remove(this.hostPath);
        if (hostPath != null) {
            this.hostPath = new HostPathVolumeSourceBuilder(hostPath);
            this._visitables.add(this.hostPath);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostPath() {
        return this.hostPath != null;
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPath() {
        return new HostPathNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item) {
        return new HostPathNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> editHostPath() {
        return this.withNewHostPathLike(this.getHostPath());
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> editOrNewHostPath() {
        return this.withNewHostPathLike(this.getHostPath() != null ? this.getHostPath() : new HostPathVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.HostPathNested<A> editOrNewHostPathLike(HostPathVolumeSource item) {
        return this.withNewHostPathLike(this.getHostPath() != null ? this.getHostPath() : item);
    }

    @Override
    public A withNewHostPath(String path) {
        return this.withHostPath(new HostPathVolumeSource(path));
    }

    @Override
    @Deprecated
    public ISCSIVolumeSource getIscsi() {
        return this.iscsi != null ? this.iscsi.build() : null;
    }

    @Override
    public ISCSIVolumeSource buildIscsi() {
        return this.iscsi != null ? this.iscsi.build() : null;
    }

    @Override
    public A withIscsi(ISCSIVolumeSource iscsi) {
        this._visitables.remove(this.iscsi);
        if (iscsi != null) {
            this.iscsi = new ISCSIVolumeSourceBuilder(iscsi);
            this._visitables.add(this.iscsi);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIscsi() {
        return this.iscsi != null;
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsi() {
        return new IscsiNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item) {
        return new IscsiNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> editIscsi() {
        return this.withNewIscsiLike(this.getIscsi());
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> editOrNewIscsi() {
        return this.withNewIscsiLike(this.getIscsi() != null ? this.getIscsi() : new ISCSIVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.IscsiNested<A> editOrNewIscsiLike(ISCSIVolumeSource item) {
        return this.withNewIscsiLike(this.getIscsi() != null ? this.getIscsi() : item);
    }

    @Override
    @Deprecated
    public NFSVolumeSource getNfs() {
        return this.nfs != null ? this.nfs.build() : null;
    }

    @Override
    public NFSVolumeSource buildNfs() {
        return this.nfs != null ? this.nfs.build() : null;
    }

    @Override
    public A withNfs(NFSVolumeSource nfs) {
        this._visitables.remove(this.nfs);
        if (nfs != null) {
            this.nfs = new NFSVolumeSourceBuilder(nfs);
            this._visitables.add(this.nfs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNfs() {
        return this.nfs != null;
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfs() {
        return new NfsNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfsLike(NFSVolumeSource item) {
        return new NfsNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> editNfs() {
        return this.withNewNfsLike(this.getNfs());
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> editOrNewNfs() {
        return this.withNewNfsLike(this.getNfs() != null ? this.getNfs() : new NFSVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.NfsNested<A> editOrNewNfsLike(NFSVolumeSource item) {
        return this.withNewNfsLike(this.getNfs() != null ? this.getNfs() : item);
    }

    @Override
    public A withNewNfs(String path, Boolean readOnly, String server) {
        return this.withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    @Override
    public String getPersistentVolumeReclaimPolicy() {
        return this.persistentVolumeReclaimPolicy;
    }

    @Override
    public A withPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy) {
        this.persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPersistentVolumeReclaimPolicy() {
        return this.persistentVolumeReclaimPolicy != null;
    }

    @Override
    @Deprecated
    public PhotonPersistentDiskVolumeSource getPhotonPersistentDisk() {
        return this.photonPersistentDisk != null ? this.photonPersistentDisk.build() : null;
    }

    @Override
    public PhotonPersistentDiskVolumeSource buildPhotonPersistentDisk() {
        return this.photonPersistentDisk != null ? this.photonPersistentDisk.build() : null;
    }

    @Override
    public A withPhotonPersistentDisk(PhotonPersistentDiskVolumeSource photonPersistentDisk) {
        this._visitables.remove(this.photonPersistentDisk);
        if (photonPersistentDisk != null) {
            this.photonPersistentDisk = new PhotonPersistentDiskVolumeSourceBuilder(photonPersistentDisk);
            this._visitables.add(this.photonPersistentDisk);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPhotonPersistentDisk() {
        return this.photonPersistentDisk != null;
    }

    @Override
    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> withNewPhotonPersistentDisk() {
        return new PhotonPersistentDiskNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> withNewPhotonPersistentDiskLike(PhotonPersistentDiskVolumeSource item) {
        return new PhotonPersistentDiskNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> editPhotonPersistentDisk() {
        return this.withNewPhotonPersistentDiskLike(this.getPhotonPersistentDisk());
    }

    @Override
    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDisk() {
        return this.withNewPhotonPersistentDiskLike(this.getPhotonPersistentDisk() != null ? this.getPhotonPersistentDisk() : new PhotonPersistentDiskVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDiskLike(PhotonPersistentDiskVolumeSource item) {
        return this.withNewPhotonPersistentDiskLike(this.getPhotonPersistentDisk() != null ? this.getPhotonPersistentDisk() : item);
    }

    @Override
    public A withNewPhotonPersistentDisk(String fsType, String pdID) {
        return this.withPhotonPersistentDisk(new PhotonPersistentDiskVolumeSource(fsType, pdID));
    }

    @Override
    @Deprecated
    public QuobyteVolumeSource getQuobyte() {
        return this.quobyte != null ? this.quobyte.build() : null;
    }

    @Override
    public QuobyteVolumeSource buildQuobyte() {
        return this.quobyte != null ? this.quobyte.build() : null;
    }

    @Override
    public A withQuobyte(QuobyteVolumeSource quobyte) {
        this._visitables.remove(this.quobyte);
        if (quobyte != null) {
            this.quobyte = new QuobyteVolumeSourceBuilder(quobyte);
            this._visitables.add(this.quobyte);
        }
        return (A)this;
    }

    @Override
    public Boolean hasQuobyte() {
        return this.quobyte != null;
    }

    @Override
    public PersistentVolumeSpecFluent.QuobyteNested<A> withNewQuobyte() {
        return new QuobyteNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.QuobyteNested<A> withNewQuobyteLike(QuobyteVolumeSource item) {
        return new QuobyteNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.QuobyteNested<A> editQuobyte() {
        return this.withNewQuobyteLike(this.getQuobyte());
    }

    @Override
    public PersistentVolumeSpecFluent.QuobyteNested<A> editOrNewQuobyte() {
        return this.withNewQuobyteLike(this.getQuobyte() != null ? this.getQuobyte() : new QuobyteVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.QuobyteNested<A> editOrNewQuobyteLike(QuobyteVolumeSource item) {
        return this.withNewQuobyteLike(this.getQuobyte() != null ? this.getQuobyte() : item);
    }

    @Override
    public A withNewQuobyte(String group, Boolean readOnly, String registry, String user, String volume) {
        return this.withQuobyte(new QuobyteVolumeSource(group, readOnly, registry, user, volume));
    }

    @Override
    @Deprecated
    public RBDVolumeSource getRbd() {
        return this.rbd != null ? this.rbd.build() : null;
    }

    @Override
    public RBDVolumeSource buildRbd() {
        return this.rbd != null ? this.rbd.build() : null;
    }

    @Override
    public A withRbd(RBDVolumeSource rbd) {
        this._visitables.remove(this.rbd);
        if (rbd != null) {
            this.rbd = new RBDVolumeSourceBuilder(rbd);
            this._visitables.add(this.rbd);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRbd() {
        return this.rbd != null;
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbd() {
        return new RbdNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbdLike(RBDVolumeSource item) {
        return new RbdNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> editRbd() {
        return this.withNewRbdLike(this.getRbd());
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> editOrNewRbd() {
        return this.withNewRbdLike(this.getRbd() != null ? this.getRbd() : new RBDVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.RbdNested<A> editOrNewRbdLike(RBDVolumeSource item) {
        return this.withNewRbdLike(this.getRbd() != null ? this.getRbd() : item);
    }

    @Override
    @Deprecated
    public VsphereVirtualDiskVolumeSource getVsphereVolume() {
        return this.vsphereVolume != null ? this.vsphereVolume.build() : null;
    }

    @Override
    public VsphereVirtualDiskVolumeSource buildVsphereVolume() {
        return this.vsphereVolume != null ? this.vsphereVolume.build() : null;
    }

    @Override
    public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume) {
        this._visitables.remove(this.vsphereVolume);
        if (vsphereVolume != null) {
            this.vsphereVolume = new VsphereVirtualDiskVolumeSourceBuilder(vsphereVolume);
            this._visitables.add(this.vsphereVolume);
        }
        return (A)this;
    }

    @Override
    public Boolean hasVsphereVolume() {
        return this.vsphereVolume != null;
    }

    @Override
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolume() {
        return new VsphereVolumeNestedImpl();
    }

    @Override
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item) {
        return new VsphereVolumeNestedImpl(item);
    }

    @Override
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editVsphereVolume() {
        return this.withNewVsphereVolumeLike(this.getVsphereVolume());
    }

    @Override
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editOrNewVsphereVolume() {
        return this.withNewVsphereVolumeLike(this.getVsphereVolume() != null ? this.getVsphereVolume() : new VsphereVirtualDiskVolumeSourceBuilder().build());
    }

    @Override
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editOrNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item) {
        return this.withNewVsphereVolumeLike(this.getVsphereVolume() != null ? this.getVsphereVolume() : item);
    }

    @Override
    public A withNewVsphereVolume(String fsType, String volumePath) {
        return this.withVsphereVolume(new VsphereVirtualDiskVolumeSource(fsType, volumePath));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PersistentVolumeSpecFluentImpl that = (PersistentVolumeSpecFluentImpl)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.awsElasticBlockStore != null ? !this.awsElasticBlockStore.equals(that.awsElasticBlockStore) : that.awsElasticBlockStore != null) {
            return false;
        }
        if (this.azureDisk != null ? !this.azureDisk.equals(that.azureDisk) : that.azureDisk != null) {
            return false;
        }
        if (this.azureFile != null ? !this.azureFile.equals(that.azureFile) : that.azureFile != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.cephfs != null ? !this.cephfs.equals(that.cephfs) : that.cephfs != null) {
            return false;
        }
        if (this.cinder != null ? !this.cinder.equals(that.cinder) : that.cinder != null) {
            return false;
        }
        if (this.claimRef != null ? !this.claimRef.equals(that.claimRef) : that.claimRef != null) {
            return false;
        }
        if (this.fc != null ? !this.fc.equals(that.fc) : that.fc != null) {
            return false;
        }
        if (this.flexVolume != null ? !this.flexVolume.equals(that.flexVolume) : that.flexVolume != null) {
            return false;
        }
        if (this.flocker != null ? !this.flocker.equals(that.flocker) : that.flocker != null) {
            return false;
        }
        if (this.gcePersistentDisk != null ? !this.gcePersistentDisk.equals(that.gcePersistentDisk) : that.gcePersistentDisk != null) {
            return false;
        }
        if (this.glusterfs != null ? !this.glusterfs.equals(that.glusterfs) : that.glusterfs != null) {
            return false;
        }
        if (this.hostPath != null ? !this.hostPath.equals(that.hostPath) : that.hostPath != null) {
            return false;
        }
        if (this.iscsi != null ? !this.iscsi.equals(that.iscsi) : that.iscsi != null) {
            return false;
        }
        if (this.nfs != null ? !this.nfs.equals(that.nfs) : that.nfs != null) {
            return false;
        }
        if (this.persistentVolumeReclaimPolicy != null ? !this.persistentVolumeReclaimPolicy.equals(that.persistentVolumeReclaimPolicy) : that.persistentVolumeReclaimPolicy != null) {
            return false;
        }
        if (this.photonPersistentDisk != null ? !this.photonPersistentDisk.equals(that.photonPersistentDisk) : that.photonPersistentDisk != null) {
            return false;
        }
        if (this.quobyte != null ? !this.quobyte.equals(that.quobyte) : that.quobyte != null) {
            return false;
        }
        if (this.rbd != null ? !this.rbd.equals(that.rbd) : that.rbd != null) {
            return false;
        }
        return !(this.vsphereVolume != null ? !this.vsphereVolume.equals(that.vsphereVolume) : that.vsphereVolume != null);
    }

    public class VsphereVolumeNestedImpl<N>
    extends VsphereVirtualDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.VsphereVolumeNested<N>>
    implements PersistentVolumeSpecFluent.VsphereVolumeNested<N>,
    Nested<N> {
        private final VsphereVirtualDiskVolumeSourceBuilder builder;

        VsphereVolumeNestedImpl(VsphereVirtualDiskVolumeSource item) {
            this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
        }

        VsphereVolumeNestedImpl() {
            this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withVsphereVolume(this.builder.build());
        }

        @Override
        public N endVsphereVolume() {
            return this.and();
        }
    }

    public class RbdNestedImpl<N>
    extends RBDVolumeSourceFluentImpl<PersistentVolumeSpecFluent.RbdNested<N>>
    implements PersistentVolumeSpecFluent.RbdNested<N>,
    Nested<N> {
        private final RBDVolumeSourceBuilder builder;

        RbdNestedImpl(RBDVolumeSource item) {
            this.builder = new RBDVolumeSourceBuilder(this, item);
        }

        RbdNestedImpl() {
            this.builder = new RBDVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withRbd(this.builder.build());
        }

        @Override
        public N endRbd() {
            return this.and();
        }
    }

    public class QuobyteNestedImpl<N>
    extends QuobyteVolumeSourceFluentImpl<PersistentVolumeSpecFluent.QuobyteNested<N>>
    implements PersistentVolumeSpecFluent.QuobyteNested<N>,
    Nested<N> {
        private final QuobyteVolumeSourceBuilder builder;

        QuobyteNestedImpl(QuobyteVolumeSource item) {
            this.builder = new QuobyteVolumeSourceBuilder(this, item);
        }

        QuobyteNestedImpl() {
            this.builder = new QuobyteVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withQuobyte(this.builder.build());
        }

        @Override
        public N endQuobyte() {
            return this.and();
        }
    }

    public class PhotonPersistentDiskNestedImpl<N>
    extends PhotonPersistentDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.PhotonPersistentDiskNested<N>>
    implements PersistentVolumeSpecFluent.PhotonPersistentDiskNested<N>,
    Nested<N> {
        private final PhotonPersistentDiskVolumeSourceBuilder builder;

        PhotonPersistentDiskNestedImpl(PhotonPersistentDiskVolumeSource item) {
            this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this, item);
        }

        PhotonPersistentDiskNestedImpl() {
            this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withPhotonPersistentDisk(this.builder.build());
        }

        @Override
        public N endPhotonPersistentDisk() {
            return this.and();
        }
    }

    public class NfsNestedImpl<N>
    extends NFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.NfsNested<N>>
    implements PersistentVolumeSpecFluent.NfsNested<N>,
    Nested<N> {
        private final NFSVolumeSourceBuilder builder;

        NfsNestedImpl(NFSVolumeSource item) {
            this.builder = new NFSVolumeSourceBuilder(this, item);
        }

        NfsNestedImpl() {
            this.builder = new NFSVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withNfs(this.builder.build());
        }

        @Override
        public N endNfs() {
            return this.and();
        }
    }

    public class IscsiNestedImpl<N>
    extends ISCSIVolumeSourceFluentImpl<PersistentVolumeSpecFluent.IscsiNested<N>>
    implements PersistentVolumeSpecFluent.IscsiNested<N>,
    Nested<N> {
        private final ISCSIVolumeSourceBuilder builder;

        IscsiNestedImpl(ISCSIVolumeSource item) {
            this.builder = new ISCSIVolumeSourceBuilder(this, item);
        }

        IscsiNestedImpl() {
            this.builder = new ISCSIVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withIscsi(this.builder.build());
        }

        @Override
        public N endIscsi() {
            return this.and();
        }
    }

    public class HostPathNestedImpl<N>
    extends HostPathVolumeSourceFluentImpl<PersistentVolumeSpecFluent.HostPathNested<N>>
    implements PersistentVolumeSpecFluent.HostPathNested<N>,
    Nested<N> {
        private final HostPathVolumeSourceBuilder builder;

        HostPathNestedImpl(HostPathVolumeSource item) {
            this.builder = new HostPathVolumeSourceBuilder(this, item);
        }

        HostPathNestedImpl() {
            this.builder = new HostPathVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withHostPath(this.builder.build());
        }

        @Override
        public N endHostPath() {
            return this.and();
        }
    }

    public class GlusterfsNestedImpl<N>
    extends GlusterfsVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GlusterfsNested<N>>
    implements PersistentVolumeSpecFluent.GlusterfsNested<N>,
    Nested<N> {
        private final GlusterfsVolumeSourceBuilder builder;

        GlusterfsNestedImpl(GlusterfsVolumeSource item) {
            this.builder = new GlusterfsVolumeSourceBuilder(this, item);
        }

        GlusterfsNestedImpl() {
            this.builder = new GlusterfsVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withGlusterfs(this.builder.build());
        }

        @Override
        public N endGlusterfs() {
            return this.and();
        }
    }

    public class GcePersistentDiskNestedImpl<N>
    extends GCEPersistentDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GcePersistentDiskNested<N>>
    implements PersistentVolumeSpecFluent.GcePersistentDiskNested<N>,
    Nested<N> {
        private final GCEPersistentDiskVolumeSourceBuilder builder;

        GcePersistentDiskNestedImpl(GCEPersistentDiskVolumeSource item) {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
        }

        GcePersistentDiskNestedImpl() {
            this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withGcePersistentDisk(this.builder.build());
        }

        @Override
        public N endGcePersistentDisk() {
            return this.and();
        }
    }

    public class FlockerNestedImpl<N>
    extends FlockerVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlockerNested<N>>
    implements PersistentVolumeSpecFluent.FlockerNested<N>,
    Nested<N> {
        private final FlockerVolumeSourceBuilder builder;

        FlockerNestedImpl(FlockerVolumeSource item) {
            this.builder = new FlockerVolumeSourceBuilder(this, item);
        }

        FlockerNestedImpl() {
            this.builder = new FlockerVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withFlocker(this.builder.build());
        }

        @Override
        public N endFlocker() {
            return this.and();
        }
    }

    public class FlexVolumeNestedImpl<N>
    extends FlexVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlexVolumeNested<N>>
    implements PersistentVolumeSpecFluent.FlexVolumeNested<N>,
    Nested<N> {
        private final FlexVolumeSourceBuilder builder;

        FlexVolumeNestedImpl(FlexVolumeSource item) {
            this.builder = new FlexVolumeSourceBuilder(this, item);
        }

        FlexVolumeNestedImpl() {
            this.builder = new FlexVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withFlexVolume(this.builder.build());
        }

        @Override
        public N endFlexVolume() {
            return this.and();
        }
    }

    public class FcNestedImpl<N>
    extends FCVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FcNested<N>>
    implements PersistentVolumeSpecFluent.FcNested<N>,
    Nested<N> {
        private final FCVolumeSourceBuilder builder;

        FcNestedImpl(FCVolumeSource item) {
            this.builder = new FCVolumeSourceBuilder(this, item);
        }

        FcNestedImpl() {
            this.builder = new FCVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withFc(this.builder.build());
        }

        @Override
        public N endFc() {
            return this.and();
        }
    }

    public class ClaimRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<PersistentVolumeSpecFluent.ClaimRefNested<N>>
    implements PersistentVolumeSpecFluent.ClaimRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        ClaimRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ClaimRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withClaimRef(this.builder.build());
        }

        @Override
        public N endClaimRef() {
            return this.and();
        }
    }

    public class CinderNestedImpl<N>
    extends CinderVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CinderNested<N>>
    implements PersistentVolumeSpecFluent.CinderNested<N>,
    Nested<N> {
        private final CinderVolumeSourceBuilder builder;

        CinderNestedImpl(CinderVolumeSource item) {
            this.builder = new CinderVolumeSourceBuilder(this, item);
        }

        CinderNestedImpl() {
            this.builder = new CinderVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withCinder(this.builder.build());
        }

        @Override
        public N endCinder() {
            return this.and();
        }
    }

    public class CephfsNestedImpl<N>
    extends CephFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CephfsNested<N>>
    implements PersistentVolumeSpecFluent.CephfsNested<N>,
    Nested<N> {
        private final CephFSVolumeSourceBuilder builder;

        CephfsNestedImpl(CephFSVolumeSource item) {
            this.builder = new CephFSVolumeSourceBuilder(this, item);
        }

        CephfsNestedImpl() {
            this.builder = new CephFSVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withCephfs(this.builder.build());
        }

        @Override
        public N endCephfs() {
            return this.and();
        }
    }

    public class AzureFileNestedImpl<N>
    extends AzureFileVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AzureFileNested<N>>
    implements PersistentVolumeSpecFluent.AzureFileNested<N>,
    Nested<N> {
        private final AzureFileVolumeSourceBuilder builder;

        AzureFileNestedImpl(AzureFileVolumeSource item) {
            this.builder = new AzureFileVolumeSourceBuilder(this, item);
        }

        AzureFileNestedImpl() {
            this.builder = new AzureFileVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withAzureFile(this.builder.build());
        }

        @Override
        public N endAzureFile() {
            return this.and();
        }
    }

    public class AzureDiskNestedImpl<N>
    extends AzureDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AzureDiskNested<N>>
    implements PersistentVolumeSpecFluent.AzureDiskNested<N>,
    Nested<N> {
        private final AzureDiskVolumeSourceBuilder builder;

        AzureDiskNestedImpl(AzureDiskVolumeSource item) {
            this.builder = new AzureDiskVolumeSourceBuilder(this, item);
        }

        AzureDiskNestedImpl() {
            this.builder = new AzureDiskVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withAzureDisk(this.builder.build());
        }

        @Override
        public N endAzureDisk() {
            return this.and();
        }
    }

    public class AwsElasticBlockStoreNestedImpl<N>
    extends AWSElasticBlockStoreVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>>
    implements PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>,
    Nested<N> {
        private final AWSElasticBlockStoreVolumeSourceBuilder builder;

        AwsElasticBlockStoreNestedImpl(AWSElasticBlockStoreVolumeSource item) {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
        }

        AwsElasticBlockStoreNestedImpl() {
            this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeSpecFluentImpl.this.withAwsElasticBlockStore(this.builder.build());
        }

        @Override
        public N endAwsElasticBlockStore() {
            return this.and();
        }
    }
}

