/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_4;

import io.fabric8.kubernetes.api.builder.v2_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_4.Predicate;
import io.fabric8.kubernetes.api.model.v2_4.ContainerImage;
import io.fabric8.kubernetes.api.model.v2_4.ContainerImageFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContainerImageFluentImpl<A extends ContainerImageFluent<A>>
extends BaseFluent<A>
implements ContainerImageFluent<A> {
    private List<String> names = new ArrayList<String>();
    private Long sizeBytes;

    public ContainerImageFluentImpl() {
    }

    public ContainerImageFluentImpl(ContainerImage instance) {
        this.withNames(instance.getNames());
        this.withSizeBytes(instance.getSizeBytes());
    }

    @Override
    public A addToNames(int index, String item) {
        this.names.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNames(int index, String item) {
        this.names.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNames(String ... items) {
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNames(Collection<String> items) {
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNames(String ... items) {
        for (String item : items) {
            this.names.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNames(Collection<String> items) {
        for (String item : items) {
            this.names.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getName(int index) {
        return this.names.get(index);
    }

    @Override
    public String getFirstName() {
        return this.names.get(0);
    }

    @Override
    public String getLastName() {
        return this.names.get(this.names.size() - 1);
    }

    @Override
    public String getMatchingName(Predicate<String> predicate) {
        for (String item : this.names) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withNames(List<String> names) {
        this.names.clear();
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withNames(String ... names) {
        this.names.clear();
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNames() {
        return this.names != null && !this.names.isEmpty();
    }

    @Override
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    @Override
    public A withSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return (A)this;
    }

    @Override
    public Boolean hasSizeBytes() {
        return this.sizeBytes != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerImageFluentImpl that = (ContainerImageFluentImpl)o;
        if (this.names != null ? !this.names.equals(that.names) : that.names != null) {
            return false;
        }
        return !(this.sizeBytes != null ? !this.sizeBytes.equals(that.sizeBytes) : that.sizeBytes != null);
    }
}

