/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_4;

import io.fabric8.kubernetes.api.builder.v2_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_4.Nested;
import io.fabric8.kubernetes.api.builder.v2_4.Predicate;
import io.fabric8.kubernetes.api.model.v2_4.AuthInfo;
import io.fabric8.kubernetes.api.model.v2_4.AuthInfoFluent;
import io.fabric8.kubernetes.api.model.v2_4.AuthProviderConfig;
import io.fabric8.kubernetes.api.model.v2_4.AuthProviderConfigBuilder;
import io.fabric8.kubernetes.api.model.v2_4.AuthProviderConfigFluentImpl;
import io.fabric8.kubernetes.api.model.v2_4.NamedExtension;
import io.fabric8.kubernetes.api.model.v2_4.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.v2_4.NamedExtensionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AuthInfoFluentImpl<A extends AuthInfoFluent<A>>
extends BaseFluent<A>
implements AuthInfoFluent<A> {
    private String as;
    private AuthProviderConfigBuilder authProvider;
    private String clientCertificate;
    private String clientCertificateData;
    private String clientKey;
    private String clientKeyData;
    private List<NamedExtensionBuilder> extensions = new ArrayList<NamedExtensionBuilder>();
    private String password;
    private String token;
    private String tokenFile;
    private String username;

    public AuthInfoFluentImpl() {
    }

    public AuthInfoFluentImpl(AuthInfo instance) {
        this.withAs(instance.getAs());
        this.withAuthProvider(instance.getAuthProvider());
        this.withClientCertificate(instance.getClientCertificate());
        this.withClientCertificateData(instance.getClientCertificateData());
        this.withClientKey(instance.getClientKey());
        this.withClientKeyData(instance.getClientKeyData());
        this.withExtensions(instance.getExtensions());
        this.withPassword(instance.getPassword());
        this.withToken(instance.getToken());
        this.withTokenFile(instance.getTokenFile());
        this.withUsername(instance.getUsername());
    }

    @Override
    public String getAs() {
        return this.as;
    }

    @Override
    public A withAs(String as) {
        this.as = as;
        return (A)this;
    }

    @Override
    public Boolean hasAs() {
        return this.as != null;
    }

    @Override
    @Deprecated
    public AuthProviderConfig getAuthProvider() {
        return this.authProvider != null ? this.authProvider.build() : null;
    }

    @Override
    public AuthProviderConfig buildAuthProvider() {
        return this.authProvider != null ? this.authProvider.build() : null;
    }

    @Override
    public A withAuthProvider(AuthProviderConfig authProvider) {
        this._visitables.remove(this.authProvider);
        if (authProvider != null) {
            this.authProvider = new AuthProviderConfigBuilder(authProvider);
            this._visitables.add(this.authProvider);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthProvider() {
        return this.authProvider != null;
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> withNewAuthProvider() {
        return new AuthProviderNestedImpl();
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> withNewAuthProviderLike(AuthProviderConfig item) {
        return new AuthProviderNestedImpl(item);
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> editAuthProvider() {
        return this.withNewAuthProviderLike(this.getAuthProvider());
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> editOrNewAuthProvider() {
        return this.withNewAuthProviderLike(this.getAuthProvider() != null ? this.getAuthProvider() : new AuthProviderConfigBuilder().build());
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> editOrNewAuthProviderLike(AuthProviderConfig item) {
        return this.withNewAuthProviderLike(this.getAuthProvider() != null ? this.getAuthProvider() : item);
    }

    @Override
    public String getClientCertificate() {
        return this.clientCertificate;
    }

    @Override
    public A withClientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
        return (A)this;
    }

    @Override
    public Boolean hasClientCertificate() {
        return this.clientCertificate != null;
    }

    @Override
    public String getClientCertificateData() {
        return this.clientCertificateData;
    }

    @Override
    public A withClientCertificateData(String clientCertificateData) {
        this.clientCertificateData = clientCertificateData;
        return (A)this;
    }

    @Override
    public Boolean hasClientCertificateData() {
        return this.clientCertificateData != null;
    }

    @Override
    public String getClientKey() {
        return this.clientKey;
    }

    @Override
    public A withClientKey(String clientKey) {
        this.clientKey = clientKey;
        return (A)this;
    }

    @Override
    public Boolean hasClientKey() {
        return this.clientKey != null;
    }

    @Override
    public String getClientKeyData() {
        return this.clientKeyData;
    }

    @Override
    public A withClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
        return (A)this;
    }

    @Override
    public Boolean hasClientKeyData() {
        return this.clientKeyData != null;
    }

    @Override
    public A addToExtensions(int index, NamedExtension item) {
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.extensions.add(index >= 0 ? index : this.extensions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToExtensions(int index, NamedExtension item) {
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.extensions.size()) {
            this.extensions.add(builder);
        } else {
            this.extensions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToExtensions(Collection<NamedExtension> items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove(builder);
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExtensions(Collection<NamedExtension> items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove(builder);
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedExtension> getExtensions() {
        return AuthInfoFluentImpl.build(this.extensions);
    }

    @Override
    public List<NamedExtension> buildExtensions() {
        return AuthInfoFluentImpl.build(this.extensions);
    }

    @Override
    public NamedExtension buildExtension(int index) {
        return this.extensions.get(index).build();
    }

    @Override
    public NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    @Override
    public NamedExtension buildLastExtension() {
        return this.extensions.get(this.extensions.size() - 1).build();
    }

    @Override
    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withExtensions(List<NamedExtension> extensions) {
        this._visitables.removeAll(this.extensions);
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withExtensions(NamedExtension ... extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(-1, item);
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> setNewExtensionLike(int index, NamedExtension item) {
        return new ExtensionsNestedImpl(index, item);
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> editExtension(int index) {
        if (this.extensions.size() <= index) {
            throw new RuntimeException("Can't edit extensions. Index exceeds size.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> editFirstExtension() {
        if (this.extensions.size() == 0) {
            throw new RuntimeException("Can't edit first extensions. The list is empty.");
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> editLastExtension() {
        int index = this.extensions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extensions. The list is empty.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!predicate.apply(this.extensions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extensions. No match found.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    @Override
    public Boolean hasPassword() {
        return this.password != null;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public A withToken(String token) {
        this.token = token;
        return (A)this;
    }

    @Override
    public Boolean hasToken() {
        return this.token != null;
    }

    @Override
    public String getTokenFile() {
        return this.tokenFile;
    }

    @Override
    public A withTokenFile(String tokenFile) {
        this.tokenFile = tokenFile;
        return (A)this;
    }

    @Override
    public Boolean hasTokenFile() {
        return this.tokenFile != null;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    @Override
    public Boolean hasUsername() {
        return this.username != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthInfoFluentImpl that = (AuthInfoFluentImpl)o;
        if (this.as != null ? !this.as.equals(that.as) : that.as != null) {
            return false;
        }
        if (this.authProvider != null ? !this.authProvider.equals(that.authProvider) : that.authProvider != null) {
            return false;
        }
        if (this.clientCertificate != null ? !this.clientCertificate.equals(that.clientCertificate) : that.clientCertificate != null) {
            return false;
        }
        if (this.clientCertificateData != null ? !this.clientCertificateData.equals(that.clientCertificateData) : that.clientCertificateData != null) {
            return false;
        }
        if (this.clientKey != null ? !this.clientKey.equals(that.clientKey) : that.clientKey != null) {
            return false;
        }
        if (this.clientKeyData != null ? !this.clientKeyData.equals(that.clientKeyData) : that.clientKeyData != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.token != null ? !this.token.equals(that.token) : that.token != null) {
            return false;
        }
        if (this.tokenFile != null ? !this.tokenFile.equals(that.tokenFile) : that.tokenFile != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<AuthInfoFluent.ExtensionsNested<N>>
    implements AuthInfoFluent.ExtensionsNested<N>,
    Nested<N> {
        private final NamedExtensionBuilder builder;
        private final int index;

        ExtensionsNestedImpl(int index, NamedExtension item) {
            this.index = index;
            this.builder = new NamedExtensionBuilder(this, item);
        }

        ExtensionsNestedImpl() {
            this.index = -1;
            this.builder = new NamedExtensionBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthInfoFluentImpl.this.setToExtensions(this.index, this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }

    public class AuthProviderNestedImpl<N>
    extends AuthProviderConfigFluentImpl<AuthInfoFluent.AuthProviderNested<N>>
    implements AuthInfoFluent.AuthProviderNested<N>,
    Nested<N> {
        private final AuthProviderConfigBuilder builder;

        AuthProviderNestedImpl(AuthProviderConfig item) {
            this.builder = new AuthProviderConfigBuilder(this, item);
        }

        AuthProviderNestedImpl() {
            this.builder = new AuthProviderConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthInfoFluentImpl.this.withAuthProvider(this.builder.build());
        }

        @Override
        public N endAuthProvider() {
            return this.and();
        }
    }
}

