/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v2_4;

import io.fabric8.kubernetes.api.builder.v2_4.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v2_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v2_4.AuthInfo;
import io.fabric8.kubernetes.api.model.v2_4.AuthInfoFluent;
import io.fabric8.kubernetes.api.model.v2_4.AuthInfoFluentImpl;

public class AuthInfoBuilder
extends AuthInfoFluentImpl<AuthInfoBuilder>
implements VisitableBuilder<AuthInfo, AuthInfoBuilder> {
    AuthInfoFluent<?> fluent;
    Boolean validationEnabled;

    public AuthInfoBuilder() {
        this(true);
    }

    public AuthInfoBuilder(Boolean validationEnabled) {
        this(new AuthInfo(), validationEnabled);
    }

    public AuthInfoBuilder(AuthInfoFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AuthInfoBuilder(AuthInfoFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AuthInfo(), validationEnabled);
    }

    public AuthInfoBuilder(AuthInfoFluent<?> fluent, AuthInfo instance) {
        this(fluent, instance, true);
    }

    public AuthInfoBuilder(AuthInfoFluent<?> fluent, AuthInfo instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAs(instance.getAs());
        fluent.withAuthProvider(instance.getAuthProvider());
        fluent.withClientCertificate(instance.getClientCertificate());
        fluent.withClientCertificateData(instance.getClientCertificateData());
        fluent.withClientKey(instance.getClientKey());
        fluent.withClientKeyData(instance.getClientKeyData());
        fluent.withExtensions(instance.getExtensions());
        fluent.withPassword(instance.getPassword());
        fluent.withToken(instance.getToken());
        fluent.withTokenFile(instance.getTokenFile());
        fluent.withUsername(instance.getUsername());
        this.validationEnabled = validationEnabled;
    }

    public AuthInfoBuilder(AuthInfo instance) {
        this(instance, (Boolean)true);
    }

    public AuthInfoBuilder(AuthInfo instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAs(instance.getAs());
        this.withAuthProvider(instance.getAuthProvider());
        this.withClientCertificate(instance.getClientCertificate());
        this.withClientCertificateData(instance.getClientCertificateData());
        this.withClientKey(instance.getClientKey());
        this.withClientKeyData(instance.getClientKeyData());
        this.withExtensions(instance.getExtensions());
        this.withPassword(instance.getPassword());
        this.withToken(instance.getToken());
        this.withTokenFile(instance.getTokenFile());
        this.withUsername(instance.getUsername());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public AuthInfo build() {
        AuthInfo buildable = new AuthInfo(this.fluent.getAs(), this.fluent.getAuthProvider(), this.fluent.getClientCertificate(), this.fluent.getClientCertificateData(), this.fluent.getClientKey(), this.fluent.getClientKeyData(), this.fluent.getExtensions(), this.fluent.getPassword(), this.fluent.getToken(), this.fluent.getTokenFile(), this.fluent.getUsername());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthInfoBuilder that = (AuthInfoBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

