/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder.v2_4;

import io.fabric8.kubernetes.api.builder.v2_4.TypedVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PathAwareTypedVisitor<V, P>
extends TypedVisitor<V> {
    private List<Object> path;
    private final PathAwareTypedVisitor<V, P> delegate;
    private final Class parentType;

    public PathAwareTypedVisitor() {
        this.path = new ArrayList<Object>();
        this.delegate = this;
        this.parentType = PathAwareTypedVisitor.getTypeArguments(PathAwareTypedVisitor.class, this.getClass()).get(1);
    }

    public PathAwareTypedVisitor(List<Object> path) {
        this.path = path;
        this.delegate = this;
        this.parentType = PathAwareTypedVisitor.getTypeArguments(PathAwareTypedVisitor.class, this.getClass()).get(1);
    }

    public PathAwareTypedVisitor(List<Object> path, PathAwareTypedVisitor delegate) {
        this.path = path;
        this.delegate = delegate;
        this.parentType = PathAwareTypedVisitor.getTypeArguments(PathAwareTypedVisitor.class, delegate.getClass()).get(1);
    }

    public PathAwareTypedVisitor next(Object item) {
        ArrayList<Object> path = new ArrayList<Object>(this.path);
        path.add(item);
        return new PathAwareTypedVisitor<V, P>(path, this);
    }

    @Override
    public void visit(V element) {
        this.delegate.path = this.path;
        this.delegate.visit(element);
    }

    public P getParent() {
        int size = this.path.size();
        int parentIndex = size - 2;
        if (parentIndex >= 0) {
            return (P)this.path.get(parentIndex);
        }
        return null;
    }

    public List<Object> getPath() {
        return Collections.unmodifiableList(this.path);
    }

    @Override
    public Class getType() {
        Class superType = super.getType();
        if (superType != null) {
            return superType;
        }
        return this.delegate.getType();
    }

    public Class getParentType() {
        if (this.parentType != null) {
            return this.parentType;
        }
        return this.delegate.getParentType();
    }

    Class getActualParentType() {
        int size = this.path.size();
        int parentIndex = size - 2;
        if (parentIndex >= 0) {
            return this.path.get(parentIndex).getClass();
        }
        return Void.class;
    }
}

