/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v2_3;

import io.fabric8.kubernetes.api.model.v2_3.ComponentStatus;
import io.fabric8.kubernetes.api.model.v2_3.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v2_3.ConfigMap;
import io.fabric8.kubernetes.api.model.v2_3.ConfigMapList;
import io.fabric8.kubernetes.api.model.v2_3.DoneableComponentStatus;
import io.fabric8.kubernetes.api.model.v2_3.DoneableConfigMap;
import io.fabric8.kubernetes.api.model.v2_3.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.v2_3.DoneableEvent;
import io.fabric8.kubernetes.api.model.v2_3.DoneableLimitRange;
import io.fabric8.kubernetes.api.model.v2_3.DoneableNamespace;
import io.fabric8.kubernetes.api.model.v2_3.DoneableNode;
import io.fabric8.kubernetes.api.model.v2_3.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.v2_3.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v2_3.DoneablePod;
import io.fabric8.kubernetes.api.model.v2_3.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.v2_3.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.v2_3.DoneableSecret;
import io.fabric8.kubernetes.api.model.v2_3.DoneableSecurityContextConstraints;
import io.fabric8.kubernetes.api.model.v2_3.DoneableService;
import io.fabric8.kubernetes.api.model.v2_3.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.v2_3.Endpoints;
import io.fabric8.kubernetes.api.model.v2_3.EndpointsList;
import io.fabric8.kubernetes.api.model.v2_3.Event;
import io.fabric8.kubernetes.api.model.v2_3.EventList;
import io.fabric8.kubernetes.api.model.v2_3.HasMetadata;
import io.fabric8.kubernetes.api.model.v2_3.KubernetesList;
import io.fabric8.kubernetes.api.model.v2_3.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v2_3.LimitRange;
import io.fabric8.kubernetes.api.model.v2_3.LimitRangeList;
import io.fabric8.kubernetes.api.model.v2_3.Namespace;
import io.fabric8.kubernetes.api.model.v2_3.NamespaceList;
import io.fabric8.kubernetes.api.model.v2_3.Node;
import io.fabric8.kubernetes.api.model.v2_3.NodeList;
import io.fabric8.kubernetes.api.model.v2_3.PersistentVolume;
import io.fabric8.kubernetes.api.model.v2_3.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v2_3.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v2_3.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v2_3.Pod;
import io.fabric8.kubernetes.api.model.v2_3.PodList;
import io.fabric8.kubernetes.api.model.v2_3.ReplicationController;
import io.fabric8.kubernetes.api.model.v2_3.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v2_3.ResourceQuota;
import io.fabric8.kubernetes.api.model.v2_3.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v2_3.Secret;
import io.fabric8.kubernetes.api.model.v2_3.SecretList;
import io.fabric8.kubernetes.api.model.v2_3.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.v2_3.SecurityContextConstraintsList;
import io.fabric8.kubernetes.api.model.v2_3.Service;
import io.fabric8.kubernetes.api.model.v2_3.ServiceAccount;
import io.fabric8.kubernetes.api.model.v2_3.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v2_3.ServiceList;
import io.fabric8.kubernetes.clnt.v2_3.AppsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v2_3.BaseClient;
import io.fabric8.kubernetes.clnt.v2_3.Config;
import io.fabric8.kubernetes.clnt.v2_3.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v2_3.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v2_3.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v2_3.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v2_3.RequestConfig;
import io.fabric8.kubernetes.clnt.v2_3.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v2_3.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v2_3.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v2_3.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v2_3.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v2_3.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v2_3.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v2_3.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v2_3.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v2_3.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.clnt.v2_3.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v2_3.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v2_3.dsl.Resource;
import io.fabric8.kubernetes.clnt.v2_3.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v2_3.dsl.internal.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.clnt.v2_3.utils.Serialization;
import io.fabric8.openshift.api.model.v2_3.Build;
import io.fabric8.openshift.api.model.v2_3.BuildConfig;
import io.fabric8.openshift.api.model.v2_3.BuildConfigList;
import io.fabric8.openshift.api.model.v2_3.BuildList;
import io.fabric8.openshift.api.model.v2_3.ClusterRoleBinding;
import io.fabric8.openshift.api.model.v2_3.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.v2_3.DeploymentConfig;
import io.fabric8.openshift.api.model.v2_3.DeploymentConfigList;
import io.fabric8.openshift.api.model.v2_3.DoneableBuild;
import io.fabric8.openshift.api.model.v2_3.DoneableBuildConfig;
import io.fabric8.openshift.api.model.v2_3.DoneableClusterRoleBinding;
import io.fabric8.openshift.api.model.v2_3.DoneableDeploymentConfig;
import io.fabric8.openshift.api.model.v2_3.DoneableGroup;
import io.fabric8.openshift.api.model.v2_3.DoneableImageStream;
import io.fabric8.openshift.api.model.v2_3.DoneableImageStreamTag;
import io.fabric8.openshift.api.model.v2_3.DoneableOAuthAccessToken;
import io.fabric8.openshift.api.model.v2_3.DoneableOAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v2_3.DoneableOAuthClient;
import io.fabric8.openshift.api.model.v2_3.DoneablePolicy;
import io.fabric8.openshift.api.model.v2_3.DoneablePolicyBinding;
import io.fabric8.openshift.api.model.v2_3.DoneableProject;
import io.fabric8.openshift.api.model.v2_3.DoneableRole;
import io.fabric8.openshift.api.model.v2_3.DoneableRoleBinding;
import io.fabric8.openshift.api.model.v2_3.DoneableRoute;
import io.fabric8.openshift.api.model.v2_3.DoneableTemplate;
import io.fabric8.openshift.api.model.v2_3.DoneableUser;
import io.fabric8.openshift.api.model.v2_3.Group;
import io.fabric8.openshift.api.model.v2_3.GroupList;
import io.fabric8.openshift.api.model.v2_3.ImageStream;
import io.fabric8.openshift.api.model.v2_3.ImageStreamList;
import io.fabric8.openshift.api.model.v2_3.ImageStreamTag;
import io.fabric8.openshift.api.model.v2_3.ImageStreamTagList;
import io.fabric8.openshift.api.model.v2_3.OAuthAccessToken;
import io.fabric8.openshift.api.model.v2_3.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.v2_3.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v2_3.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.v2_3.OAuthClient;
import io.fabric8.openshift.api.model.v2_3.OAuthClientList;
import io.fabric8.openshift.api.model.v2_3.Policy;
import io.fabric8.openshift.api.model.v2_3.PolicyBinding;
import io.fabric8.openshift.api.model.v2_3.PolicyBindingList;
import io.fabric8.openshift.api.model.v2_3.PolicyList;
import io.fabric8.openshift.api.model.v2_3.Project;
import io.fabric8.openshift.api.model.v2_3.ProjectList;
import io.fabric8.openshift.api.model.v2_3.Role;
import io.fabric8.openshift.api.model.v2_3.RoleBinding;
import io.fabric8.openshift.api.model.v2_3.RoleBindingList;
import io.fabric8.openshift.api.model.v2_3.RoleList;
import io.fabric8.openshift.api.model.v2_3.Route;
import io.fabric8.openshift.api.model.v2_3.RouteList;
import io.fabric8.openshift.api.model.v2_3.Template;
import io.fabric8.openshift.api.model.v2_3.TemplateList;
import io.fabric8.openshift.api.model.v2_3.User;
import io.fabric8.openshift.api.model.v2_3.UserList;
import io.fabric8.openshift.clnt.v2_3.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v2_3.OpenShiftConfig;
import io.fabric8.openshift.clnt.v2_3.OpenShiftConfigBuilder;
import io.fabric8.openshift.clnt.v2_3.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v2_3.dsl.BuildResource;
import io.fabric8.openshift.clnt.v2_3.dsl.CreateableLocalSubjectAccessReview;
import io.fabric8.openshift.clnt.v2_3.dsl.CreateableSubjectAccessReview;
import io.fabric8.openshift.clnt.v2_3.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v2_3.dsl.ProjectRequestOperation;
import io.fabric8.openshift.clnt.v2_3.dsl.SubjectAccessReviewOperation;
import io.fabric8.openshift.clnt.v2_3.dsl.TemplateResource;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.BuildConfigOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.BuildOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.ClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.GroupOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.ImageStreamOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.ImageStreamTagOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.OAuthClientOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.PolicyBindingOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.PolicyOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.ProjectOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.ProjectRequestsOperationImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.RoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.RoleOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.RouteOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.SubjectAccessReviewOperationImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.TemplateOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.dsl.internal.UserOperationsImpl;
import io.fabric8.openshift.clnt.v2_3.internal.OpenShiftOAuthInterceptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class DefaultOpenShiftClient
extends BaseClient
implements NamespacedOpenShiftClient {
    private URL openShiftUrl;
    private NamespacedKubernetesClient delegate;

    public DefaultOpenShiftClient() throws KubernetesClientException {
        this(new OpenShiftConfigBuilder().build());
    }

    public DefaultOpenShiftClient(String masterUrl) throws KubernetesClientException {
        this(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public DefaultOpenShiftClient(Config config) throws KubernetesClientException {
        this(new OpenShiftConfig(config));
    }

    public DefaultOpenShiftClient(OpenShiftConfig config) throws KubernetesClientException {
        super(config);
        try {
            this.httpClient = this.clientWithOpenShiftOAuthInterceptor(this.httpClient);
            this.delegate = new DefaultKubernetesClient(this.httpClient, config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    protected DefaultOpenShiftClient(OkHttpClient httpClient, OpenShiftConfig config) throws KubernetesClientException {
        super(httpClient, config);
        try {
            this.delegate = new DefaultKubernetesClient(this.clientWithOpenShiftOAuthInterceptor(httpClient), config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    public static DefaultOpenShiftClient fromConfig(String config) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(config, OpenShiftConfig.class));
    }

    public static DefaultOpenShiftClient fromConfig(InputStream is) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(is, OpenShiftConfig.class));
    }

    private OkHttpClient clientWithOpenShiftOAuthInterceptor(OkHttpClient httpClient) {
        httpClient = httpClient.newBuilder().authenticator(Authenticator.NONE).build();
        OkHttpClient.Builder builder = httpClient.newBuilder();
        builder.interceptors().clear();
        return builder.addInterceptor((Interceptor)new OpenShiftOAuthInterceptor(httpClient, OpenShiftConfig.wrap(this.getConfiguration()))).build();
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, DoneableComponentStatus, Resource<ComponentStatus, DoneableComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> load(InputStream is) {
        return this.delegate.load(is);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(HasMetadata item) {
        return this.delegate.resource(item);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata, Boolean> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(KubernetesResourceList is) {
        return this.delegate.resourceList(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(HasMetadata ... items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata, Boolean> resourceList(String s) {
        return this.delegate.resourceList(s);
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, DoneableEndpoints, Resource<Endpoints, DoneableEndpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Event, EventList, DoneableEvent, Resource<Event, DoneableEvent>> events() {
        return this.delegate.events();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, DoneableNamespace, Resource<Namespace, DoneableNamespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, DoneableNode, Resource<Node, DoneableNode>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, Resource<PersistentVolume, DoneablePersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, Resource<PersistentVolumeClaim, DoneablePersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, DoneablePod, PodResource<Pod, DoneablePod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, RollableScalableResource<ReplicationController, DoneableReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, Resource<ResourceQuota, DoneableResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, DoneableSecret, Resource<Secret, DoneableSecret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<Service, ServiceList, DoneableService, Resource<Service, DoneableService>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, Resource<ServiceAccount, DoneableServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, Resource<SecurityContextConstraints, DoneableSecurityContextConstraints>> securityContextConstraints() {
        return this.delegate.securityContextConstraints();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, DoneableConfigMap, Resource<ConfigMap, DoneableConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, DoneableLimitRange, Resource<LimitRange, DoneableLimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public MixedOperation<Build, BuildList, DoneableBuild, BuildResource<Build, DoneableBuild, String, LogWatch>> builds() {
        return new BuildOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, DoneableBuildConfig, BuildConfigResource<BuildConfig, DoneableBuildConfig, Void, Build>> buildConfigs() {
        return new BuildConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    public MixedOperation<Group, GroupList, DoneableGroup, Resource<Group, DoneableGroup>> groups() {
        return new GroupOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, DoneableImageStream, Resource<ImageStream, DoneableImageStream>> imageStreams() {
        return new ImageStreamOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, DoneableImageStreamTag, Resource<ImageStreamTag, DoneableImageStreamTag>> imageStreamTags() {
        return new ImageStreamTagOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, DoneableOAuthAccessToken, Resource<OAuthAccessToken, DoneableOAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, DoneableOAuthAuthorizeToken, Resource<OAuthAuthorizeToken, DoneableOAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, DoneableOAuthClient, Resource<OAuthClient, DoneableOAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<Policy, PolicyList, DoneablePolicy, Resource<Policy, DoneablePolicy>> policies() {
        return new PolicyOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<PolicyBinding, PolicyBindingList, DoneablePolicyBinding, Resource<PolicyBinding, DoneablePolicyBinding>> policyBindings() {
        return new PolicyBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public NonNamespaceOperation<Project, ProjectList, DoneableProject, Resource<Project, DoneableProject>> projects() {
        return new ProjectOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return new ProjectRequestsOperationImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<Role, RoleList, DoneableRole, Resource<Role, DoneableRole>> roles() {
        return new RoleOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<RoleBinding, RoleBindingList, DoneableRoleBinding, Resource<RoleBinding, DoneableRoleBinding>> roleBindings() {
        return new RoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public MixedOperation<Route, RouteList, DoneableRoute, Resource<Route, DoneableRoute>> routes() {
        return new RouteOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, DoneableTemplate, TemplateResource<Template, KubernetesList, DoneableTemplate>> templates() {
        return new TemplateOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    public MixedOperation<User, UserList, DoneableUser, Resource<User, DoneableUser>> users() {
        return new UserOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public SubjectAccessReviewOperation<CreateableSubjectAccessReview, CreateableLocalSubjectAccessReview> subjectAccessReviews() {
        return new SubjectAccessReviewOperationImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), null, this.getNamespace());
    }

    @Override
    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, DoneableClusterRoleBinding, Resource<ClusterRoleBinding, DoneableClusterRoleBinding>> clusterRoleBindings() {
        return new ClusterRoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()), this.getNamespace());
    }

    @Override
    public NamespacedOpenShiftClient inNamespace(String namespace) {
        OpenShiftConfig updated = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(new OpenShiftConfig(this.getConfiguration())).withOpenShiftUrl(this.openShiftUrl.toString())).withNamespace(namespace)).build();
        return new DefaultOpenShiftClient(this.httpClient, updated);
    }

    @Override
    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupClient extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedOpenShiftClient>(this, requestConfig);
    }

    @Override
    public User currentUser() {
        return (User)((Resource)this.users().withName("~")).get();
    }
}

