/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v2_3;

import io.fabric8.kubernetes.api.builder.v2_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_3.Nested;
import io.fabric8.kubernetes.api.builder.v2_3.Predicate;
import io.fabric8.openshift.api.model.v2_3.ServiceAccountReference;
import io.fabric8.openshift.api.model.v2_3.ServiceAccountReferenceBuilder;
import io.fabric8.openshift.api.model.v2_3.ServiceAccountReferenceFluentImpl;
import io.fabric8.openshift.api.model.v2_3.ServiceAccountRestriction;
import io.fabric8.openshift.api.model.v2_3.ServiceAccountRestrictionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ServiceAccountRestrictionFluentImpl<A extends ServiceAccountRestrictionFluent<A>>
extends BaseFluent<A>
implements ServiceAccountRestrictionFluent<A> {
    private List<String> namespaces = new ArrayList<String>();
    private List<ServiceAccountReferenceBuilder> serviceaccounts = new ArrayList<ServiceAccountReferenceBuilder>();

    public ServiceAccountRestrictionFluentImpl() {
    }

    public ServiceAccountRestrictionFluentImpl(ServiceAccountRestriction instance) {
        this.withNamespaces(instance.getNamespaces());
        this.withServiceaccounts(instance.getServiceaccounts());
    }

    @Override
    public A addToNamespaces(int index, String item) {
        this.namespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNamespaces(int index, String item) {
        this.namespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNamespaces(String ... items) {
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNamespaces(Collection<String> items) {
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNamespaces(String ... items) {
        for (String item : items) {
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    @Override
    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    @Override
    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    @Override
    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withNamespaces(List<String> namespaces) {
        this.namespaces.clear();
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withNamespaces(String ... namespaces) {
        this.namespaces.clear();
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    public A addToServiceaccounts(int index, ServiceAccountReference item) {
        ServiceAccountReferenceBuilder builder = new ServiceAccountReferenceBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.serviceaccounts.add(index >= 0 ? index : this.serviceaccounts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServiceaccounts(int index, ServiceAccountReference item) {
        ServiceAccountReferenceBuilder builder = new ServiceAccountReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.serviceaccounts.size()) {
            this.serviceaccounts.add(builder);
        } else {
            this.serviceaccounts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServiceaccounts(ServiceAccountReference ... items) {
        for (ServiceAccountReference item : items) {
            ServiceAccountReferenceBuilder builder = new ServiceAccountReferenceBuilder(item);
            this._visitables.add(builder);
            this.serviceaccounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceaccounts(Collection<ServiceAccountReference> items) {
        for (ServiceAccountReference item : items) {
            ServiceAccountReferenceBuilder builder = new ServiceAccountReferenceBuilder(item);
            this._visitables.add(builder);
            this.serviceaccounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceaccounts(ServiceAccountReference ... items) {
        for (ServiceAccountReference item : items) {
            ServiceAccountReferenceBuilder builder = new ServiceAccountReferenceBuilder(item);
            this._visitables.remove(builder);
            this.serviceaccounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceaccounts(Collection<ServiceAccountReference> items) {
        for (ServiceAccountReference item : items) {
            ServiceAccountReferenceBuilder builder = new ServiceAccountReferenceBuilder(item);
            this._visitables.remove(builder);
            this.serviceaccounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServiceAccountReference> getServiceaccounts() {
        return ServiceAccountRestrictionFluentImpl.build(this.serviceaccounts);
    }

    @Override
    public List<ServiceAccountReference> buildServiceaccounts() {
        return ServiceAccountRestrictionFluentImpl.build(this.serviceaccounts);
    }

    @Override
    public ServiceAccountReference buildServiceaccount(int index) {
        return this.serviceaccounts.get(index).build();
    }

    @Override
    public ServiceAccountReference buildFirstServiceaccount() {
        return this.serviceaccounts.get(0).build();
    }

    @Override
    public ServiceAccountReference buildLastServiceaccount() {
        return this.serviceaccounts.get(this.serviceaccounts.size() - 1).build();
    }

    @Override
    public ServiceAccountReference buildMatchingServiceaccount(Predicate<ServiceAccountReferenceBuilder> predicate) {
        for (ServiceAccountReferenceBuilder item : this.serviceaccounts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withServiceaccounts(List<ServiceAccountReference> serviceaccounts) {
        this._visitables.removeAll(this.serviceaccounts);
        this.serviceaccounts.clear();
        if (serviceaccounts != null) {
            for (ServiceAccountReference item : serviceaccounts) {
                this.addToServiceaccounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withServiceaccounts(ServiceAccountReference ... serviceaccounts) {
        this.serviceaccounts.clear();
        if (serviceaccounts != null) {
            for (ServiceAccountReference item : serviceaccounts) {
                this.addToServiceaccounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceaccounts() {
        return this.serviceaccounts != null && !this.serviceaccounts.isEmpty();
    }

    @Override
    public ServiceAccountRestrictionFluent.ServiceaccountsNested<A> addNewServiceaccount() {
        return new ServiceaccountsNestedImpl();
    }

    @Override
    public ServiceAccountRestrictionFluent.ServiceaccountsNested<A> addNewServiceaccountLike(ServiceAccountReference item) {
        return new ServiceaccountsNestedImpl(-1, item);
    }

    @Override
    public ServiceAccountRestrictionFluent.ServiceaccountsNested<A> setNewServiceaccountLike(int index, ServiceAccountReference item) {
        return new ServiceaccountsNestedImpl(index, item);
    }

    @Override
    public ServiceAccountRestrictionFluent.ServiceaccountsNested<A> editServiceaccount(int index) {
        if (this.serviceaccounts.size() <= index) {
            throw new RuntimeException("Can't edit serviceaccounts. Index exceeds size.");
        }
        return this.setNewServiceaccountLike(index, this.buildServiceaccount(index));
    }

    @Override
    public ServiceAccountRestrictionFluent.ServiceaccountsNested<A> editFirstServiceaccount() {
        if (this.serviceaccounts.size() == 0) {
            throw new RuntimeException("Can't edit first serviceaccounts. The list is empty.");
        }
        return this.setNewServiceaccountLike(0, this.buildServiceaccount(0));
    }

    @Override
    public ServiceAccountRestrictionFluent.ServiceaccountsNested<A> editLastServiceaccount() {
        int index = this.serviceaccounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceaccounts. The list is empty.");
        }
        return this.setNewServiceaccountLike(index, this.buildServiceaccount(index));
    }

    @Override
    public ServiceAccountRestrictionFluent.ServiceaccountsNested<A> editMatchingServiceaccount(Predicate<ServiceAccountReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceaccounts.size(); ++i) {
            if (!predicate.apply(this.serviceaccounts.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceaccounts. No match found.");
        }
        return this.setNewServiceaccountLike(index, this.buildServiceaccount(index));
    }

    @Override
    public A addNewServiceaccount(String name, String namespace) {
        return this.addToServiceaccounts(new ServiceAccountReference(name, namespace));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceAccountRestrictionFluentImpl that = (ServiceAccountRestrictionFluentImpl)o;
        if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) {
            return false;
        }
        return !(this.serviceaccounts != null ? !this.serviceaccounts.equals(that.serviceaccounts) : that.serviceaccounts != null);
    }

    public class ServiceaccountsNestedImpl<N>
    extends ServiceAccountReferenceFluentImpl<ServiceAccountRestrictionFluent.ServiceaccountsNested<N>>
    implements ServiceAccountRestrictionFluent.ServiceaccountsNested<N>,
    Nested<N> {
        private final ServiceAccountReferenceBuilder builder;
        private final int index;

        ServiceaccountsNestedImpl(int index, ServiceAccountReference item) {
            this.index = index;
            this.builder = new ServiceAccountReferenceBuilder(this, item);
        }

        ServiceaccountsNestedImpl() {
            this.index = -1;
            this.builder = new ServiceAccountReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceAccountRestrictionFluentImpl.this.setToServiceaccounts(this.index, this.builder.build());
        }

        @Override
        public N endServiceaccount() {
            return this.and();
        }
    }
}

